<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use InternetGalerie\Igshop2\Domain\Model\Shipping;
use InternetGalerie\Igshop2\Domain\Model\ShippingService;
use TYPO3\CMS\Extbase\Persistence\Generic\Qom\ConstraintInterface;
use TYPO3\CMS\Extbase\Persistence\Generic\Query;
use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for Shippings
 */
class ShippingRepository extends Repository
{
    protected $defaultOrderings = [
        'price' => QueryInterface::ORDER_ASCENDING
    ];

    protected function createMinMaxConstraint(Query $query, string $minField, string $maxField, mixed $value): ConstraintInterface
    {
        return $query->logicalOr(
            $query->logicalAnd(
                $query->lessThanOrEqual($minField, $value),
                $query->greaterThanOrEqual($maxField, $value),
            ),
            $query->logicalAnd(
                $query->equals($minField, null),
                $query->greaterThanOrEqual($maxField, $value),
            ),
            $query->logicalAnd(
                $query->lessThanOrEqual($minField, $value),
                $query->equals($maxField, null),
            ),
            $query->logicalAnd(
                $query->equals($minField, null),
                $query->equals($maxField, null),
            ),
        );
    }

    public function findOneByShippingServiceAndSearch(?ShippingService $shippingService = null, array $search = []): ?Shipping
    {
        $query = $this->createQuery();

        $constraints = [];

        if($shippingService) {
            $constraints[] = $query->equals('service', $shippingService->getUid());
        }

        if(!empty($search)) {
            if(isset($search['weight']) && $search['weight'] !== null) {
                $constraints[] = $this->createMinMaxConstraint($query, 'minWeight', 'maxWeight', $search['weight']);
            }
            if (isset($search['quantity']) && $search['quantity'] !== null) {
                $constraints[] = $this->createMinMaxConstraint($query, 'minQuantity', 'maxQuantity', $search['quantity']);
            }
            if (isset($search['price']) && $search['price'] !== null) {
                $constraints[] = $this->createMinMaxConstraint($query, 'minPrice', 'maxPrice', $search['price']);
            }
            if (isset($search['shippingLabels']) && !empty($search['shippingLabels'])) {
                $shippingLabelsConstraint = [];
                foreach($search['shippingLabels'] as $shippingLabel) {
                    $shippingLabelsConstraint[] = $query->contains('shippingLabels', $shippingLabel->getUid());
                }
                $constraints[] = $query->logicalAnd(...$shippingLabelsConstraint);
            } else {
                $constraints[] = $query->equals('shippingLabels', 0);
            }
        }

        if(!empty($constraints)) {
            $query->matching($query->logicalAnd(...$constraints));
        }

        return $query->execute()->getFirst();
    }
}
