<?php

namespace InternetGalerie\Igshop2\Service;

use DateTime;
use InternetGalerie\Igshop2\Domain\Model\Product;
use InternetGalerie\Igshop2\Domain\Repository\OrderProductRepository;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\SingletonInterface;

class StockService implements SingletonInterface
{

    public function __construct(
        protected OrderProductRepository $orderProductRepository,
        protected Context $context,
    ) { }

    /**
     * Get reserved quantity for a product in pending/reserved orders
     */
    public function getReservedQuantity(Product $product, ?int $cartId = null, ?int $frontendUserId = null): int
    {
        return $this->orderProductRepository->getReservedQuantityForProduct($product, $cartId, $frontendUserId);
    }

    // public function getReservedQuantityForUser(Product $product): int
    // {
    //     $currentUserId = $this->context->getPropertyFromAspect('frontend.user', 'id');
    //     return $this->orderProductRepository->getReservedQuantityForProduct($product, $currentUserId);
    // }

    /**
     * Compute available stock
     */
    public function getAvailableStock(Product $product, ?int $cartId = null, ?int $frontendUserId = null): ?int
    {
        if (!$product->hasStock()) {
            return null; // stock not used
        }

        $reserved = $this->getReservedQuantity($product, $cartId, $frontendUserId);
        $available = $product->getStock() - $reserved;

        if ($product->allowsBackorder()) {
            return $available; // can be negative
        }

        return max(0, $available);
    }


}

