<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use InternetGalerie\Igshop2\Domain\Model\Currency;
use InternetGalerie\Igshop2\Domain\Model\Product;
use InternetGalerie\Igshop2\Domain\Model\OptionWithPrice;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class CurrencyViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument(
            'currency',
            Currency::class,
            'Specifies where to open the linked document',
            true
        );
        $this->registerArgument('price', 'float', 'Specifies where to open the linked document', false, 0);
        $this->registerArgument(
            'withoutCode',
            'boolean',
            'Specifies where to open the linked document',
            false,
            false
        );
        $this->registerArgument(
            'product',
            Product::class,
            'Specifies where to open the linked document',
            false,
            null
        );
        $this->registerArgument(
            'optionWithPrice',
            OptionWithPrice::class,
            'Specifies where to open the linked document',
            false,
            null
        );
        $this->registerArgument(
            'checkForPromotion',
            'boolean',
            'Specifies where to open the linked document',
            false,
            false
        );
        $this->registerArgument('wrap', 'bool', 'Wrap around price', false, false);
    }

    public function renderByArguments(
        $currency,
        $price = 0,
        $withoutCode = false,
        $product = null,
        $optionWithPrice = null,
        $checkForPromotion = false
    ): string {
        $this->arguments['currency'] = $currency;
        $this->arguments['price'] = $price;
        $this->arguments['withoutCode'] = $withoutCode;
        $this->arguments['product'] = $product;
        $this->arguments['optionWithPrice'] = $optionWithPrice;
        $this->arguments['checkForPromotion'] = $checkForPromotion;
        return $this->render();
    }

    /**
     * Rounds the price to CHF norm
     */
    public function render(): string
    {
        $currency = $this->arguments['currency'];
        $price = $this->arguments['price'];
        $withoutCode = $this->arguments['withoutCode'];
        $product = $this->arguments['product'];
        $optionWithPrice = $this->arguments['optionWithPrice'];
        $checkForPromotion = $this->arguments['checkForPromotion'];
        $wrap = $this->arguments['wrap'] ?? false;

        if (is_object($optionWithPrice)) {
            if ($currency->getShort() == 'EUR' && $optionWithPrice->getPriceEuro() !== null) {
                $price = $optionWithPrice->getPriceEuro();
            } else {
                $price = $optionWithPrice->getPrice() * $currency->getFaktor();
            }
        }

        if (is_object($product)) {
            $price = $product->getFinalPrice($currency, 0, 0, $checkForPromotion);
        }

        //var_dump($price);
        if (is_array($price)) {
            $promotePrice = static::format($currency, $price['price'], $withoutCode);
            $origPrice = static::format($currency, $price['origPrice'], $withoutCode);
            return '<div class="origPrice hasPromoPrice">' . $origPrice . '</div><div class="promoPrice">' . $promotePrice . '</div>';
        }

        $price = ($wrap ? '<div class="noPromoPrice">' : '') . static::format(
            $currency,
            $price,
            $withoutCode
        ) . ($wrap ? '</div>' : '');


        return $price;
    }

    public static function format($currency, $price, $withoutCode): string
    {
        $thousandSeparator = $currency->getThousandSeparator();
        $commaSeparator = $currency->getCommaSeparator();
        $return = 0;

        if ($price) {
            if ($currency->getRounding()) {
                $rounding = $currency->getRounding();
                if ($thousandSeparator != null && $commaSeparator != null) {
                    $return = number_format(
                        round($price * (1 / $rounding)) / (1 / $rounding),
                        2,
                        $commaSeparator,
                        $thousandSeparator
                    );
                } else {
                    $return = number_format(round($price * (1 / $rounding)) / (1 / $rounding), 2);
                }
            } else {
                if ($thousandSeparator != null && $commaSeparator != null) {
                    $return = number_format($price, 2, $commaSeparator, $thousandSeparator);
                } else {
                    $return = number_format($price, 2);
                }
            }
        }

        if ($withoutCode) {
            return $return;
        }

        if ($currency->getAfterPrice()) {
            return $return . ' ' . $currency->getSymbol();
        } elseif ($return > 0) {
            return $currency->getShort() . ' ' . $return;
        }

        return LocalizationUtility::translate(
            'tx_igshop2_domain_model_product.free',
            'igshop2'
        );
    }
}
