<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Form;

use Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\SelectViewHelper;
class DropDownViewHelper extends SelectViewHelper
{
    /**
     * @var string
     */
    protected $tagName = 'div';

    /**
     * Initialize the arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
    }

    /**
     * Renders the textfield.
     */
    public function render(): string
    {
        $class = 'igShop_popup';
        if ($this->tag->hasAttribute('class')) {
            $this->tag->addAttribute('class', $class . ' ' . $this->tag->getAttribute('class'));
            $this->arguments['class'] = $class . ' ' . $this->tag->getAttribute('class');
        } else {
            $this->tag->addAttribute('class', $class);
            $this->arguments['class'] = $class;
        }

        return parent::render();
    }

    protected function renderPrependOptionTag(): string
    {
        if (isset($this->arguments['prependOptionLabel']) && $this->arguments['prependOptionLabel']) {
            //$value = $this->hasArgument('prependOptionValue') ? $this->arguments['prependOptionValue'] : '';
            $label = $this->arguments['prependOptionLabel'];
        } else {
            $label = $this->arguments['options'][0]->getName();
        }

        $output = '<div class="dropdown_header ig-borderbox ym-g100">
                <div class="dropdown_action_label ig-inline">' . $label . '</div>
                <div class="dropdown_action_arrow ig-inline dropdown_action_open_arrow">&nbsp;</div>
            </div>';
        return $output;
    }

    protected function renderOptionTags($options): string
    {
        $output = '<div class="dropdown_content">';
        $firstValue = 0;
        foreach ($options as $value => $label) {
            if (!$firstValue) {
                $firstValue = $value;
            }

            $isSelected = $this->isSelected($value);
            $output .= $this->renderOptionTag($value, $label, $isSelected) . LF;
        }

        $output .= '<input type="hidden" name="' . $this->getName() . '" value="' . ($this->getValueAttribute() ?? $firstValue) . '" />';
        $output .= '</div>';
        return $output;
    }

    /**
     * Render one option tag
     *
     * @param string $value value attribute of the option tag (will be escaped)
     * @param string $label content of the option tag (will be escaped)
     * @param bool $isSelected specifies whether or not to add selected attribute
     * @return string the rendered option tag
     */
    protected function renderOptionTag($value, $label, $isSelected): string
    {
        $output = '<div data-uid="' . htmlspecialchars($value) . '" class="prodOptionSelect';
        if ($isSelected) {
            $output .= ' active';
        }

        $output .= '">' . htmlspecialchars($label) . '</div>';
        return $output;
    }
}
