<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use InternetGalerie\Igshop2\Domain\Model\Currency;
use InternetGalerie\Igshop2\Domain\Model\Product;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class HasActionPriceViewHelper extends AbstractConditionViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('currency', Currency::class, 'Currency', true);
        $this->registerArgument('product', Product::class, 'Product', true);
    }

    /**
     * has the product special offers/discounts...
     */
    protected static function evaluateCondition($arguments = null): string
    {
        $currency = $arguments['currency'];
        $product = $arguments['product'];
        return $product->hasActionPrice($currency);
    }
}
