<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Link;

use InternetGalerie\Igshop2\Utility\AjaxUtility;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\ExtbaseRequestParameters;
use TYPO3\CMS\Extbase\Mvc\Request;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;
use TYPO3\CMS\Fluid\Core\Rendering\RenderingContext;

/*
                      <shop:link.smallCart>Warenkorb</shop:link.smallCart>
                      <shop:ajax.div action="cart">
                        <shop:ajax.field name="cart" class="dropdown_content header_popup_products" />
                      </shop:ajax.div>
                      <div class="shop_header">
                        <shop:link.cart><img src="/fileadmin/layout/images_layout/bag.svg" width="20" /></shop:link.cart> (<shop:ajax.field name="count">0</shop:ajax.field>
                      </div>
<shop:ajax.field name="totalCurrency">CHF 0</shop:ajax.field><shop:ajax.field name="currency" /><shop:ajax.field name="total" />
<shop:ajax.field name="productsCount" />
*/

class ProductComparisonViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * @var ConfigurationManagerInterface
     */
    protected $configurationManager;

    /**
     * @var UriBuilder
     */
    protected $uriBuilder;

    protected $settings = null;


    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager): void
    {
        $this->configurationManager = $configurationManager;
    }



    public function injectUriBuilder(UriBuilder $uriBuilder): void
    {
        $this->uriBuilder = $uriBuilder;
    }


    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('title', 'string', 'Title Attribute', false);
        // $this->registerArgument('smallCartPageUid' 'int', 'Page Uid of Small Cart Ajax Page', true); // muss dies in Settings
    }

    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render(): string
    {
        $this->settings = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            'Igshop2',
            ''
        );

        /// do not output anything if productComparison is not enable
        if (!((bool)$this->settings['productComparison']['enable'])) {
            return '';
        }

        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addCssFile('EXT:igshop2/Resources/Public/Css/Products/igShop_ProductComparison.scss');
        $pageRenderer->addJsFooterFile(
            'EXT:igshop2/Resources/Public/JavaScript/ProductComparison/productComparison.js'
        );

        /** @var RenderingContext $renderingContext */
        $renderingContext = $this->renderingContext;

        $request = null;
        if (method_exists($this->renderingContext, 'getRequest')) {
            // TYPO3 v12 compatibility
            $request = $this->renderingContext->getRequest();
        } elseif ($this->renderingContext->hasAttribute(ServerRequestInterface::class)) {
            // TYPO3 v13+ compatibility
            $request = $this->renderingContext->getAttribute(ServerRequestInterface::class);
        }
        $extbaseRequest = new Request($request->withAttribute('extbase', new ExtbaseRequestParameters()));
        $productComparisonPid = intval($this->settings['productComparison']['pageUid'] ?? 0);

        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        
        $productComparisonUrl = $uriBuilder
            ->reset()
            ->setRequest($extbaseRequest)
            ->setTargetPageUid($productComparisonPid)
            ->build();
        /*
          // remove cHash
        $urlComponents = parse_url($productComparisonUrl);
        $queryParams = [];
        if (isset($urlComponents['query'])) {
            parse_str($urlComponents['query'], $queryParams);
            unset($queryParams['cHash']); // Remove cHash if it exists
        }
        echo(AjaxUtility::http_build_url($urlComponents) . '<br />');
        */
        $fetchProductsUrl = $uriBuilder
            ->reset()
            ->setRequest($extbaseRequest)
            ->setTargetPageUid($productComparisonPid)
            ->setNoCache(1)
            ->setTargetPageType(4000)
            ->uriFor(
                'fetchProducts',
                null,
                'ProductComparison',
                'Igshop2',
                'ProductComparison'
            );

        $output = $this->renderChildren();
        //  igshop-ajax-action-' . ($this->arguments['action'] ?? 'cart') . '
        return '<div class="igshop-container tx-igshop2-product-comparison-small" data-fetch-products-url="' . htmlspecialchars(
            $fetchProductsUrl
        ) . '"><a ' . (isset($this->arguments['title']) ? 'title="' . $this->arguments['title'] . '"' : '') . ' class="shop-compare-lightbox-link shop-compare-open-lightbox-link" href="' . $productComparisonUrl . '">' . $output . '</a><div id="product-comparison-list" class="product-comparison-dropdown"><div class="shop-compare-text"></div></div></div>';
    }
}
