<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper;
class ProductFormViewHelper extends FormViewHelper
{
    /**
     * Initialize the arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->overrideArgument('pluginName', 'string', 'Plugin Name', false, 'Fecart');
        $this->overrideArgument('controller', 'string', 'Controller', false, 'Order');
        $this->overrideArgument('action', 'string', 'Action', false, 'addProduct');
        $this->overrideArgument('name', 'string', 'Name', false, 'product');
    }

    /**
     * Render the form.
     *
     * @return string rendered form
     */
    public function render(): string
    {
        $class = 'product_form';
        if ($this->tag->hasAttribute('class')) {
            $this->tag->addAttribute('class', $class . ' ' . $this->tag->getAttribute('class'));
            $this->arguments['class'] = $class . ' ' . $this->tag->getAttribute('class');
        } else {
            $this->tag->addAttribute('class', $class);
            $this->arguments['class'] = $class;
        }

        return parent::render();
    }
}
