<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class ProductPriceViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this -> registerArgument('currency', 'mixed', 'Currency', true);
        $this -> registerArgument('product', 'mixed', 'Product', false);
        $this -> registerArgument('productOption', 'mixed', 'Product Option', false);
        $this -> registerArgument('notAvailableText', 'string', 'Text falls Produkt nicht verfuegbar', false, false);
    }
    
    /**
     * Rounds the price to CHF norm
     */
    public function render(): string
    {
        $currency = $this->arguments['currency'];
        $product = $this->arguments['product'];
        $notAvailableText = $this->arguments['notAvailableText'];
        $optionWithPrice = $this->arguments['productOption'];
        /*
        $price = $this->arguments["price"];
        $productPrice = $this->arguments["productPrice"];
        $withoutCode = $this->arguments["withoutCode"];
        $withoutFaktor = $this->arguments["withoutFaktor"];
        $product = $this->arguments["product"];
        $optionWithPrice = $this->arguments["optionWithPrice"];
        */


        if (is_object($optionWithPrice)) {
            if ($currency->getShort() == 'EUR' && $optionWithPrice->getPriceEuro() !== null) {
                if ($notAvailableText !== false && $optionWithPrice->getPriceEuro() <= 0) {
                    return $notAvailableText;
                }

                $price = $optionWithPrice->getPriceEuro();
            } else {
                $price = $optionWithPrice->getPrice() * $currency->getFaktor();
            }
        }


        if (is_object($product)) {
            $price = $product->getFinalPrice($currency, 0, 0, $checkForPromotion);
        }

        //var_dump($price);
        if (is_array($price)) {
            $promotePrice = static::format($currency, $price['price']);
            $origPrice = static::format($currency, $price['origPrice']);
            return '<div class="origPrice">' . $origPrice . '</div><div class="promoPrice">' . $promotePrice . '</div>';
        }

        $price = static::format($currency, $price);


        return $price;
    }

    public static function format($currency, $price): string
    {
        if ($currency->getRounding()) {
            $thousandSeparator = $currency->getThousandSeparator();
            $commaSeparator = $currency->getCommaseparator();
            $rounding = $currency->getRounding();
            if ($thousandSeparator != null && $commaSeparator != null) {
                $return = number_format(
                    round($price * (1 / $rounding)) / (1 / $rounding),
                    2,
                    $commaSeparator,
                    $thousandSeparator
                );
            } else {
                $return = number_format(round($price * (1 / $rounding)) / (1 / $rounding), 2);
            }
        } else {
            $return = $price;
        }

        /*
        if ($withoutCode) {
            return $return;
        }
        */

        if ($currency->getAfterPrice()) {
            return $return . ' ' . $currency->getSymbol();
        }

        return $currency->getSymbol() . ' ' . $return;
    }
}
