<?php

namespace InternetGalerie\Igshop2\Widgets;

use InternetGalerie\Igshop2\Widgets\Provider\OrderProviderInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Backend\View\BackendViewFactory;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\RequestAwareWidgetInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetConfigurationInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetInterface;

class OrderYearWidget implements WidgetInterface, RequestAwareWidgetInterface
{
    private ServerRequestInterface $request;

    public function __construct(
        private readonly WidgetConfigurationInterface $configuration,
        private readonly OrderProviderInterface $dataProvider,
        private readonly BackendViewFactory $backendViewFactory,
        private readonly ?ButtonProviderInterface $buttonProvider = null,
        private readonly array $options = []
    ) {
    }

    public function setRequest(ServerRequestInterface $request): void
    {
        $this->request = $request;
    }

    public function renderWidgetContent(): string
    {
        $view = $this->backendViewFactory->create($this->request, ['typo3/cms-dashboard', 'internetgalerie/igshop2']);
        $view->assignMultiple([
            'ordersLimit' => $this->dataProvider->getLimit(),
            'orders' => $this->dataProvider->getOrderYear(),
            'options' => $this->options,
            //'button' => $this->getButton(),
            'configuration' => $this->configuration,
        ]);
        return $view->render('IgShop2/Widget/OrderYearWidget');
    }

    public function getOptions(): array
    {
        return $this->options;
    }
}
