<?php

declare(strict_types=1);

namespace InternetGalerie\Igshop2\Widgets\Provider;

use InternetGalerie\Igshop2\Domain\Model\Order;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;

class OrderProvider implements OrderProviderInterface
{
    protected DataMapper $dataMapper;

    /**
     * @var int
     */
    private $limit;

    public function __construct(int $limit = 100)
    {
        $this->limit = $limit ?: 100;
    }


    public function injectDataMapper(DataMapper $dataMapper): void
    {
        $this->dataMapper = $dataMapper;
    }

    public function getOrders(): array
    {
        $items = [];
        //$queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igshop2_domain_model_product');
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(
            'tx_igshop2_domain_model_order'
        );
        $sql = 'SELECT * FROM tx_igshop2_domain_model_order WHERE submitted = 1 ORDER BY crdate DESC LIMIT ' . (int) $this->limit;
        $stmt = $conn->prepare($sql);
        $res = $stmt->executeQuery([]);

        $res = $res->fetchAllAssociative();

        $obj = $this->dataMapper->map(Order::class, $res);

        return $obj;
    }

    public function getOrderYearMonth(): array
    {
        $items = [];
        //$queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igshop2_domain_model_product');
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(
            'tx_igshop2_domain_model_order'
        );
        $sql = "SELECT SUM(total) AS amount, COUNT(*) AS count_orders, DATE_FORMAT(orderdate, '%Y-%m') AS order_month FROM tx_igshop2_domain_model_order"
             . " WHERE submitted = 1   AND deleted = 0"
             . " GROUP BY order_month"
             . " ORDER BY order_month DESC"
             . ' LIMIT ' . (int) $this->limit;
        $stmt = $conn->prepare($sql);
        $res = $stmt->executeQuery([]);

       return $res->fetchAllAssociative();
    }
    public function getOrderYear(): array
    {
        $items = [];
        //$queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igshop2_domain_model_product');
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(
            'tx_igshop2_domain_model_order'
        );
        $sql = "SELECT SUM(total) AS amount, COUNT(*) AS count_orders, YEAR(orderdate) AS order_year FROM tx_igshop2_domain_model_order"
             . " WHERE submitted = 1   AND deleted = 0"
             . " GROUP BY order_year"
             . " ORDER BY order_year DESC"
             . ' LIMIT ' . (int) $this->limit;
        $stmt = $conn->prepare($sql);
        $res = $stmt->executeQuery([]);

       return $res->fetchAllAssociative();
    }

    public function getLimit(): int
    {
        return $this->limit;
    }
}
