<?php
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
if (!defined ('TYPO3')) {
	die ('Access denied.');
}

$GLOBALS['TCA']['tx_igshop2_domain_model_portoprice'] = [
	'ctrl' => [
        'title' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_portoprice',
        'label' => 'description',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',

        'versioningWS' => 2,
        'versioning_followPages' => TRUE,

        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'description,price,price_euro',
        //'dynamicConfigFile' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath($_EXTKEY) . 'Configuration/TCA/Portoprice.php',
        'iconfile' => ExtensionManagementUtility::extPath('igshop2') . 'Resources/Public/Icons/tx_igshop2_domain_model_portoprice.gif'
    ],
	'types' => [
		'1' => ['showitem' => 'sys_language_uid,--palette--,l10n_parent,l10n_diffsource,hidden,--palette--;;1,description,price,price_euro,amount_min,amount_max,quantity_min,quantity_max,--div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access,starttime,endtime'],
	],
	'palettes' => [
		'1' => ['showitem' => ''],
	],
	'columns' => [

		'sys_language_uid' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
			'config' => ['type' => 'language'],
		],
		'l10n_parent' => [
			'displayCond' => 'FIELD:sys_language_uid:>:0',
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
			'config' => [
				'type' => 'select',
    'renderType' => 'selectSingle',
				'items' => [
					['label' => '', 'value' => 0],
				],
				'foreign_table' => 'tx_igshop2_domain_model_portoprice',
				'foreign_table_where' => 'AND tx_igshop2_domain_model_portoprice.pid=###CURRENT_PID### AND tx_igshop2_domain_model_portoprice.sys_language_uid IN (-1,0)',
			],
		],
		'l10n_diffsource' => [
			'config' => [
				'type' => 'passthrough',
			],
		],

		't3ver_label' => [
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'max' => 255,
			]
		],

		'hidden' => [
			'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
			],
		],
        'starttime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],

		'price' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_portoprice.price',
			'config' => [
				'type' => 'number',
				'size' => 30,
				'format' => 'decimal'
			]
		],
		'price_euro' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_portoprice.price_euro',
			'config' => [
				'type' => 'number',
				'size' => 30,
                'nullable' => true,
                'format' => 'decimal',
                'default' => null,
			]
		],
		'amount_min' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_portoprice.amount_min',
			'config' => [
				'type' => 'number',
				'size' => 30,
                'nullable' => true,
                'format' => 'decimal',
                'default' => null,
			]
		],
		'amount_max' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_portoprice.amount_max',
			'config' => [
				'type' => 'number',
				'size' => 30,
                'nullable' => true,
                'format' => 'decimal',
                'default' => null,
			]
		],
		'quantity_min' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_portoprice.quantity_min',
			'config' => [
				'type' => 'number',
				'size' => 4,
				'nullable' => true,
                'default' => null,
			]
		],
		'quantity_max' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_portoprice.quantity_max',
			'config' => [
				'type' => 'number',
				'size' => 4,
				'nullable' => true,
                'default' => null,
			]
		],

		'porto' => [
			'config' => [
				'type' => 'passthrough',
			],
		],

		'description' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_portoprice.description',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],

	],
];
