<?php
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
if (!defined('TYPO3')) {
    die('Access denied.');
}

$versionInformation = GeneralUtility::makeInstance(Typo3Version::class);
if ($versionInformation->getMajorVersion() > 11) {
    $filesConfig = [
        'type' => 'file',
        'foreign_match_fields' => [
            'tablenames' => 'tx_igshop2_domain_model_product',
        ],
        'maxitems' => 9999,
        'allowed' => 'pdf',
    ];
    $imagesConfig = [
        'type' => 'file',
        'foreign_match_fields' => [
            'tablenames' => 'tx_igshop2_domain_model_product',
        ],
        'maxitems' => 9999,
        'allowed' => 'common-image-types',
    ];
    $imagesThumbConfig = [
        'type' => 'file',
        'foreign_match_fields' => [
            'tablenames' => 'tx_igshop2_domain_model_product',
        ],
        'maxitems' => 9999,
        'allowed' => 'common-image-types',
    ];
      // is this not better for videos?
    $mediaConfig = [
        'type' => 'file',
        'foreign_match_fields' => [
            'tablenames' => 'tx_igshop2_domain_model_product',
        ],
        'appearance' => [
            'collapseAll' => 1,
        ],
        'maxitems' => 99,
        'allowed' => 'common-media-types',
        'disallowed' => 'common-image-types',
    ];
} else {
    $filesConfig = ExtensionManagementUtility::getFileFieldTCAConfig(
        'files',
        [
            'appearance' => [
                'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
            ],
            'foreign_match_fields' => [
                'tablenames' => 'tx_igshop2_domain_model_product',
            ],
            // Alle Zeilen von V11 (foreign_types...)
            'maxitems' => 9999,
        ],
        'pdf'
    );
    $imagesConfig = ExtensionManagementUtility::getFileFieldTCAConfig(
        'image',
        [
            'appearance' => [
                'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
            ],
            'foreign_match_fields' => [
                'tablenames' => 'tx_igshop2_domain_model_product',
            ],
            // Alle Zeilen von V11 (foreign_types...)
            'maxitems' => 9999,
        ],
        $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext']
    );
    $imageThumbsConfig = ExtensionManagementUtility::getFileFieldTCAConfig(
        'image_thumb',
        [
            'appearance' => [
                'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
            ],
            'foreign_match_fields' => [
                'tablenames' => 'tx_igshop2_domain_model_product',
            ],
            // Alle Zeilen von V11 (foreign_types...)
            'maxitems' => 9999,
        ],
        $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext']
    );
    $mediaConfig = [
                'type' => 'inline',
                'foreign_table' => 'tx_igshop2_domain_model_video',
                'foreign_field' => 'product',
                'foreign_sortby' => 'sorting',
                'maxitems' => 9999,
                'appearance' => [
                    'collapseAll' => 1,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => 1,
                    'showPossibleLocalizationRecords' => 1,
                    'showAllLocalizationLink' => 1,
                ],
            ];

}

$GLOBALS['TCA']['tx_igshop2_domain_model_product'] = [
    'ctrl' => [
        'title' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',

        'versioningWS' => 2,
        'versioning_followPages' => true,
        'sortby' => 'sorting',
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'translationSource' => 'l10n_source',
        'delete' => 'deleted',
        'useColumnsForDefaultValues' => 'category',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'productid,pharmacode,search_string,name,description,price,price_euro,price_member,price_member_euro,image,max_amount,options_input,options_size,category,product_class,options_color,options_packaging,option_entry,prices,options_with_price_required, options_with_price,variants,videos,condition,state,delivery_period,width,height,depth,weight,material,additional,path_segment,price_description',
        //'dynamicConfigFile' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath($_EXTKEY) . 'Configuration/TCA/Product.php',
        'iconfile' => 'EXT:igshop2/Resources/Public/Icons/tx_igshop2_domain_model_product.svg',
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid,--palette--,l10n_parent,l10n_diffsource,hidden,--palette--;;1,name,path_segment,--palette--;Verfügbarkeit;availability_palette,condition,state,vergriffen,delivery_period,productid,pharmacode,search_string,product_of_month,product_info,description,--palette--;LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.size;size,weight,,--palette--;LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.shipping_size;shipping_size,--palette--;LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.shipping_info;shipping_info,material,additional,only_swiss,max_amount,pages,release_year,gtin,mpn,brand,google_product_category,--div--;Preise,price,--palette--;Rabatt;discount_palette,price_euro,price_description,standard_costs,price_member,price_member_euro,prices,price_label,options_with_price_required,options_with_price,no_porto,--div--;Bilder,image,videos,--div--;Dateien,files,--div--;Kategorien,category,product_class,related_category,--div--;LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:options,options_size,options_color,options_packaging,option_entry,options_input,options_products,options_products_amount,variants,products,--div--;Inhaltselemente,content_description_top,content_elements_cols,content_elements,content_description_bottom,--div--;Eigenschaften,properties_description_top,properties,properties_description_bottom,--div--;LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:accessory,contained_accessories_description_top,contained_accessories,contained_accessories_description_bottom,additional_accessories_description_top,additional_accessories,additional_accessories_description_bottom,--div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access,starttime,endtime,mandant_uid'],
    ],
    'palettes' => [
        '1' => ['showitem' => ''],
        'size' => ['showitem' => 'width, height, depth'],
        'shipping_size' => ['showitem' => 'shipping_width, shipping_height, shipping_length'],
        'shipping_info' => ['showitem' => 'shipping_weight, shipping_labels'],
        'discount_palette' => ['showitem' => 'discount, discount_start, discount_end'],
        'availability_palette' => ['showitem' => 'stock, out_of_stock_behavior, availability, availability_date'],
    ],
    'columns' => [

        'sys_language_uid' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => ['type' => 'language'],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igshop2_domain_model_product',
                'foreign_table_where' => 'AND tx_igshop2_domain_model_product.pid=###CURRENT_PID### AND tx_igshop2_domain_model_product.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],

        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],

		'hidden' => [
			'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
			],
		],
        'starttime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'only_swiss' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.only_swiss',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
            ],
        ],
        'image_thumb_title' => [
            'exclude' => 1,
            'label' => "Titel Bilder", //'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'site_id' => [
            'label' => 'Detail Seite',
            'exclude' => 1,
            'config' => [
                'type' => 'group',
                'allowed' => 'tt_content',
                'size' => '5',
                'maxitems' => '200',
                'minitems' => '0',
                'show_thumbs' => '1',
                'wizards' => [
                    'suggest' => [
                        'type' => 'suggest',
                    ],
                ],
            ],
        ],
        'mandant_uid' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.mandant_uid',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'product_info' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.product_info',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]',
        ],
        'productid' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.productid',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'name' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'brand' => [
            'exclude' => 1,
            'label' => 'Marke',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'gtin' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.gtin',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'mpn' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.mpn',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'pharmacode' => [
            'exclude' => 1,
            'label' => 'Pharmacode',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'search_string' => [
            'exclude' => 1,
            'label' => 'Suchbegriff',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'google_product_category' => [
            'exclude' => 1,
            'label' => 'Google Produkt Kategorie (Hilfe: https://support.google.com/merchants/answer/6324436)',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'description' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.description',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'price' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.price',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'nullable' => true,
                'format' => 'decimal',                
            ],
        ],
        'discount' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.discount',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'null,double2',
                'nullable' => true,
                'default' => null,
            ],
        ],
        'discount_start' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.discount_start',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'dbType' => 'date',
                'eval' => 'date,int,null',
            ],
        ],
        'discount_end' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.discount_end',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'dbType' => 'date',
                'eval' => 'date,int,null',
            ],
        ],
        'price_label' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.price_label',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'price_euro' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.price_euro',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'default' => null,
                'nullable' => true,
                'format' => 'decimal',
            ],
        ],
        'price_member' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.price_member',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'default' => null,
                'nullable' => true,
                'format' => 'decimal',
            ],
        ],
        'price_member_euro' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.price_member_euro',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'default' => null,
                'nullable' => true,
                'format' => 'decimal',
            ],
        ],
        'files' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.files',
            'config' => $filesConfig,
        ],
        'image' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.image',
            'config' => $imagesConfig,

        ],
        'image_thumb' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.image_thumb',
            'config' => $imagesThumbConfig,
        ],
        'no_porto' => [
            'exclude' => 1,
            'label' => 'Gesamte Bestellung mit diesem Produkt ohne Porto',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
                'default' => 0,
            ],
        ],
        'sorting' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.sorting',
            'config' => [
                'type' => 'number',
                'size' => 4,
            ],
        ],
        'max_amount' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.max_amount',
            'config' => [
                'type' => 'number',
                'size' => 4,
            ],
        ],
        'pages' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.pages',
            'config' => [
                'type' => 'number',
                'size' => 4,
            ],
        ],
        'release_year' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.release_year',
            'config' => [
                'type' => 'number',
                'size' => 4,
            ],
        ],
        'options_size' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.options_size',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_optionsize',
                'MM' => 'tx_igshop2_product_optionsize_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Grösse bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Grösse hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Grössen',
                        ],
                    ],
                ],
                /*
                'wizards' => [
                    '_PADDING' => 1,
                    '_VERTICAL' => 1,
                    'suggest' => [
                        'type' => 'suggest',
                    ],
                    'edit' => [
                        'type' => 'popup',
                        'title' => 'Option bearbeiten',
                        'module' => [
                            'name' => 'wizard_edit',
                        ],
                        'popup_onlyOpenIfSelected' => 1,
                        'icon' => 'actions-open',
                        'JSopenParams' => 'height=350,width=580,status=0,menubar=0,scrollbars=1',
                    ],
                    'add' => [
                        'type' => 'script',
                        'title' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:sys_template.basedOn_add',
                        'iconIdentifier' => 'actions-add',
                        'icon' => 'actions-add',
                        'params' => [
                            'table' => 'tx_igshop2_domain_model_optionsize',
                            'pid' => '###CURRENT_PID###',
                            'setValue' => 'prepend',
                        ],
                        'module' => [
                            'name' => 'wizard_add',
                        ],
                    ],
                ],
                */
            ],
        ],
        'options_packaging' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.options_packaging',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_optionpackaging',
                'MM' => 'tx_igshop2_product_optionpackaging_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Verpackung bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Verpackung hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Verpackungen',
                        ],
                    ],
                ],

            ],
        ],
        'category' => [
            'exclude' => 1,
            'l10n_mode' => 'exclude',
            //'displayCond' => 'FIELD:sys_language_uid:<=:0',
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.category',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectTree',
                'localizeReferencesAtParentLocalization' => true,
                'foreign_table' => 'tx_igshop2_domain_model_category',
                'foreign_table_where' => 'ORDER BY name ASC',
                'MM' => 'tx_igshop2_product_category_mm',
                'size' => 20,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'renderMode' => 'tree',
                'treeConfig' => [
                    'parentField' => 'parent',
                    'appearance' => [
                        'expandAll' => true,
                        'showHeader' => true,
                    ],
                ],
                'wizards' => [
                    '_PADDING' => 1,
                    '_VERTICAL' => 1,
                    'suggest' => [
                        'type' => 'suggest',
                    ],
                    /*'edit' => array(
                    'type' => 'popup',
                    'title' => 'Edit template',
                    'module' => array(
                    'name' => 'wizard_edit',
                    ),
                    'popup_onlyOpenIfSelected' => 1,
                    'icon' => 'actions-open',
                    'JSopenParams' => 'height=350,width=580,status=0,menubar=0,scrollbars=1'
                    ),*/
                    'add' => [
                        'type' => 'script',
                        'title' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:sys_template.basedOn_add',
                        'icon' => 'actions-add',
                        'params' => [
                            'table' => 'tx_igshop2_domain_model_category',
                            'pid' => '###CURRENT_PID###',
                            'setValue' => 'prepend',
                        ],
                        'module' => [
                            'name' => 'wizard_add',
                        ],
                    ],
                ],
            ],
        ],

        'product_class' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.product_class',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igshop2_domain_model_productclass',
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
            ],
        ],
        'options_color' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.options_color',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_optioncolor',
                'MM' => 'tx_igshop2_product_optioncolor_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Farbe bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Farbe hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Farben',
                        ],
                    ],
                ],


            ],
        ],
        'products' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.products',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_product',
                'MM' => 'tx_igshop2_product_product_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Produkt bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Produkt hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Produkte',
                        ],
                    ],
                ],
            ],
        ],
        'options_products' => [
            'exclude' => 1,
            'label' => 'Auswählbare Produkte',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_product',
                'MM' => 'tx_igshop2_product_optionsproducts_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Produkt bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Produkt hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Produkte',
                        ],
                    ],
                ],
            ],
        ],
        'options_products_amount' => [
            'exclude' => 1,
            'label' => 'Maximale Anzahl auswählbare Produkte',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'eval' => 'trim',
            ],
        ],
        'option_entry' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.option_entry',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_optiongroup',
                'MM' => 'tx_igshop2_product_optiongroup_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Option bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Option hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Optionen',
                        ],
                    ],
                ],
            ],
        ],
        'options_input' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.options_input',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_optioninput',
                'MM' => 'tx_igshop2_product_optioninput_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Option bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Option hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Optionen',
                        ],
                    ],
                ],
            ],
        ],
        'prices' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.prices',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_igshop2_domain_model_productprice',
                'foreign_field' => 'product',
                'foreign_sortby' => 'sorting',
                'maxitems' => 9999,
                'appearance' => [
                    'collapseAll' => 1,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => 1,
                    'showPossibleLocalizationRecords' => 1,
                    'showAllLocalizationLink' => 1,
                ],
            ],

        ],
        'options_with_price_required' => [
                'exclude' => 1,
                'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.options_with_price_required',
                'config' => [
                    'type' => 'check',
                    'renderType' => 'checkboxToggle',
                    'default' => 0,
                    'items' => [
                        [
                            'label' => '',
                        ],
                    ],
                ],
        ],
        'options_with_price' => [
            'exclude' => 1,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.options_with_price',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_igshop2_domain_model_optionwithprice',
                'foreign_field' => 'product',
                'foreign_sortby' => 'sorting',
                'maxitems' => 9999,
                'appearance' => [
                    'collapseAll' => 1,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => 1,
                    'showPossibleLocalizationRecords' => 1,
                    'showAllLocalizationLink' => 1,
                ],
            ],

        ],
        'price_description' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.price_description',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
            ],

        ],
        'videos' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.videos',
            'config' => $mediaConfig,
        ],

        'condition' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.condition',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:condition.new', 'value' => 0],
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:condition.refurbished', 'value' => 1],
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:condition.used', 'value' => 2],
                ],
            ],
        ],
        'stock' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.stock',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'eval' => 'trim',
                'nullable' => true,
            ],
        ],
        'out_of_stock_behavior' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.out_of_stock_behavior',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => \InternetGalerie\Igshop2\OutOfStockBehavior::SHOW_MESSAGE->value,
                'items' => [
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.out_of_stock_behavior.show_message', 'value' => \InternetGalerie\Igshop2\OutOfStockBehavior::SHOW_MESSAGE->value],
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.out_of_stock_behavior.hide', 'value' => \InternetGalerie\Igshop2\OutOfStockBehavior::HIDE->value],
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.out_of_stock_behavior.allow_backorder', 'value' => \InternetGalerie\Igshop2\OutOfStockBehavior::ALLOW_BACKORDER->value],
                ],
            ],
        ],
        'availability' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.availability',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:availability.out_of_stock', 'value' => 0],
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:availability.in_stock', 'value' => 1],
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:availability.preorder', 'value' => 2],
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:availability.backorder', 'value' => 3],
                ],
                'default' => 1,
            ],
        ],
        'availability_date' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.availability_date',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'dbType' => 'date',
                'eval' => 'date,int,null',
            ],
        ],

        'state' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.state',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igshop2_domain_model_state',
                'items' => [
                    ['label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_state.for_sale', 'value' => 0],
                ],
                'default' => 0,
            ],
        ],

        'delivery_period' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.delivery_period',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igshop2_domain_model_deliveryperiod',
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
            ],
        ],
        'width' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.width',
            'config' => [
                'type' => 'number',
                'size' => 4,
            ],
        ],
        'height' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.height',
            'config' => [
                'type' => 'number',
                'size' => 4,
            ],
        ],
        'depth' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.length',
            'config' => [
                'type' => 'number',
                'size' => 4,
            ],
        ],
        'weight' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.weight',
            'config' => [
                'type' => 'number',
                'size' => 4,
            ],
        ],
        'shipping_width' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.width',
            'config' => [
                'type' => 'number',
                'size' => 8,
                'nullable' => true,
                'format' => 'decimal',                
                'default' => null,
            ],
        ],
        'shipping_height' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.height',
            'config' => [
                'type' => 'number',
                'size' => 8,
                'nullable' => true,
                'format' => 'decimal',                
                'default' => null,
            ],
        ],
        'shipping_length' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.length',
            'config' => [
                'type' => 'number',
                'size' => 8,
                'nullable' => true,
                'format' => 'decimal',                
                'default' => null,
            ],
        ],
        'shipping_weight' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.weight',
            'config' => [
                'type' => 'number',
                'size' => 8,
                'nullable' => true,
                'format' => 'decimal',                
                'default' => null,
            ],
        ],
        'shipping_labels' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.shipping_labels',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_shippinglabel',
                'MM' => 'tx_igshop2_product_shippinglabel_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Versandlabel bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Versandlabel hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Versandlabels',
                        ],
                    ],
                ],

            ],
        ],
        'material' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.material',
            'config' => [
                'type' => 'input',
                'size' => 30,
            ],
        ],
        'additional' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.additional',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
        ],
        'standard_costs' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.standard_costs',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'nullable' => true,
                'format' => 'decimal',
            ],
        ],
        'variants' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.variants',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_igshop2_domain_model_productvariant',
                'foreign_field' => 'product',
                'maxitems' => 9999,
                'appearance' => [
                    'collapseAll' => 0,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => 1,
                    'showPossibleLocalizationRecords' => 1,
                    'showAllLocalizationLink' => 1,
                ],
            ],

        ],
        'path_segment' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.path_segment',
            'config' => [
                'type' => 'slug',
                'size' => 50,
                'eval' => 'uniqueInSite',
                'fallbackCharacter' => '-',
                'default' => '',
                'generatorOptions' => [
                    'fields' => ['name'],
                    'fieldSeparator' => '-',
                    'prefixParentPageSlug' => false,
                    'replacements' => [
                        '/' => 'und',
                    ],
                ],
            ],
        ],

        'related_category' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.related_category',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectTree',
                'localizeReferencesAtParentLocalization' => true,
                'foreign_table' => 'tx_igshop2_domain_model_category',
                'foreign_table_where' => 'ORDER BY name ASC',
                'MM' => 'tx_igshop2_product_relatedcategory_mm',
                'size' => 20,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'renderMode' => 'tree',
                'treeConfig' => [
                    'parentField' => 'parent',
                    'appearance' => [
                        'expandAll' => true,
                        'showHeader' => true,
                    ],
                ],
                'wizards' => [
                    '_PADDING' => 1,
                    '_VERTICAL' => 1,
                    'suggest' => [
                        'type' => 'suggest',
                    ],
                    /*'edit' => array(
                    'type' => 'popup',
                    'title' => 'Edit template',
                    'module' => array(
                    'name' => 'wizard_edit',
                    ),
                    'popup_onlyOpenIfSelected' => 1,
                    'icon' => 'actions-open',
                    'JSopenParams' => 'height=350,width=580,status=0,menubar=0,scrollbars=1'
                    ),*/
                    'add' => [
                        'type' => 'script',
                        'title' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:sys_template.basedOn_add',
                        'icon' => 'actions-add',
                        'params' => [
                            'table' => 'tx_igshop2_domain_model_category',
                            'pid' => '###CURRENT_PID###',
                            'setValue' => 'prepend',
                        ],
                        'module' => [
                            'name' => 'wizard_add',
                        ],
                    ],
                ],
            ],
        ],

        'vergriffen' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.vergriffen',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
            ],
        ],
        'properties_description_top' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.properties_description_top',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'properties' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.properties',
            'config' => [
                'type' => 'inline',
                'inlineCompileExistingChildren' => false,
                'renderType' => 'propertyFields',
                'foreign_table' => 'tx_igshop2_domain_model_propertyvalue',
                'foreign_field' => 'product',
                'foreign_sortby' => 'sorting',
            ],
        ],
        'properties_description_bottom' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.properties_description_bottom',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'product_of_month' => [
            'exclude' => 1,
            'label' => 'Produkt des Monats',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
            ],
        ],
        'contained_accessories_description_top' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.contained_accessories_description_top',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'contained_accessories' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.contained_accessories',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_product',
                'MM' => 'tx_igshop2_product_containedaccessory_mm',
                'foreign_table_where' => ' AND tx_igshop2_domain_model_product.hidden = 0',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 9999,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Zubehör bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Zubehör hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Zubehöre',
                        ],
                    ],
                ],
            ],
        ],
        'contained_accessories_description_bottom' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.contained_accessories_description_bottom',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'additional_accessories_description_top' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.additional_accessories_description_top',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'additional_accessories' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.additional_accessories',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_product',
                'foreign_table_where' => ' AND tx_igshop2_domain_model_product.hidden = 0',
                'MM' => 'tx_igshop2_product_additionalaccessory_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 9999,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Zubehör bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Zubehör hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Zubehöre',
                        ],
                    ],
                ],
            ],
        ],
        'additional_accessories_description_bottom' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.additional_accessories_description_bottom',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'content_description_top' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.content_description_top',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'content_elements_cols' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.content_elements_cols',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => '1', 'value' => 1],
                    ['label' => '2', 'value' => 2],
                    ['label' => '3', 'value' => 3],
                    ['label' => '4', 'value' => 4],
                ],
            ],
        ],
        'content_elements' => [
            'exclude' => true,
            'label' => 'Inhaltselemente',
            'config' => [
                'type' => 'inline',
                'allowed' => 'tt_content',
                'foreign_table' => 'tt_content',
                'foreign_sortby' => 'sorting',
                'foreign_field' => 'tx_igshop2_related_product',
                'minitems' => 0,
                'maxitems' => 99,
                'appearance' => [
                    'collapseAll' => true,
                    'expandSingle' => true,
                    'levelLinksPosition' => 'bottom',
                    'useSortable' => true,
                    'showPossibleLocalizationRecords' => true,
                    'showAllLocalizationLink' => true,
                    'showSynchronizationLink' => true,
                    'enabledControls' => [
                        'info' => false,
                    ],
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true,
                ],
                'overrideChildTca' => [
                    'columns' => [
                        'CType' => [
                            'config' => [
                                'default' => 'shortcut',
                            ],
                        ],
                    ],
                ],
            ],
        ],
        'content_description_bottom' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.content_description_bottom',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
    ],
];
