document.addEventListener("DOMContentLoaded", function() {
    
    // serialize originForm to check in later states
    var originForm = serializeForm(document.querySelector(".filterForm form"));;
    var originDropdownForm = "";
    // boolean to check if form should be reloaded
    var submitForm = false;
    // 
    var priceArray = new Array();
    // used for currency output
    var selectedCurrency = document.querySelector('select.igShop2_cart_currency')?.value;

    function serializeForm(form) {
        var formData = new FormData(form);
        var serialized = [];
        for (var pair of formData.entries()) {
            serialized.push(encodeURIComponent(pair[0]) + '=' + encodeURIComponent(pair[1]));
        }
        return serialized.join('&');
    }

    
    function checkFormModification() {
        var newForm = serializeForm(document.querySelector(".filterForm form"));
        submitForm = (originForm === newForm) ? false : true;
    }

    function priceWithCurrency(price){
	if(afterPrice){
	    return price+" "+currencySymbol;
	}
	return currencySymbol+" "+price;
    }
    
    // Define function to get minimal Value of Array
    Array.min = function( array ){
	return Math.min.apply( Math, array );
    };
    
    // Define function to get maximal Value of Array
    Array.max = function( array ){
	return Math.max.apply( Math, array );
    };
    
    function brightness(element) {
	var bg_color = getComputedStyle(element).backgroundColor;
	if (bg_color && bg_color !== "transparent") {
            var rgba = bg_color.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*([0-9.]+))?\)$/);
            if (rgba) {
		if (rgba[4] === '0' || (rgba[4] && parseFloat(rgba[4]) === 0)) {
                    if (element.parentNode) return brightness(element.parentNode);
		} else {
                    var y = 2.99 * parseInt(rgba[1]) + 5.87 * parseInt(rgba[2]) + 1.14 * parseInt(rgba[3]);
                    return y >= 2000;
		}
            }
	} else {
            if (element.parentNode) return brightness(element.parentNode);
	}
    }
    
    // show the filter settings set by user
    document.querySelectorAll(".dropdown_content input[type=checkbox]").forEach(function(checkbox) {
	var text = document.querySelector("label[for=" + checkbox.id + "]").textContent;
	var filterType = checkbox.parentNode.getAttribute("data-FilterName");
	if (checkbox.checked) {
            if (filterType === "Colors") {
		if (brightness(checkbox.parentNode)) {
                    checkbox.parentNode.classList.add("whiteSelectedOption");
		} else {
                    checkbox.parentNode.classList.add("selectedOption");
		}
            }
            document.querySelectorAll(".resetForm, .initSelections").forEach(function(elem) {
		elem.style.display = "inline-block";
            });
            var placeholder = document.createElement("div");
            placeholder.id = "placeholder_" + checkbox.id;
            placeholder.className = "filter_placeholder";
            placeholder.innerHTML = "<div class=\"filter_placeholder_text ig-inline\">" + text + "</div><div class=\"delete_filteroption ig-inline ig-margin-left-k\"></div>";
            document.querySelector(".igShopSelectedOptions")?.appendChild(placeholder);
	}
    });

    // Append resetForm to igShopSelectedOptions
    document.querySelector('.igShopSelectedOptions')?.appendChild(document.querySelector('.igShopSelectedOptions .resetForm'));


    // Loop through price elements and populate priceArray
    document.querySelectorAll(".price_" + selectedCurrency).forEach(function(priceElement) {
	priceArray.push(parseFloat(priceElement.textContent.trim().replace(/[A-Za-z]+ /, "")));
    });

    // Event listener for deleting filter options
    document.querySelector(".filterForm").addEventListener("click", function(event) {
	if (event.target.classList.contains("delete_filteroption")) {
            var parent = event.target.parentNode;
            if (parent.id !== null) {
		var filter_id = parent.id.replace(/placeholder_/, "");
		document.getElementById(filter_id).checked = false;
            }
            var searchStringValue = document.querySelector('.headerSearchField').value;
            if (searchStringValue !== undefined) {
		var form = event.target.closest('form');
		form.insertAdjacentHTML('beforeend', '<input type="hidden" name="' + document.querySelector('.headerSearchField').name + '" value="' + searchStringValue + '" />');
            }
            event.target.closest('form').submit();
            parent.remove();
	}
    });

    // Event listener for resetting form
    document.querySelector(".tx-igshop2 button[type=reset]")?.addEventListener("click", function(event) {
	document.querySelectorAll(".igShopSelectedOptions>div:not(.resetForm)").forEach(function(element) {
            element.remove();
	});
	document.querySelectorAll(".dropdown_content input[type=checkbox]").forEach(function(checkbox) {
            checkbox.checked = false;
	});
	document.getElementById("minPriceSetter").value = 0;
	document.getElementById("maxPriceSetter").value = 0;
	var searchStringValue = document.querySelector('.headerSearchField').value;
	if (searchStringValue !== undefined) {
            var form = event.target.closest('form');
            form.insertAdjacentHTML('beforeend', '<input type="hidden" name="' + document.querySelector('.headerSearchField').name + '" value="' + searchStringValue + '" />');
	}
	event.target.closest('form').submit();
    });
    
    // Event listener for clicking on dropdown header
    document.querySelectorAll(".filterForm .igShop_popup .dropdown_header").forEach(function(header) {
	header.addEventListener("click", function() {
            originDropdownForm = this.parentNode.querySelector("input[type=checkbox]")?.serialize();
	});
    });

    // Event listener for clicking on dropdown content submit button
    /*
    document.querySelectorAll(".filterForm .dropdown_content input[type=submit]").forEach(function(submitBtn) {
	submitBtn.addEventListener("click", function(e) {
            e.preventDefault();
            var tempDropdownForm = this.closest(".igShop_popup")?.querySelector("input[type=checkbox]")?.serialize();
            if (originDropdownForm == tempDropdownForm) {
		this.parentNode.slideToggle();
		this.parentNode.nextElementSibling.querySelector(".dropdown_header").classList.toggle("active");
		this.parentNode.nextElementSibling.querySelector(".dropdown_action_arrow").classList.toggle("dropdown_action_close_arrow");
		this.parentNode.nextElementSibling.querySelector(".dropdown_action_arrow").classList.toggle("dropdown_action_open_arrow");
		return false;
            }

            var searchStringValue = document.querySelector('.headerSearchField').value;
            if (searchStringValue !== undefined) {
		var form = this.closest('form');
		form.insertAdjacentHTML('beforeend', '<input type="hidden" name="' + document.querySelector('.headerSearchField').name + '" value="' + searchStringValue + '" />');
            }
            this.closest("form").submit();
	});
    });
    */
    
    // Event listener for changing checkboxes in dropdown
    document.querySelectorAll(".filterForm .igShop_popup input[type=checkbox]").forEach(function(checkbox) {
	checkbox.addEventListener("change", function(e) {
            var tempDropdownForm = this.closest(".igShop_popup").querySelectorAll("input[type=checkbox]").serialize();
            if (originDropdownForm != tempDropdownForm) {
		this.closest(".igShop_popup").querySelector("input[type=submit]").value = "Übernehmen";
            } else {
		this.closest(".igShop_popup").querySelector("input[type=submit]").value = "Schliessen";
            }
	});
    });
    
    document.querySelectorAll("div.dropdown_content div.filter_option").forEach(function(option) {
	option.addEventListener("click", function(e) {
            e.stopPropagation();
            e.preventDefault();
            var checkBox = this.querySelector("input[type=checkbox]");
            checkBox.checked = !checkBox.checked;
            checkBox.dispatchEvent(new Event("change"));

            if (this.classList.contains("color_option")) {
		if (brightness(this)) {
                    this.classList.toggle("whiteSelectedOption");
		} else {
                    this.classList.toggle("selectedOption");
		}
            }
	});

	option.querySelector("input[type=checkbox]").addEventListener("click", function(e) {
            e.stopPropagation();
	});
    });

    document.querySelectorAll("div.dropdown_content div.filter_option input[type=checkbox]").forEach(function(checkbox) {
	checkbox.addEventListener("change", function(e) {
            checkFormModification();
	});
    });

    document.querySelectorAll(".color_option").forEach(function(colorOption) {
	if (getComputedStyle(colorOption).backgroundColor === "rgb(255, 255, 255)") {
            colorOption.classList.add("bgWhite");
	}
    });
/*
    document.querySelector(".filterForm").addEventListener("click", function(e) {
	if (e.target.classList.contains("dropdown_header") && e.target.classList.contains("active")) {
            if (submitForm) {
		e.target.closest('form').submit();
            }
	}
    });
	*/





    

        /*$(".filterForm .dropdown_content").each(function(){
                $(this).width($(this).parent().find("div.dropdown_header")[0].getBoundingClientRect().width - 32);
        });

        $(window).smartresize(function() {
                $(".filterForm .dropdown_content").each(function(){
                        $(this).width($(this).parent().find("div.dropdown_header")[0].getBoundingClientRect().width - 32);
                });
        });*/

    

/*
        // Show min Price if set
        if(minPrice < selectedMinPrice){
                $(".resetForm, .initSelections").css("display", "inline-block");
                $(".igShopSelectedOptions").append("<div class=\"filter_placeholder selectedMinPrice\"><div class=\"filter_placeholder_text ig-inline\">Preis von "+priceWithCurrency(selectedMinPrice)+"</div><div class=\"delete_filteroption ig-inline ig-margin-left-k\"></div></div>");
                $("#sliderOutput .selectedMinPrice .filter_placeholder_text").html("von "+priceWithCurrency(selectedMinPrice));
        }else{
                $("#sliderOutput .selectedMinPrice .filter_placeholder_text").html("von "+priceWithCurrency(minPrice));
        }

        // Show max Price if set
        if(maxPrice > selectedMaxPrice){
                $(".resetForm, .initSelections").css("display", "inline-block");
                $(".igShopSelectedOptions").append("<div class=\"filter_placeholder ig-inline selectedMaxPrice\"><div class=\"filter_placeholder_text ig-inline\">Preis bis "+priceWithCurrency(selectedMaxPrice)+"</div><div class=\"delete_filteroption ig-inline ig-margin-left-k\"></div></div>");
                $("#sliderOutput .selectedMaxPrice .filter_placeholder_text").html("bis "+priceWithCurrency(selectedMaxPrice));
        }else{
                $("#sliderOutput .selectedMaxPrice .filter_placeholder_text").html("bis "+priceWithCurrency(maxPrice));
        }
*/

/*    
    // Event listener for deleting filter options in selectedMaxPrice
    document.querySelector(".selectedMaxPrice").addEventListener("click", function(event) {
	if (event.target.classList.contains("delete_filteroption")) {
            document.getElementById("maxPriceSetter").value = 0;
	}
    });

    // Event listener for deleting filter options in selectedMinPrice
    document.querySelector(".selectedMinPrice").addEventListener("click", function(event) {
	if (event.target.classList.contains("delete_filteroption")) {
            document.getElementById("minPriceSetter").value = 0;
	}
    });
        jQuery( "#slider" ).slider({
                range: true,
                min: minPrice,
                max: maxPrice,
                values: [selectedMinPrice, selectedMaxPrice],
                slide: function( event, ui ) {
                        $( "#minPriceSetter" ).val(ui.values[ 0 ]);
                        $( "#maxPriceSetter" ).val(ui.values[ 1 ]);
                        checkFormModification();

                        $( "#minPriceSetter" ).change();
                        $( "#maxPriceSetter" ).change();

                        $("#sliderOutput .selectedMinPrice .filter_placeholder_text").html("von "+priceWithCurrency($("#minPriceSetter").val()));
                        $("#sliderOutput .selectedMaxPrice .filter_placeholder_text").html("bis "+priceWithCurrency($("#maxPriceSetter").val()));
                }
        });
*/
});