var wordSearch = false;



document.getElementById('indexedsearch')?.addEventListener('submit', function(e) {
    var shopSearchString = document.querySelector('.shopSearchString');
    var shopAjaxSearch = document.querySelector('input.shop-ajax-search').value;
    if (!wordSearch) {
        shopSearchString.value = shopAjaxSearch;
    } else {
        shopSearchString.value = '';
    }
});

document.addEventListener('DOMContentLoaded', function() {
    if (document.querySelector('input.shop-ajax-search')) {
        initIndexSearchAutocomplete();
    }
});

var indexedSearchAutocompleteDebounceInterval = null; // Used to reduce the amount of querys
function initIndexSearchAutocomplete() {
    var searchInput = document.querySelector('input.shop-ajax-search');
    searchInput.addEventListener('keypress', indexedSearchAutocomplete);
    searchInput.addEventListener('keyup', indexedSearchAutocomplete);
    searchInput.setAttribute('autocomplete', 'off');

    document.addEventListener('click', function(event) {
        var targetClass = 'search-autocomplete-results';
        var elem = event.target;

        if (document.querySelectorAll('.search-autocomplete-results > *').length === 0) {
            return; // Result-Div is not shown
        }

        while (elem.tagName !== 'HTML' && !elem.classList.contains(targetClass)) {
            elem = elem.parentElement;
        }

        if (elem.tagName === 'HTML') {
            var resultsDiv = document.querySelector('.search-autocomplete-results');
            resultsDiv.innerHTML = '';
            resultsDiv.classList.remove('results');
            resultsDiv.classList.add('no-results');
        }
    });
}

var indexedSearchAutocompleteDebounceInterval = null; // Used to reduce the number of queries

function indexedSearchAutocomplete(e) {
    var inputElem = e.target;
    var elem = e.target;
    var results;
    
    while (elem.tagName !== 'HTML') {
        results = elem.querySelector('.search-autocomplete-results');
        if (results) {
            break;
        }
        elem = elem.parentElement;
    }

    if (elem.tagName === 'HTML') {
        console.log("we couldn't find a result div (.search-autocomplete-results)");
        return;
    }

    var mode = results.dataset.mode === undefined ? 'word' : results.dataset.mode;
    var soc = results.dataset.searchonclick === 'true';

    if (e.type !== 'keyup') {
        return;
    }

    results.innerHTML = '';
    results.classList.remove('results');
    results.classList.add('no-results');

    var val = inputElem.value;
    var name = inputElem.getAttribute('name');
    var minlen = results.dataset.minlength === undefined ? 3 : parseInt(results.dataset.minlength, 10);
    var maxResults = results.dataset.maxresults === undefined ? 10 : parseInt(results.dataset.maxresults, 10);

    if (val.length < minlen) {
        return;
    }

    results.classList.add('autocomplete_searching');

    // Debounce
    clearInterval(indexedSearchAutocompleteDebounceInterval);
    indexedSearchAutocompleteDebounceInterval = setInterval(function() {
        clearInterval(indexedSearchAutocompleteDebounceInterval);

        var basename = name.includes('tx_igshop2_fesearchbox') ? 'tx_igshop2_fesearchbox' : 'tx_igshop2_feshop';
	/*
        var formData = {};
        formData[basename] = {
            searchword: val
        };
	*/
	var formData = new FormData();
	formData.append(basename + '[searchword]', val);
        // Execute the query
        fetch(results.dataset.searchurl, {
            method: 'POST',
            body: formData,
            cache: 'no-cache'
        })
        .then(response => response.text())
        .then(data => {
            results.style.display = 'block';
            results.innerHTML = data;
            results.classList.remove('autocomplete_searching');

            var products = results.querySelectorAll('.ajax-product');
            if (products.length) {
                document.getElementById('indexedsearch').setAttribute('action', document.getElementById('indexedsearch').dataset.shopSearchUrl);
                document.getElementById('indexedsearch').setAttribute('method', 'get');
                wordSearch = false;
            } else {
                document.getElementById('indexedsearch').setAttribute('action', document.getElementById('indexedsearch').dataset.indexedSearchUrl);
                document.getElementById('indexedsearch').setAttribute('method', 'post');
                wordSearch = true;
            }

            var words = results.querySelectorAll('.ajax-word a');
            words.forEach(function(word) {
                word.addEventListener('click', function(e) {
                    e.preventDefault();
                    inputElem.value = this.textContent.trim();
                    wordSearch = true;
                    document.getElementById('indexedsearch').setAttribute('method', 'post');
                    document.getElementById('indexedsearch').setAttribute('action', document.getElementById('indexedsearch').dataset.indexedSearchUrl);
                    document.getElementById('indexedsearch').submit();
                });
            });

            var allProductsLinks = results.querySelectorAll('.ajax-all-products a');
            allProductsLinks.forEach(function(link) {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    this.closest('form').submit();
                });
            });

            var categories = results.querySelectorAll('.ajax-category');

            if (!words.length && !products.length && !categories.length) {
                results.classList.remove('results');
                results.classList.add('no-results');
            } else {
                results.classList.remove('no-results');
                results.classList.add('results');
            }
        });
    }, 250);
}
