#
# Table structure for table 'tx_igshop2_domain_model_shop'
#
CREATE TABLE tx_igshop2_domain_model_shop (

    name varchar(255) DEFAULT '' NOT NULL,
    company_name varchar(255) DEFAULT '' NOT NULL,
    company_url varchar(255) DEFAULT '' NOT NULL,
    company_description text,
    vat decimal(11,2) DEFAULT NULL,
    countries int(11) unsigned DEFAULT '0' NOT NULL,
    currencies int(11) unsigned DEFAULT '0' NOT NULL,
    default_country int(11) unsigned DEFAULT '0',
    paymentmethods int(11) unsigned DEFAULT '0' NOT NULL,
    portos int(11) unsigned DEFAULT '0' NOT NULL,
    shipping_services int(11) unsigned DEFAULT '0' NOT NULL,
    default_porto int(11) unsigned DEFAULT '0'

);

#
# Table structure for table 'tx_igshop2_domain_model_product'
#
CREATE TABLE tx_igshop2_domain_model_product (

    productid varchar(255) DEFAULT '' NOT NULL,
    name varchar(255) DEFAULT '' NOT NULL,
    gtin varchar(255) DEFAULT '' NOT NULL,
    mpn varchar(255) DEFAULT '' NOT NULL,
    pharmacode varchar(255) DEFAULT '' NOT NULL,
    search_string varchar(255) DEFAULT '' NOT NULL,
    google_product_category varchar(255) DEFAULT '' NOT NULL,
    brand varchar(255) DEFAULT '' NOT NULL,
    description text NOT NULL,
    price_description text NOT NULL,
    price decimal(11,2) DEFAULT NULL,
    discount decimal(11,2) DEFAULT NULL,
    discount_start date DEFAULT NULL,
    discount_end date DEFAULT NULL,
    price_label varchar(255) DEFAULT '' NOT NULL,
    price_euro decimal(11,2) DEFAULT NULL,
    price_member decimal(11,2) DEFAULT NULL,
    price_member_euro decimal(11,2) DEFAULT NULL,
    image_thumb_title varchar(255) DEFAULT '' NOT NULL,
    image int(11) unsigned DEFAULT '0' NOT NULL,
    release_year int(11) unsigned DEFAULT '0' NOT NULL,
    pages int(11) unsigned DEFAULT '0' NOT NULL,
    image_thumb int(11) unsigned NOT NULL default '0',
    sorting int(11) DEFAULT '0' NOT NULL,
    max_amount int(11) DEFAULT '0' NOT NULL,
    options_size int(11) unsigned DEFAULT '0' NOT NULL,
    options_packaging int(11) unsigned DEFAULT '0' NOT NULL,
    category int(11) unsigned DEFAULT '0' NOT NULL,
    related_category int(11) unsigned DEFAULT '0' NOT NULL,
    product_class int(11) unsigned DEFAULT '0' NOT NULL,
    products int(11) unsigned DEFAULT '0' NOT NULL,
    options_color int(11) unsigned DEFAULT '0' NOT NULL,
    option_entry int(11) unsigned DEFAULT '0' NOT NULL,
    options_input int(11) unsigned DEFAULT '0' NOT NULL,
    prices int(11) unsigned DEFAULT '0' NOT NULL,
    options_with_price int(11) unsigned DEFAULT '0' NOT NULL,
    options_with_price_required smallint(5) unsigned DEFAULT '0' NOT NULL,
    options_products int(11) unsigned DEFAULT '0' NOT NULL,
    options_products_amount int(11) unsigned DEFAULT '0' NOT NULL,
    videos int(11) unsigned DEFAULT '0' NOT NULL,
    files int(11) unsigned NOT NULL default '0',
    no_porto tinyint(4) unsigned NOT NULL default '0',
    product_info text NOT NULL,
    only_swiss tinyint(1) unsigned DEFAULT '0' NOT NULL,
    content_description_top text NOT NULL,
    content_elements_cols int(11) DEFAULT '1' NOT NULL,
    content_description_bottom text NOT NULL,
    site_id int(11) unsigned DEFAULT '0' NOT NULL,
    mandant_uid int(11) unsigned DEFAULT '0' NOT NULL,
    state int(11) unsigned DEFAULT '0' NOT NULL,
    stock int(11) DEFAULT NULL,
    out_of_stock_behavior ENUM('hide', 'show_message', 'allow_backorder') DEFAULT 'show_message' NOT NULL,
    availability int(11) unsigned DEFAULT '1' NOT NULL,
    availability_date date DEFAULT NULL,
    condition int(11) unsigned DEFAULT '0' NOT NULL,
    delivery_period int(11) unsigned DEFAULT '0' NOT NULL,
    properties_description_top text NOT NULL,
    properties int(11) unsigned NOT NULL default '0',
    properties_description_bottom text NOT NULL,
    width decimal(10,3),
    height decimal(10,3),
    depth decimal(10,3),
    weight decimal(10,3),
    shipping_width decimal(10,3),
    shipping_height decimal(10,3),
    shipping_length decimal(10,3),
    shipping_weight decimal(10,3),
    material varchar(255) DEFAULT '' NOT NULL,
    additional text NOT NULL,
    standard_costs decimal(11,2) DEFAULT NULL,
    path_segment VARCHAR(2048),
    variants int(11) unsigned DEFAULT '0' NOT NULL,
    tstamp int(11) unsigned DEFAULT '0' NOT NULL,
    crdate int(11) unsigned DEFAULT '0' NOT NULL,
    cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
    deleted tinyint(4) unsigned DEFAULT '0' NOT NULL,
    hidden tinyint(4) unsigned DEFAULT '0' NOT NULL,
    starttime int(11) unsigned DEFAULT '0' NOT NULL,
    endtime int(11) unsigned DEFAULT '0' NOT NULL,
    vergriffen int(11) DEFAULT '0' NOT NULL,
    product_of_month tinyint(4) unsigned NOT NULL default '0',
    contained_accessories_description_top text NOT NULL,
    contained_accessories int(11) DEFAULT '0' NOT NULL,
    contained_accessories_description_bottom text NOT NULL,
    additional_accessories_description_top text NOT NULL,
    additional_accessories int(11) DEFAULT '0' NOT NULL,
    additional_accessories_description_bottom text NOT NULL,
    content_elements int(11) DEFAULT '0' NOT NULL,
    shipping_labels int(11) DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_category'
#
CREATE TABLE tx_igshop2_domain_model_category (

    name varchar(255) DEFAULT '' NOT NULL,
    teaser text NOT NULL,
    description text NOT NULL,
    external_id varchar(255) DEFAULT '' NOT NULL,
    active tinyint(1) unsigned DEFAULT '0' NOT NULL,
    hide_in_navigation tinyint(1) unsigned DEFAULT '0' NOT NULL,
    without_porto tinyint(1) unsigned DEFAULT '0' NOT NULL,
    hide_in_export tinyint(1) unsigned DEFAULT '0' NOT NULL,
    exclude_slug tinyint(1) unsigned DEFAULT '0' NOT NULL,
    parent int(11) unsigned DEFAULT '0',
    sorting int(11) DEFAULT '0' NOT NULL,
    products int(11) unsigned DEFAULT '0' NOT NULL,
    path_segment VARCHAR(2048),
    view int(11) unsigned DEFAULT '0',
    image int(11) unsigned DEFAULT '0' NOT NULL,
    list_page_uid int(11) unsigned DEFAULT '0' NOT NULL,
    detail_page_uid int(11) unsigned DEFAULT '0' NOT NULL,
    properties int(11) unsigned NOT NULL default '0',

);

#
# Table structure for table 'tx_igshop2_domain_model_productclass'
#
CREATE TABLE tx_igshop2_domain_model_productclass (

    name varchar(255) DEFAULT '' NOT NULL,
    external_id varchar(255) DEFAULT '' NOT NULL,
    category varchar(255) DEFAULT '' NOT NULL,
    active tinyint(1) unsigned DEFAULT '0' NOT NULL,
    hide_in_navigation tinyint(1) unsigned DEFAULT '0' NOT NULL,
    without_porto tinyint(1) unsigned DEFAULT '0' NOT NULL,
    hide_in_export tinyint(1) unsigned DEFAULT '0' NOT NULL,
    parent int(11) unsigned DEFAULT '0',
    sorting int(11) DEFAULT '0' NOT NULL,
    products int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_order'
#
CREATE TABLE tx_igshop2_domain_model_order (

    userid int(11) DEFAULT '0' NOT NULL,
    orderdate datetime,
    total decimal(11,2) DEFAULT NULL,
    customername varchar(255) DEFAULT '' NOT NULL,
    ordermail varchar(255) DEFAULT '' NOT NULL,
    orderinfo text NOT NULL,
    paymentmode varchar(255) DEFAULT '' NOT NULL,
    payment_method int(11) unsigned DEFAULT '0',
    submitted int(11) DEFAULT '0' NOT NULL,
    done varchar(255) DEFAULT '' NOT NULL,
    shipping_type varchar(255) DEFAULT '' NOT NULL,
    shipping_status varchar(255) DEFAULT '' NOT NULL,
    is_member tinyint(1) unsigned DEFAULT '0' NOT NULL,
    reserved tinyint(1) unsigned DEFAULT '0' NOT NULL,
    canceled tinyint(1) unsigned DEFAULT '0' NOT NULL,
    reserved_until datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
    total_with_porto decimal(11,2) DEFAULT NULL,
    plzort varchar(255) DEFAULT '' NOT NULL,
    strasse varchar(255) DEFAULT '' NOT NULL,
    paid tinyint(1) unsigned DEFAULT '0' NOT NULL,
    is_order tinyint(1) unsigned DEFAULT '0' NOT NULL,
    has_billing_address tinyint(1) unsigned DEFAULT '0' NOT NULL,
    products int(11) unsigned DEFAULT '0' NOT NULL,
    porto int(11) unsigned DEFAULT '0',
    shipping_service int(11) unsigned DEFAULT '0',
    shipping int(11) unsigned DEFAULT '0',
    shipping_amount decimal(11,2) DEFAULT NULL,
    country int(11) unsigned DEFAULT '0',
    country_text varchar(255) DEFAULT '',
    currency int(11) unsigned DEFAULT '0',
    delivery_period int(11) unsigned DEFAULT '0' NOT NULL,
    survey int(11) unsigned DEFAULT '0' NOT NULL,
    confirmation int(11) unsigned NOT NULL default '0',
    checkout_reference int(11) unsigned NOT NULL default '0',
    checkout_id varchar(255) DEFAULT '' NOT NULL,
    delivery_date date DEFAULT NULL,
    cart int(11) unsigned DEFAULT '0' NOT NULL,
    INDEX tx_igshop2_index_product_userid_submmitted (userid,submitted)

);

#
# Table structure for table 'tx_igshop2_domain_model_cart'
#
CREATE TABLE tx_igshop2_domain_model_cart (

    userid int(11) DEFAULT '0' NOT NULL,
    orderdate datetime,
    total decimal(11,2) DEFAULT NULL,
    customername varchar(255) DEFAULT '' NOT NULL,
    ordermail varchar(255) DEFAULT '' NOT NULL,
    orderinfo text NOT NULL,
    paymentmode varchar(255) DEFAULT '' NOT NULL,
    payment_method int(11) unsigned DEFAULT '0',
    submitted int(11) DEFAULT '0' NOT NULL,
    done varchar(255) DEFAULT '' NOT NULL,
    shipping_type varchar(255) DEFAULT '' NOT NULL,
    shipping_status varchar(255) DEFAULT '' NOT NULL,
    is_member tinyint(1) unsigned DEFAULT '0' NOT NULL,
    total_with_porto decimal(11,2) DEFAULT NULL,
    plzort varchar(255) DEFAULT '' NOT NULL,
    strasse varchar(255) DEFAULT '' NOT NULL,
    paid tinyint(1) unsigned DEFAULT '0' NOT NULL,
    is_order tinyint(1) unsigned DEFAULT '0' NOT NULL,
    has_billing_address tinyint(1) unsigned DEFAULT '0' NOT NULL,
    products int(11) unsigned DEFAULT '0' NOT NULL,
    porto int(11) unsigned DEFAULT '0',
    shipping_service int(11) unsigned DEFAULT '0',
    country int(11) unsigned DEFAULT '0',
    country_text varchar(255) DEFAULT '',
    currency int(11) unsigned DEFAULT '0',
    delivery_period int(11) unsigned DEFAULT '0' NOT NULL,
    survey int(11) unsigned DEFAULT '0' NOT NULL,
    confirmation int(11) unsigned NOT NULL default '0',
    checkout_reference int(11) unsigned NOT NULL default '0',
    checkout_id varchar(255) DEFAULT '' NOT NULL,
    delivery_date date DEFAULT NULL,
    INDEX tx_igshop2_index_product_userid_submmitted (userid,submitted)

);

#
# Table structure for table 'tx_igshop2_domain_model_currency'
#
CREATE TABLE tx_igshop2_domain_model_currency (

    name varchar(255) DEFAULT '' NOT NULL,
    short varchar(255) DEFAULT '' NOT NULL,
    faktor decimal(11,2) DEFAULT NULL,
    symbol varchar(255) DEFAULT '' NOT NULL,
    rounding decimal(11,2) DEFAULT NULL,
    after_price tinyint(1) unsigned DEFAULT '0' NOT NULL,
    comma_separator varchar(255) DEFAULT '' NOT NULL,
    thousand_separator varchar(255) DEFAULT '' NOT NULL,
    is_default tinyint(1) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_orderproduct'
#
CREATE TABLE tx_igshop2_domain_model_orderproduct (

    tx_order int(11) unsigned DEFAULT '0' NOT NULL,
    unit_price decimal(11,2) DEFAULT NULL,
    amount int(11) DEFAULT '0' NOT NULL,
    price decimal(11,2) DEFAULT NULL,
    prod_options text NOT NULL,
    product int(11) unsigned DEFAULT '0',
    cartproduct int(11) unsigned DEFAULT '0',

);

#
# Table structure for table 'tx_igshop2_domain_model_cartproduct'
#
CREATE TABLE tx_igshop2_domain_model_cartproduct (

    tx_order int(11) unsigned DEFAULT '0' NOT NULL,
    unit_price decimal(11,2) DEFAULT NULL,
    amount int(11) DEFAULT '0' NOT NULL,
    price decimal(11,2) DEFAULT NULL,
    prod_options text NOT NULL,
    product int(11) unsigned DEFAULT '0',

);

#
# Table structure for table 'tx_igshop2_domain_model_optionsize'
#
CREATE TABLE tx_igshop2_domain_model_optionsize (

    name varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_optioncolor'
#
CREATE TABLE tx_igshop2_domain_model_optioncolor (

    name varchar(255) DEFAULT '' NOT NULL,
    color varchar(255) DEFAULT '' NOT NULL,
    sorting int(11) DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_optionpackaging'
#
CREATE TABLE tx_igshop2_domain_model_optionpackaging (

    name varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_optionentry'
#
CREATE TABLE tx_igshop2_domain_model_optionentry (

    optiongroup int(11) unsigned DEFAULT '0' NOT NULL,

    name varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_optiongroup'
#
CREATE TABLE tx_igshop2_domain_model_optiongroup (

    name varchar(255) DEFAULT '' NOT NULL,
    options int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_optioninput'
#
CREATE TABLE tx_igshop2_domain_model_optioninput (

    name varchar(255) DEFAULT '' NOT NULL,
    label varchar(255) DEFAULT '' NOT NULL,
    type varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_porto'
#
CREATE TABLE tx_igshop2_domain_model_porto (

    name varchar(255) DEFAULT '' NOT NULL,
    code varchar(255) DEFAULT '' NOT NULL,
    description varchar(255) DEFAULT '' NOT NULL,

    price decimal(11,2) DEFAULT NULL,
    size int(11) DEFAULT '0' NOT NULL,
    ship_type varchar(255) DEFAULT '' NOT NULL,
    price_euro varchar(255) DEFAULT NULL,
    country_all tinyint(4) unsigned NOT NULL default '0',
    country int(11) unsigned DEFAULT '0' NOT NULL,
    prices int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_country'
#
CREATE TABLE tx_igshop2_domain_model_country (

    name varchar(255) DEFAULT '' NOT NULL,
    short varchar(255) DEFAULT '' NOT NULL,
    currency int(11) unsigned DEFAULT '0',
    data_trigger varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_paymentmethod'
#
CREATE TABLE tx_igshop2_domain_model_paymentmethod (

    name varchar(255) DEFAULT '' NOT NULL,
    controller varchar(255) DEFAULT '' NOT NULL,
    code varchar(255) DEFAULT '' NOT NULL,
    description text,
    mailtext text,
    no_porto smallint(5) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_productprice'
#
CREATE TABLE tx_igshop2_domain_model_productprice (

    product int(11) unsigned DEFAULT '0' NOT NULL,
    optionwithprice int(11) unsigned DEFAULT '0' NOT NULL,

    price decimal(11,2) DEFAULT NULL,
    is_special_price tinyint(1) unsigned DEFAULT '0' NOT NULL,
    amount int(11) DEFAULT '0' NOT NULL,
    price_euro decimal(11,2) DEFAULT NULL,
    sorting int(11) DEFAULT '0' NOT NULL,
    currency int(11) unsigned DEFAULT '0',
    user_groups int(11) unsigned DEFAULT '0' NOT NULL,
    image int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_optionwithprice'
#
CREATE TABLE tx_igshop2_domain_model_optionwithprice (

    sorting int(11) DEFAULT '0' NOT NULL,

    product int(11) unsigned DEFAULT '0' NOT NULL,
        delivery_period int(11) unsigned DEFAULT '0' NOT NULL,

    name varchar(255) DEFAULT '' NOT NULL,
    description varchar(255) DEFAULT '' NOT NULL,
    gtin varchar(255) DEFAULT '' NOT NULL,
    mpn varchar(255) DEFAULT '' NOT NULL,
    price decimal(11,2) DEFAULT NULL,
    price_euro decimal(11,2) DEFAULT NULL,
    image int(11) unsigned DEFAULT '0' NOT NULL,
    only_swiss tinyint(1) unsigned DEFAULT '0' NOT NULL,
    prices int(11) unsigned DEFAULT '0' NOT NULL,
    
);

#
# Table structure for table 'tx_igshop2_domain_model_video'
#
CREATE TABLE tx_igshop2_domain_model_video (

    product  int(11) unsigned DEFAULT '0' NOT NULL,

    video int(11) unsigned NOT NULL default '0',
    thumb int(11) unsigned NOT NULL default '0',
    youtube_video varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_portoprice'
#
CREATE TABLE tx_igshop2_domain_model_portoprice (

    porto int(11) unsigned DEFAULT '0' NOT NULL,

    description varchar(255) DEFAULT '' NOT NULL,
    price decimal(11,2) DEFAULT NULL,
    price_euro decimal(11,2) DEFAULT NULL,
    amount_min decimal(11,2) DEFAULT NULL,
    amount_max decimal(11,2) DEFAULT NULL,
    quantity_min int(11) DEFAULT NULL,
    quantity_max int(11) DEFAULT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_survey'
#
CREATE TABLE tx_igshop2_domain_model_survey (

    title varchar(255) DEFAULT '' NOT NULL,
    code varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_categoryview'
#
CREATE TABLE tx_igshop2_domain_model_categoryview (

    name varchar(255) DEFAULT '' NOT NULL,
    partial varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_state'
#
CREATE TABLE tx_igshop2_domain_model_state (

    title varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_deliveryperiod'
#
CREATE TABLE tx_igshop2_domain_model_deliveryperiod (

    on_stock tinyint(4) DEFAULT '0' NOT NULL,
    title varchar(255) DEFAULT '' NOT NULL,
    min_handling_time int(11),
    max_handling_time int(11),
    min_transit_time int(11),
    max_transit_time int(11),
    priority int(11) DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_state'
#
CREATE TABLE tx_igshop2_domain_model_productvariant (

    product int(11) unsigned DEFAULT '0' NOT NULL,

    title varchar(255) DEFAULT '' NOT NULL,
    image int(11) unsigned NOT NULL default '0',

);

#
# Table structure for table 'tx_igshop2_domain_model_property'
#
CREATE TABLE tx_igshop2_domain_model_property (

    name varchar(255) DEFAULT '' NOT NULL,
    use_in_comparison  smallint(5) unsigned DEFAULT '1' NOT NULL,
    field_name varchar(255) DEFAULT '' NOT NULL,
    unit varchar(255) DEFAULT '' NOT NULL,
    field_type varchar(255) DEFAULT '' NOT NULL,
    db_type varchar(255) DEFAULT '' NOT NULL,
    partial varchar(255) DEFAULT '' NOT NULL,
    show_in_detailpage smallint(5) unsigned DEFAULT '0' NOT NULL,
    show_in_filter smallint(5) unsigned DEFAULT '0' NOT NULL,
    category int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_propertyvalue'
#
CREATE TABLE tx_igshop2_domain_model_propertyvalue (

    property_value text,
    property_value_number decimal(11,2),
    property_value_textarea text,
    property int(11) unsigned DEFAULT '0' NOT NULL,
    product int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_propertycategory'
#
CREATE TABLE tx_igshop2_domain_model_propertycategory (

    name varchar(255) DEFAULT '' NOT NULL,
    parent int(11) unsigned DEFAULT '0',

);

#
# Table structure for table 'tx_igshop2_domain_model_reminderlist'
#
CREATE TABLE tx_igshop2_domain_model_reminderlist (

    user int(11) unsigned DEFAULT '0' NOT NULL,
    products int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_productcomparison'
#
CREATE TABLE tx_igshop2_domain_model_productcomparison (

    user int(11) unsigned DEFAULT '0' NOT NULL,
    products int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_shippingservice'
#
CREATE TABLE tx_igshop2_domain_model_shippingservice (

    name varchar(255) DEFAULT '' NOT NULL,
    description text,
    logo int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_shipping'
#
CREATE TABLE tx_igshop2_domain_model_shipping (

    name varchar(255) DEFAULT '' NOT NULL,
    service int(11) unsigned,
    shipping_labels int(11) DEFAULT '0' NOT NULL,
    price decimal(11,2),
    currency int(11) unsigned NOT NULL,
    min_price decimal(11,2),
    max_price decimal(11,2),
    min_quantity int(11) unsigned,
    max_quantity int(11) unsigned,
    min_weight decimal(10,3),
    max_weight decimal(10,3),
    min_length decimal(10,3),
    max_length decimal(10,3),
    min_width decimal(10,3),
    max_width decimal(10,3),
    min_height decimal(10,3),
    max_height decimal(10,3),
    country int(11) unsigned,

    cutoff_time time DEFAULT NULL,
    min_handling_time int(11) unsigned,
    max_handling_time int(11) unsigned,
    min_transit_time int(11) unsigned,
    max_transit_time int(11) unsigned,

);

#
# Table structure for table 'tx_igshop2_domain_model_shippinglabel'
#
CREATE TABLE tx_igshop2_domain_model_shippinglabel (

    name varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'sys_file_reference'
#
CREATE TABLE sys_file_reference (

    product  int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'fe_users'
#
CREATE TABLE fe_users (
    last_used_address int(11) unsigned NOT NULL default '0',
    last_used_billing_address int(11) unsigned NOT NULL default '0',
    addresses int(11) unsigned NOT NULL default '0',
    current_order int(11) unsigned NOT NULL default '0',
    orders int(11) unsigned NOT NULL default '0',
);


#
# Table structure for table 'tx_igshop2_domain_model_productprice'
#
CREATE TABLE tx_igshop2_domain_model_productprice (

    product  int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_optionwithprice'
#
CREATE TABLE tx_igshop2_domain_model_optionwithprice (

    product  int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_domain_model_productvariant'
#
CREATE TABLE tx_igshop2_domain_model_productvariant (

    product int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tt_content'
#
CREATE TABLE tt_content (
    tx_igshop2_related_product int(11) DEFAULT '0' NOT NULL,
    KEY index_igshop2productcontent (tx_igshop2_related_product)
);


#
# Table structure for table 'tx_igshop2_product_optionsize_mm'
#
CREATE TABLE tx_igshop2_product_optionsize_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_optioninput_mm'
#
CREATE TABLE tx_igshop2_product_optioninput_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_optionpackaging_mm'
#
CREATE TABLE tx_igshop2_product_optionpackaging_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_product_mm'
#
CREATE TABLE tx_igshop2_product_product_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_optionsproducts_mm'
#
CREATE TABLE tx_igshop2_product_optionsproducts_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_category_mm'
#
CREATE TABLE tx_igshop2_product_category_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_relatedcategory_mm'
#
CREATE TABLE tx_igshop2_product_relatedcategory_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_optioncolor_mm'
#
CREATE TABLE tx_igshop2_product_optioncolor_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_optiongroup_mm'
#
CREATE TABLE tx_igshop2_product_optiongroup_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_order_survey_mm'
#
CREATE TABLE tx_igshop2_order_survey_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_cart_survey_mm'
#
CREATE TABLE tx_igshop2_cart_survey_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_domain_model_optionentry'
#
CREATE TABLE tx_igshop2_domain_model_optionentry (

    optiongroup  int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igshop2_porto_country_mm'
#
CREATE TABLE tx_igshop2_porto_country_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_productprice_frontendusergroup_mm'
#
CREATE TABLE tx_igshop2_productprice_frontendusergroup_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);


CREATE TABLE tt_address (
    fe_user int(11) unsigned NOT NULL default '0',
    is_billing_address tinyint(4) NOT NULL default '0',
    is_private_person tinyint(4) NOT NULL default '0',
);

#
# Table structure for table 'tx_igshop2_shop_country_mm'
#
CREATE TABLE tx_igshop2_shop_country_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    PRIMARY KEY (uid_local,uid_foreign),
    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_shop_currency_mm'
#
CREATE TABLE tx_igshop2_shop_currency_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    PRIMARY KEY (uid_local,uid_foreign),
    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_shop_paymentmethod_mm'
#
CREATE TABLE tx_igshop2_shop_paymentmethod_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    PRIMARY KEY (uid_local,uid_foreign),
    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_shop_porto_mm'
#
CREATE TABLE tx_igshop2_shop_porto_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    PRIMARY KEY (uid_local,uid_foreign),
    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_shop_shippingservice_mm'
#
CREATE TABLE tx_igshop2_shop_shippingservice_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    PRIMARY KEY (uid_local,uid_foreign),
    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_containedaccessory_mm'
#
CREATE TABLE tx_igshop2_product_containedaccessory_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_additionalaccessory_mm'
#
CREATE TABLE tx_igshop2_product_additionalaccessory_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_reminderlist_product_mm'
#
CREATE TABLE tx_igshop2_reminderlist_product_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_reminderlist_product_mm'
#
CREATE TABLE tx_igshop2_productcomparison_product_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_category_property_mm'
#
CREATE TABLE tx_igshop2_category_property_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_shippinglabel_mm'
#
CREATE TABLE tx_igshop2_product_shippinglabel_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igshop2_product_shippinglabel_mm'
#
CREATE TABLE tx_igshop2_shipping_shippinglabel_mm (
    uid_local int(11) unsigned DEFAULT '0' NOT NULL,
    uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
    sorting int(11) unsigned DEFAULT '0' NOT NULL,
    sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

    KEY uid_local (uid_local),
    KEY uid_foreign (uid_foreign)
);
