<?php

namespace InternetGalerie\Igshop2\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use TYPO3\CMS\Core\Configuration\ExtensionConfiguration;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Command for ugrade video
 * copy entries from tx_igshop2_domain_model_video to sys_file
 */
class CleanupCommand extends Command
{
    protected ?SymfonyStyle $io = null;
    protected array $conf;

    public function __construct(protected readonly ExtensionConfiguration $extensionConfiguration)
    {
        $this->conf = $extensionConfiguration->get('igshop2');
        parent::__construct();
    }

    /**
     * Defines the allowed options for this command
     */
    protected function configure(): void
    {
        $this
          ->setDescription('Cleanup igshop2 tables')
          ->setHelp('Cleanup igshop2 tables');
    }

    /**
     * Installs an extension
     *
     * @inheritdoc
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->io = new SymfonyStyle($input, $output);
        $this->io->info('igshop2 cleanup: START.');

        $daysToDeleteCarts = (int)$this->conf['daysToDeleteCarts'];
        $daysToDeleteOrders = (int)$this->conf['daysToDeleteOrders'];
        
        $this->cleanupCarts($daysToDeleteCarts);
        $this->cleanupOrders($daysToDeleteOrders);

        $this->io->success('igshop2 cleanup: DONE.');
        return 0;
    }

    public function cleanupCarts(int $daysToDeleteCarts): void
    {
        $this->io->info('igshop2 cleanup: START CARTS.');
        $this->cleanupCartsOrOrders('tx_igshop2_domain_model_cart', 'tx_igshop2_domain_model_cartproduct', $daysToDeleteCarts, ['userid = 0']);
        $this->io->success('igshop2 cleanup: DONE CARTS.');
    }

    public function cleanupOrders(int $daysToDeleteOrders): void
    {
        $this->io->info('igshop2 cleanup: START ORDERS.');
        $this->cleanupCartsOrOrders('tx_igshop2_domain_model_order', 'tx_igshop2_domain_model_orderproduct', $daysToDeleteOrders);
        $this->io->success('igshop2 cleanup: DONE ORDERS.');
    }

    protected function cleanupCartsOrOrders(string $tablename, string $productTablename, int $daysToDelete, array $wheres = []): void
    {
        if($daysToDelete < 1) {
            return;
        }
        
        $now = time();
        $maximumDeletionTime = $now - ($daysToDelete * 60 * 60 * 24);

        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($tablename);

        $qb = $conn->createQueryBuilder();

        $wheres[] = 'submitted = 0';
        $wheres[] = $qb->expr()->lt('tstamp', $maximumDeletionTime);

        $uidsToDelete = $qb->select('uid')
            ->from($tablename)
            ->where($qb->expr()->and(...$wheres))
            ->executeQuery()
            ->fetchFirstColumn();

        $this->io->info('FOUND ' . count($uidsToDelete) . ' ENTRIES TO DELETE IN ' . $tablename);

        if (!empty($uidsToDelete)) {
            $qb = $conn->createQueryBuilder();
            $numAffectedRows = $qb->delete($tablename)
                ->where($qb->expr()->in('uid', $uidsToDelete))
                ->executeStatement();

            $this->io->warning('DELETED ' . $numAffectedRows . ' ENTRIES FROM ' . $tablename);

            $qb = $conn->createQueryBuilder();
            $numAffectedRows = $qb->delete($productTablename)
                ->where($qb->expr()->in('tx_order', $uidsToDelete))
                ->executeStatement();

            $this->io->warning('DELETED ' . $numAffectedRows . ' ENTRIES FROM ' . $productTablename);
        }
    }
}
