<?php

namespace InternetGalerie\Igshop2\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Core\Page\PageRenderer;
use InternetGalerie\Igshop2\ViewHelpers\CurrencyViewHelper;
use DateTime;
use TYPO3\CMS\Core\Log\LogManager;
use TYPO3\CMS\Core\Log\LogLevel;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use InternetGalerie\Igshop2\Domain\Model\Address;
use InternetGalerie\Igshop2\Domain\Model\CartProduct;
use InternetGalerie\Igshop2\Domain\Model\Currency;
use InternetGalerie\Igshop2\Domain\Model\Order;
use InternetGalerie\Igshop2\Domain\Model\OrderProduct;
use InternetGalerie\Igshop2\Domain\Model\Product;
use InternetGalerie\Igshop2\Domain\Model\Shop;
use InternetGalerie\Igshop2\Domain\Repository\AddressRepository;
use InternetGalerie\Igshop2\Domain\Repository\CategoryRepository;
use InternetGalerie\Igshop2\Domain\Repository\CountryRepository;
use InternetGalerie\Igshop2\Domain\Repository\CurrencyRepository;
use InternetGalerie\Igshop2\Domain\Repository\FeUserRepository;
use InternetGalerie\Igshop2\Domain\Repository\OptionWithPriceRepository;
use InternetGalerie\Igshop2\Domain\Repository\OrderProductRepository;
use InternetGalerie\Igshop2\Domain\Repository\OrderRepository;
use InternetGalerie\Igshop2\Domain\Repository\PaymentMethodRepository;
use InternetGalerie\Igshop2\Domain\Repository\ProductRepository;
use InternetGalerie\Igshop2\Domain\Repository\ShippingServiceRepository;
use InternetGalerie\Igshop2\Domain\Repository\ShopRepository;
use InternetGalerie\Igshop2\Domain\Repository\StateRepository;
use InternetGalerie\Igshop2\Domain\Repository\SurveyRepository;
use InternetGalerie\Igshop2\Utility\CartUtility;
use InternetGalerie\Igshop2\Utility\ShippingUtility;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Mail\MailMessage;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Http\ForwardResponse;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;

/**
 * OrderController
 */


class OrderController extends ActionController
{
    protected Shop $shop;

    protected string $jsRootPath;

    protected string $jsLibsPath;

    protected Order $order;

    public function __construct(
        protected CartUtility $cartUtility,
        protected OrderRepository $orderRepository,
        protected OrderProductRepository $orderProductRepository,
        protected PaymentMethodRepository $paymentMethodRepository,
        protected ShippingServiceRepository $shippingServiceRepository,
        protected CurrencyRepository $currencyRepository,
        protected OptionWithPriceRepository $optionWithPriceRepository,
        protected CountryRepository $countryRepository,
        protected ProductRepository $productRepository,
        protected StateRepository $stateRepository,
        protected PersistenceManager $persistenceManager,
        protected CategoryRepository $categoryRepository,
        protected SurveyRepository $surveyRepository,
        protected FeUserRepository $feUserRepository,
        protected AddressRepository $addressRepository,
        protected ShopRepository $shopRepository
    ) {
    }

    public function includeJS(string $filename): void
    {
        if (file_exists(GeneralUtility::getFileAbsFileName($filename))) {
            $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
            $pageRenderer->addJsFooterFile($filename);
        }
    }

    public function addJsFooterInline(string $name, string $js): void
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterInlineCode($name, $js);
    }

    /*
      public function initializeView() {
      $this->view->assign('settings', $this->settings);
      }
    */

    public function showAction(?Order $order = null): ResponseInterface
    {
        header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
        header('Expires: 0');
        header('Cache-Control: post-check=0, pre-check=0', false);
        header('Pragma: no-cache');

        $context = GeneralUtility::makeInstance(Context::class);

        $src = $this->jsRootPath . 'Order/igShop_Order_Form.js';
        $this->includeJS($src);

        $params = $this->request->getArguments();
        //print_r($request['currency']);
        //$this->setCurrency( $params['currency'] );

        if ($this->cartUtility->cart && !$this->cartUtility->cart->getPorto()) {
            $this->cartUtility->setDefaultPorto();
        }
        $address = $this->cartUtility->cart->getOrderInfo();
        //$this->recalcOrder();

        $continueOrder = true;

        if ($this->settings['flexform']['minimumPrice'] && $this->cartUtility->cart->getTotal() < floatval(
            $this->settings['flexform']['minimumPrice']
        )) {
            $continueOrder = false;
        }

        // First one is default Currency, second all Currencies - for the Dropdown
        $this->view->assign('shop', $this->shop);
        $this->view->assign('continueOrder', $continueOrder);
        $this->view->assign('currency', $this->cartUtility->cart->getCurrency());
        $this->view->assign('currencies', $this->shop->getCurrencies());
        $this->view->assign('order', $this->cartUtility->cart);

        // Step describes in which state of the order the user is
        $this->view->assign('step', 1);

        // configures if the action buttons (edit, delete) should be shown
        $this->view->assign('deleteButton', 1);
        $this->view->assign('editButton', 0);
        $this->view->assign('hasPorto', $this->cartUtility->cart->hasPorto());


        /** Assign settings->Abwärtskompatibilität **/
        $this->view->assign('continueOrderWarning', $this->settings['flexform']['minimumPriceWarning']);
        $this->view->assign('continueShopping', $this->settings['flexform']['continueShopping']);
        $this->view->assign('smallShop', $this->settings['smallShop']);
        $this->view->assign('differentAddresses', $this->settings['differentAddresses']);

        $this->view->assign('isLoggedIn', $context->getPropertyFromAspect('frontend.user', 'isLoggedIn'));

        return $this->htmlResponse();
    }

    public function userListAction(): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        if ($context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            $orders = $this->orderRepository->getFromUser($context->getPropertyFromAspect('frontend.user', 'id'));
            $this->view->assign('orders', $orders);
        }

        $this->view->assign('shop', $this->shop);

        return $this->htmlResponse();
    }

    public function userShowAction(Order $order): ResponseInterface
    {
        $src = $this->jsRootPath . 'Order/igShop_Order_Form.js';
        $this->includeJS($src);

        $addressArray = $order->getOrderinfo();
        $this->view->assign('address', $addressArray);
        if ($addressArray['isCalcAddress'] ?? false) {
            $this->view->assign('calcAddress', $this->getReviewAddressArray($addressArray['calcAddress']));
        }

        $this->view->assign('order', $order);
        $this->view->assign('isHistory', 1);
        $this->view->assign('shop', $this->shop);

        return $this->htmlResponse();
    }

    public function addOrderProductAction(OrderProduct $orderProduct): ResponseInterface
    {
        $options = $orderProduct->getProdOptionsWithAmountArray();
        $this->cartUtility->addProduct($orderProduct->getProduct(), $options);

        $this->cartUtility->update();
        exit(0);

        return $this->htmlResponse();

        /*
        $newProduct = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance("InternetGalerie\\Igshop2\\Domain\\Model\\OrderProduct");

        $newProduct->setUnitPrice($orderProduct->getUnitPrice());
        $newProduct->setAmount($orderProduct->getAmount());
        $newProduct->setPrice($orderProduct->getPrice());
        $newProduct->setProdOptions($orderProduct->getProdOptions());
        $newProduct->setProduct($orderProduct->getProduct());
        $similiarProduct = $this->cartUtility->cart->getSimiliarProduct($newProduct);
        if($similiarProduct) {
            if($this->settings['prodLimit'] > 0) {
                $similiarProduct->setAmount(min($this->settings['prodLimit'], $orderProduct->getAmount() + $similiarProduct->getAmount()));
            }else{
                $similiarProduct->setAmount($orderProduct->getAmount() + $similiarProduct->getAmount());
            }
            if($orderProduct->getProduct()->getMaxAmount() > 0) {
                $similiarProduct->setAmount(min($orderProduct->getProduct()->getMaxAmount(), $similiarProduct->getAmount()));
            }
            $this->cartUtility->cart->addProduct($similiarProduct);
        }else{
            $this->cartUtility->cart->addProduct($newProduct);
        }
        $this->cartUtility->update();
        //$this->recalcOrder();
        exit;
        */
        return $this->htmlResponse();
    }

    public function ajaxAddProductAction(): ResponseInterface
    {
        $params = $this->request->getArguments();


        $this->cartUtility->addProductByUid($params['product'], [
            'amount' => $params['amount'],
        ]);
        $this->cartUtility->update();


        $productUid = $params['product'];
        $product_amount = $params['amount'];
        $product = $this->productRepository->findByUid($productUid);

        $canBeOrdered = true;
        if (isset($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']) && is_array(
            $GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks']
        )) {
            foreach ($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks'] as $classRef) {
                $hookObj = GeneralUtility::makeInstance($classRef);
                if (method_exists($hookObj, 'checkProductState')) {
                    $canBeOrdered = !$hookObj->checkProductState($product);
                }
            }
        }

        if ($canBeOrdered) {
            $prodLimit = (int)($this->settings['prodLimit'] ?? 0);
            $this->cartUtility->cart->addNewProduct($product, [
                'amount' => $product_amount,
            ], $prodLimit);
            $this->cartUtility->update();

            $currency = $this->cartUtility->cart->getCurrency();
            // Preis in Relation der Währung
            $price = $this->cartUtility->cart->getTotal() * $currency->getFaktor();

            $return = '';

            // Viewhelper function - copypaste from CurrencyViewHelper
            if ($currency->getRounding()) {
                if ($currency->getThousandSeparator() != null && $currency->getCommaseparator() != null) {
                    $return = number_format(
                        round($price * (1 / $currency->getRounding())) / (1 / $currency->getRounding()),
                        2,
                        $currency->getCommaseparator(),
                        $currency->getThousandSeparator()
                    );
                } else {
                    $return = number_format(
                        round($price * (1 / $currency->getRounding())) / (1 / $currency->getRounding()),
                        2
                    );
                }
            } else {
                $return = $price;
            }

            $withoutCode = false;
            if (!$withoutCode) {
                if ($currency->getAfterPrice()) {
                    $price = $return . ' ' . $currency->getSymbol();
                } else {
                    $price = $currency->getSymbol() . ' ' . $return;
                }
            }

            // end ViewHelper function
            $return = [
                'total' => $price, // price total
                'amount' => $this->cartUtility->cart->getTotalProductsAmount(), // amount products
            ];
        } else {
            $return = [];
        }

        return $this->jsonResponse(json_encode($return));
    }

    public function changeCurrencyAction(Currency $currency): ResponseInterface
    {
        $this->cartUtility->cart->setCurrency($currency);
        $this->currencyRepository->setSessionCurrency($currency);
        //$this->recalcOrder();
        return $this->htmlResponse();
    }

    public function editAmountAction(int $orderProductUid, int $amount): ResponseInterface
    {
        $quantity = $amount;
        $prodLimit = (int)($this->settings['prodLimit'] ?? 0);
        if ($prodLimit > 0 && $quantity > $prodLimit) {
            $quantity = $prodLimit;
        }

        //var_dump($quantity);die();
        $deleteProduct = $this->cartUtility->cartProductSetQuantityByUid($orderProductUid, $quantity);

        $orderProduct = $this->cartUtility->cart->getProductPositionByUid($orderProductUid);
        //$deleteProduct = $this->cartUtility->cart->changeProductQuantity( $orderProduct, $quantity);

        $this->cartUtility->update();

        $currencyViewHelper = GeneralUtility::makeInstance(
            CurrencyViewHelper::class
        );

        $return = [
            'product' => [
                'price' => $currencyViewHelper->renderByArguments(
                    $this->cartUtility->cart->getCurrency(),
                    $orderProduct->getUnitPrice()
                ),
                'quantity' => $orderProduct->getAmount(),
                'amount' => $currencyViewHelper->renderByArguments(
                    $this->cartUtility->cart->getCurrency(),
                    $orderProduct->getPrice()
                ) ?: LocalizationUtility::translate('tx_igshop2_domain_model_product.free', 'igshop2'),
                'delete' => $deleteProduct,
            ],
            'total' => [
                'quantity' => $this->cartUtility->cart->getTotalProductsCount(),
                'amount' => $currencyViewHelper->renderByArguments(
                    $this->cartUtility->cart->getCurrency(),
                    $this->cartUtility->cart->getTotal()
                ) ?: LocalizationUtility::translate('tx_igshop2_domain_model_product.free', 'igshop2'),
                'portoText' => $this->cartUtility->cart->getPortoDescription(),
            ],
        ];
        return $this->jsonResponse(json_encode($return));
    }

    public function editAddressAction(array $errorFields = [], array $calcAddressErrorFields = []): ResponseInterface
    {
        $feUser = null;
        //DebuggerUtility::var_dump($GLOBALS['TSFE']);
        $response = $this->checkMandatory('editAddress');
        if ($response instanceof ResponseInterface) {
            return $response;
        }

        $pageTitle = 'Liefer- und Rechnungsadresse2';
        $GLOBALS['TSFE']->page['title'] = $pageTitle;
        //$GLOBALS['TSFE']->tmpl->setup['page.']['10.']['variables.']['pageTitle.']['value']=$pageTitle;
        //echo('valu='. print_r($GLOBALS['TSFE']->tmpl->setup['page.']['10.']['variables.'],1));
        //	  $GLOBALS['TSFE']->page['10.']['variables.']['pageTitle'] = $pageTitle;
        // set pagetitle for indexed search to news title
        $GLOBALS['TSFE']->indexedDocTitle = $pageTitle;

        $src = $this->jsRootPath . 'Order/igShop_Order_Form.js';
        $this->includeJS($src);

        // Required Address Fields - Array for Fluid
        $requiredFields = [];
        foreach (GeneralUtility::trimExplode(',', $this->settings['requiredAddressFields'] ?? '') as $field) {
            $requiredFields[$field] = 1;
        }

        // Required CalcAddress Fields - Array for Fluid
        $requiredCalcAddressFields = [];
        foreach (GeneralUtility::trimExplode(',', $this->settings['requiredCalcAddressFields'] ?? '') as $field) {
            $requiredCalcAddressFields[$field] = 1;
        }

        $canChooseCalc = true;

        if (isset($this->settings['flexform']['minimumPriceForBill']) && $this->settings['flexform']['minimumPriceForBill'] && $this->cartUtility->cart->getTotal() < floatval(
            $this->settings['flexform']['minimumPriceForBill']
        )) {
            $canChooseCalc = false;
        }

        $address = $this->cartUtility->cart->getOrderinfo();

        if (is_array($address) && ($this->settings['countryAsUid'] ?? false)) {
            if ($address['country']) {
                $address['country'] = $this->countryRepository->findByUid($address['country']);
            }

            if ($address['calcAddress'] ?? false) {
                if ($address['calcAddress']['country'] ?? false) {
                    $address['calcAddress']['country'] = $this->countryRepository->findByUid(
                        $address['calcAddress']['country']
                    );
                }
            }
        }

        $context = GeneralUtility::makeInstance(Context::class);
        if ($context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            $feUser = $this->feUserRepository->findByUid($context->getPropertyFromAspect('frontend.user', 'id'));
        }

        $shippingServices = $this->shop->getShippingServices();

        $this->view->assign('shop', $this->shop);
        $this->view->assign('shippingServices', $shippingServices);
        $this->view->assign('step', 2);
        $this->view->assign('order', $this->cartUtility->cart);
        $this->view->assign('address', $address);
        $this->view->assign('requiredFields', $requiredFields);
        $this->view->assign('errorFields', $errorFields);
        $this->view->assign('calcAddressRequiredFields', $requiredCalcAddressFields);
        $this->view->assign('calcAddressErrorFields', $calcAddressErrorFields);

        $countries = $this->shop === null ? $this->countryRepository->findAll() : $this->shop->getCountries();
        $this->view->assign('countries', $countries);
        $this->view->assign('shop', $this->shop);
        $this->view->assign('canChooseCalc', $canChooseCalc);
        $this->view->assign('feUser', $feUser);

        // Alle Umfragen holen und gewaehlte markieren
        $surveys = $this->surveyRepository->findAll();
        $surveysArray = [];
        foreach ($surveys as $survey) {
            $surveysArray[] = [
                'entry' => $survey,
                'checked' => false,
            ];
        }

        foreach ($this->cartUtility->cart->getSurvey() as $s) {
            foreach ($surveysArray as &$survey) {
                if ($survey['entry']->getUid() == $s->getUid()) {
                    $survey['checked'] = true;
                }
            }
        }

        $this->view->assign('surveys', $surveysArray);

        /** Assign Settings->abwärtskompatibilität **/
        $this->view->assign('additionalFields', $this->settings['flexform']['address']);

        if ($this->shop === null) {
            $paymentMethods = $this->paymentMethodRepository->findAll();
            if (count($paymentMethods) > 0) {
                $this->view->assign('calcTypes', [
                    'count' => count($paymentMethods),
                ]);
            } else {
                // Kompatibilitaetsmode mit calcTypes
                $PaymentMethods = $this->settings['calcTypes'];
                $PaymentMethods_count = 0;
                foreach ($PaymentMethods as $name => $value) {
                    if ($value == 1) {
                        ++$PaymentMethods_count;
                    }
                }

                $PaymentMethods['count'] = $PaymentMethods_count;

                $this->view->assign('calcTypes', $PaymentMethods);
            }
        } else {
            $paymentMethods = $this->shop->getPaymentmethods();
            // evt. fuer Kompatibilitaet (?)
            //$this->view->assign('calcTypes', ['count' => $paymentMethods->count()]);
        }

        $this->view->assign('paymentMethods', $paymentMethods);
        $this->view->assign('differentAddresses', $this->settings['differentAddresses']);

        return $this->htmlResponse();
    }

    public function editCalcAddressAction(array $errorFields = []): ResponseInterface
    {
        $address = $this->cartUtility->cart->getOrderinfo();

        $response = $this->checkMandatory('editCalcAddress');
        if ($response instanceof ResponseInterface) {
            return $response;
        }

        $requiredFields = [];
        $requiredFieldsTmp = GeneralUtility::trimExplode(',', $this->settings['requiredCalcAddressFields'] ?? '');

        foreach ($requiredFieldsTmp as $field) {
            $requiredFields[$field] = 1;
        }

        $this->view->assign('shop', $this->shop);
        $this->view->assign('requiredFields', $requiredFields);
        $this->view->assign('differentAddresses', $this->settings['differentAddresses']);
        $this->view->assign('step', 3);
        $this->view->assign('calcAddressInput', 1);
        $this->view->assign('order', $this->cartUtility->cart);
        $this->view->assign('calcAddress', $address['calcAddress'] ?? false);
        $this->view->assign('errorFields', $errorFields);

        return $this->htmlResponse();
    }

    public function saveCalcAddressAction(array $calcAddress = []): ResponseInterface
    {
        if (!$this->request->hasArgument('calcAddress')) {
            return new ForwardResponse('editCalcAddress');
        }

        //expects: address(formFieldName=>formFieldValue), see getErrorFieldsFromAddress() for mandatory fields

        $address = $this->cartUtility->cart->getOrderinfo();
        $address['calcAddress'] = $calcAddress;
        if ($this->settings['countryAsUid'] ?? false) {
            if ($address['calcAddress']['country'] ?? false) {
                $address['calcAddress']['country'] = $this->countryRepository->findByUid(
                    $address['calcAddress']['country']
                );
            }
        }

        $this->cartUtility->cart->setOrderinfo($address);
        $this->cartUtility->update();

        $response = $this->checkMandatory('saveCalcAddress', $address);
        if ($response instanceof ResponseInterface) {
            return $response;
        }

        return new ForwardResponse('review');
    }

    public function initializeSaveCalcAddressAction(): void
    {
        /*if (!$this->request->hasArgument('calcAddress')) {
            //return new ForwardResponse('editCalcAddress');
            $this->forward('editCalcAddress');
        }*/
    }



    public function initializeSaveAddressAction(): void
    {
        /*if (!$this->request->hasArgument('address')) {
            //return new ForwardResponse('editAddress');
            $this->forward('editAddress');
        }*/
    }

    public function saveAddressAction(array $address, array $addressSelect = []): ResponseInterface
    {
        if (!$this->request->hasArgument('address')) {
            return new ForwardResponse('editAddress');
        }

        $context = GeneralUtility::makeInstance(Context::class);
        if ($context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            $feUser = $this->feUserRepository->findByUid($context->getPropertyFromAspect('frontend.user', 'id'));

            if (!empty($addressSelect)) {
                if (!$this->settings['billingAddressIsMain']) {
                    $selectedAddress = $this->addressRepository->findByUid($addressSelect['address']);

                    $feUser->setLastUsedAddress($selectedAddress);

                    if (isset($addressSelect['calcAddress']) && !empty($addressSelect['calcAddress'])) {
                        $selectedCalcAddress = $this->addressRepository->findByUid($addressSelect['calcAddress']);
                        $feUser->setLastUsedBillingAddress($selectedCalcAddress);
                    } else {
                        $feUser->setLastUsedBillingAddress(null);
                    }
                } else {
                    $selectedCalcAddress = $this->addressRepository->findByUid($addressSelect['calcAddress']);

                    $feUser->setLastUsedBillingAddress($selectedCalcAddress);

                    if (isset($addressSelect['address']) && !empty($addressSelect['address'])) {
                        $selectedAddress = $this->addressRepository->findByUid($addressSelect['address']);
                        $feUser->setLastUsedAddress($selectedAddress);
                    } else {
                        $feUser->setLastUsedAddress(null);
                    }
                }
            } else {
                //$feUser = $this->feUserRepository->findByUid($GLOBALS['TSFE']->fe_user->user['uid']);
                $feUser->setLastUsedAddress(null);
                $feUser->setLastUsedBillingAddress(null);
            }

            $this->feUserRepository->update($feUser);

            $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
            $persistenceManager->persistAll();
        }

        if (!$this->settings['billingAddressIsMain']) {
            if ($this->settings['countryAsUid']) {
                if ($address['country']) {
                    $address['country'] = $this->countryRepository->findByUid($address['country']);
                }
            }

            // frueher: isCalcAddress
            if ($this->extraBillingAddress($address) && !$this->extraBillingAddressPage()) {
                if ($this->settings['countryAsUid'] ?? false) {
                    if ($address['calcAddress']['country'] ?? false) {
                        $address['calcAddress']['country'] = $this->countryRepository->findByUid(
                            $address['calcAddress']['country']
                        );
                    }
                }
            }
        } else {
            if ($this->settings['countryAsUid'] ?? false) {
                if ($address['calcAddress']['country'] ?? false) {
                    $address['calcAddress']['country'] = $this->countryRepository->findByUid(
                        $address['calcAddress']['country']
                    );
                }
            }

            // frueher: isCalcAddress
            if ($this->extraDeliveryAddress($address) && !$this->extraDeliveryAddressPage()) {
                if ($this->settings['countryAsUid']) {
                    if ($address['country']) {
                        $address['country'] = $this->countryRepository->findByUid($address['country']);
                    }
                }
            }
        }

        $this->saveAddressData($address);
        $this->saveSurvey($address['knowFromWhere'] ?? null);


        $response = $this->checkMandatory('saveAddress', $address);
        if ($response instanceof ResponseInterface) {
            return $response;
        }


        if (!$this->settings['billingAddressIsMain']) {
            if ($this->extraDeliveryAddress($address) && $this->extraDeliveryAddressPage()) {
                return new ForwardResponse('editDeliveryAddress');
            }
        } else {
            if ($this->extraBillingAddress($address) && $this->extraBillingAddressPage()) {
                return new ForwardResponse('editCalcAddress');
            }
        }

        return new ForwardResponse('review');
    }


    /**
     * submit invoice orders
     * bestellungen auf rechnung + mailversand
     * paypal&andere creditkarten werden in anderen *Action()s behandelt
     */
    public function submitPaymentAction(Order $order): ResponseInterface
    {
        $this->cartUtility->order = $order;
        if (isset($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']) && is_array(
            $GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks']
        )) {
            foreach ($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks'] as $classRef) {
                $hookObj = GeneralUtility::makeInstance($classRef);
                if (method_exists($hookObj, 'checkOrderState')) {
                    $hookObj->checkOrderState($this->cartUtility->order);
                }
            }
        }

        //enshures: order is marked as invoiceorder (rechnungsbestellung), mails are send to shop-seller and customer
        $request = $this->request->getArguments();
        $isPostFinance = (key_exists('complus', $request));

        $paymentMethod = $this->cartUtility->order->getPaymentMethod();
        if ($paymentMethod !== null && ($paymentMethod->getController() == 'PostFinanceCheckout' || $paymentMethod->getController() == 'PostFinance')) {
            if (!$isPostFinance || !$request['ordertosubmit']) {
                return $this->redirect('show');
            }
        }

        if ($isPostFinance) {
            $this->cartUtility->getOrderByUid($request['ordertosubmit']);
            if ($this->cartUtility->order->getSubmitted() > 0) {
                echo 'OK';
                exit;
            }
        }

        $response = $this->checkMandatory('submitPayment');
        if ($response instanceof ResponseInterface) {
            return $response;
        }

        $context = GeneralUtility::makeInstance(Context::class);
        $this->view->assign('loggedIn', $context->getPropertyFromAspect('frontend.user', 'isLoggedIn'));
        $this->cartUtility->order->setOrderdate(new DateTime());

        $this->submitMailsByOrder();
        if (is_object($this->cartUtility->order->getPorto())) {
            $portoPrice = $this->cartUtility->order->getPorto()->getPrice();
            $this->view->assign('portoPrice', $portoPrice);
        }

        $assignProducts = [];
        $orderProducts = $this->cartUtility->order->getProducts();
        foreach ($orderProducts as $orderProduct) {
            $assignProducts[$orderProduct->getUid()]['orderProduct'] = $orderProduct;
            $assignProducts[$orderProduct->getUid()]['name'] = $orderProduct->getProductName();
        }

        $this->view->assign('shop', $this->shop);
        $this->view->assign('orderProducts', $assignProducts);
        $this->view->assign('order', $this->cartUtility->order);
        $this->view->assign('address', $this->cartUtility->order->getOrderinfo());

        $this->cartUtility->setSubmitted(1);

        if ($context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            $feUser = $this->feUserRepository->findByUid($context->getPropertyFromAspect('frontend.user', 'id'));
            $feUser->setCurrentOrder(null);
            $this->feUserRepository->update($feUser);
        }

        if (isset($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']) && is_array(
            $GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks']
        )) {
            foreach ($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks'] as $classRef) {
                $hookObj = GeneralUtility::makeInstance($classRef);
                if (method_exists($hookObj, 'updateState')) {
                    $hookObj->updateState(
                        $this->cartUtility->order,
                        $this->stateRepository,
                        $this->productRepository,
                        $this->settings
                    );
                }
            }
        }

        $this->cartUtility->update();

        if ($this->settings['sendOrderToGoogleAnalytics']) {
            $optInIfCode = '';
            $optInIfCloseCode = '';
            $addItemGoogleAnalyticsJs = '';

            if ($this->settings['optInAnalytics']) {
                $optInIfCode .= "if(document.cookie.indexOf('cookieconsent_accept_analytics') > -1 || (document.cookie.indexOf('ig_cookies_disable=1') == -1 && document.cookie.indexOf('ig_cookies_accepted=2') > -1)) {";
                $optInIfCloseCode = '}';
            }

            foreach ($assignProducts as $product) {
                $addItemGoogleAnalyticsJs .= 'ga("ecommerce:addItem", {
                "id": "' . $this->cartUtility->order->getUid() . '",                     // Transaction ID. Required.
                "name": "' . $product['name'] . '",    // Product name. Required.
                "price": "' . $product['orderProduct']->getUnitPrice() . '",                 // Unit price.
                "quantity": "' . $product['orderProduct']->getAmount() . '"                  // Quantity.
              });';
            }

            $this->addJsFooterInline(
                'googleAnalyticsCode',
                $optInIfCode
                . 'ga("require", "ec");
                ga("ecommerce:addTransaction", {
                "id": "' . $this->cartUtility->order->getUid() . '",              // Transaction ID. Required.
                //"affiliation": "Store",       // Affiliation or store name.
                "revenue": "' . $this->cartUtility->order->getTotalWithPorto() . '",  // Grand Total.
                "shipping": "' . $portoPrice . '",       // Shipping.
                "currency": "' . $this->cartUtility->order->getCurrency()->getShort() . '"
            });'
                . $addItemGoogleAnalyticsJs
                . $optInIfCloseCode
            );
        }

        return $this->htmlResponse();
    }

    public function paymentErrorAction(): ResponseInterface
    {
        $this->view->assign('order', $this->cartUtility->cart);
        return $this->htmlResponse();
    }

    public function initializeAddProductAction(): void
    {
        /*if (!$this->request->hasArgument('product')) {
            $this->forward('show');
        }*/
    }

    public function addProductAction(Product $product, array $options = []): ResponseInterface
    {
        if (!$this->request->hasArgument('product')) {
            return new ForwardResponse('show');
        }

        $this->cartUtility->addProduct($product, $options);
        $this->cartUtility->update();
        if ($this->settings['noAjax']) {
            return new ForwardResponse('show');//, 'Order', 'igshop2');
        }

        die();
        /*
        $canBeOrdered = true;
        if(isset($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']) && is_array($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks'])) {
            foreach ($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks'] as $classRef) {
                $hookObj = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance($classRef);
                if (method_exists($hookObj, 'checkProductState')) {
                    $canBeOrdered = !$hookObj->checkProductState($product);
                }
            }
        }

        if($canBeOrdered) {
            $this->cartUtility->cart->addNewProduct( $product, $options, $this->settings['prodLimit'] );

            if($this->settings['noAjax']) {
                $this->forward('show');//, 'Order', 'igshop2');
            }
            $this->cartUtility->update();
        }
        return '';
        */
        return $this->htmlResponse();
    }

    public function deleteProductAction(int $productUid): ResponseInterface
    {
        $orderProduct = $this->orderProductRepository->findByUid($productUid);
        $this->cartUtility->removeCartProductByUid($productUid);
        $this->cartUtility->cart->setDeliveryPeriod($this->cartUtility->cart->getMaxDeliveryPeriod($orderProduct));
        $this->cartUtility->update();
        //$this->recalcOrder();
        return new ForwardResponse('show');
    }

    public function reviewAction(): ResponseInterface
    {
        $response = $this->checkMandatory('review');
        if ($response instanceof ResponseInterface) {
            return $response;
        }


        $params = $this->request->getArguments();

        $country = $this->cartUtility->cart->getCountryObject($this->settings['countryAsUid']);
        //$this->setCurrency( $request['currency'] );

        $this->cartUtility->setPorto($params['porto'] ?? null);

        // Fuer Mitgliederpreise
        $this->cartUtility->cart->calcAllOrderProductPrices();

        // Set JavaScript for Submission in Review
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterLibrary('igshop_review', $this->jsRootPath . 'Order/igshop_submit.js');

        $address = $this->cartUtility->cart->getOrderInfo();
        $reviewCalcAddress = null;

        if ($this->settings['countryAsUid']) {
            if ($address['country']) {
                $address['country'] = $this->countryRepository->findByUid($address['country']);
            }

            if ($address['calcAddress'] ?? false) {
                if ($address['calcAddress']['country'] ?? false) {
                    $address['calcAddress']['country'] = $this->countryRepository->findByUid(
                        $address['calcAddress']['country']
                    );
                }
            }
        }

        // @TODO Kategorie ohne Porto geht nciht + haesslich gelöst - fuer Abholen etc. kein Porto und falls ein Produkt ohne Porto vorhanden -> kein Porto
        $paymentMethod = $this->cartUtility->cart->getPaymentMethod();
        //if($address['payment'] == 'Abholen' || $address['payment'] == 'pickupThun' || $address['payment'] == 'pickupSpiez' || $this->cartUtility->cart->hasProductWithoutPorto() ) {
        //$this->cartUtility->cart->calcGrantTotal();
        //$this->recalcOrder();

        if (!$this->settings['billingAddressIsMain']) {
            $this->finisherAddNewsletter($address);

            if ($this->extraBillingAddress($address)) {
                $reviewCalcAddress = $this->getReviewAddressArray($address['calcAddress']);
            }

            if ($this->extraBillingAddress($address) && $this->extraBillingAddressPage()) {
                $this->view->assign('cartBackAction', 'editCalcAddress');
            } else {
                $this->view->assign('cartBackAction', 'editAddress');
            }
        } else {
            $this->finisherAddNewsletter($address['calcAddress']);

            $reviewCalcAddress = $this->getReviewAddressArray($address['calcAddress']);

            if ($this->extraDeliveryAddress($address)) {
                $reviewDeliveryAddress = $this->getReviewAddressArray($address['calcAddress']);
            }

            if ($this->extraDeliveryAddress($address) && $this->extraDeliveryAddressPage()) {
                $this->view->assign('cartBackAction', 'editDeliveryAddress');
            } else {
                $this->view->assign('cartBackAction', 'editAddress');
            }
        }

        // needed for PayPal actions - must be uppercase
        //$this->cartUtility->cart->getCurrency()->setShort(strtoupper($this->cartUtility->cart->getCurrency()->getShort()));

        // If (knowFromWhere) is set
        /*
          if(is_array($address['knowFromWhere'])) {
          $this->view->assign('knowFromWhere', implode(', ', $address['knowFromWhere']));
          }
        */

        $order = $this->cartUtility->createOrderFromCart();
        $shipping = $order->getShippingByService();

        if($shipping) {
            $shippingUtility = GeneralUtility::makeInstance(ShippingUtility::class);
            $order->setShipping($shipping);
            $order->setShippingAmount($shippingUtility->getShippingAmount($order));
            $this->orderRepository->update($order);
            $this->persistenceManager->persistAll();
        }

        // Set Order, Products and Address
        $this->view->assign('shop', $this->shop);
        $this->view->assign('order', $order);
        $this->view->assign(
            'setAgb',
            ($this->settings['flexform']['agbPage'] | $this->settings['flexform']['agbFile'])
        );
        //$this->view->assign('prodOptions', $prodOptions);
        //$reviewAddress = $this->getReviewAddressArray($address);
        //$this->view->assign('address', ($this->settings['compMode']||1 ? $address : $reviewAddress));
        $this->view->assign('address', $address);
        $this->view->assign('calcAddress', $reviewCalcAddress);
        // Shop Configurations
        $this->view->assign(
            'hasPorto',
            $this->cartUtility->cart->hasPorto()
        );//is_object($this->cartUtility->cart ->getPorto()));
        $this->view->assign('step', 4);
        $this->view->assign('review', 1);
        /*
          if ($this->settings['flexform']['minPortoFree'] > 0) {
          $this->view->assign('untilPortoFree', $this->settings['flexform']['minPortoFree'] - $this->cartUtility->cart->getTotal());
          }
        */

        // war frueher bei  count==1 nicht gesetzt -> in fluid anpassen [DA]
        $this->view->assign('portos', $this->cartUtility->getAvailablePortos());


        //PostFinance Data - if Payment is PostFinance
        $paymentMethod = $this->cartUtility->cart->getPaymentMethod();
        if ($paymentMethod && $paymentMethod->getController() == 'PostFinance') {
            //$this->view->assign('formTotal', $this->cartUtility->cart->getTotalWithPorto()*100);
            $this->view->assign('postfinance', [
                'amount' => $this->cartUtility->cart->getTotalWithPorto(),
                'currency' => strtoupper($this->cartUtility->cart->getCurrency()->getShort()),
                'orderid' => $this->cartUtility->cart->getUid(),
            ]);
        }

        /** Assign Settings->Abwärtskompatibilität **/
        $this->view->assign('smallShop', $this->settings['smallShop']);
        $this->view->assign('differentAddresses', $this->settings['differentAddresses']);
        $this->view->assign('additionalFields', $this->settings['flexform']['address']);
        $this->view->assign('minPortoFree', $this->settings['flexform']['minPortoFree']);

        $this->cartUtility->update();
        return $this->htmlResponse();
    }

    public function payPalEnterAction(): ResponseInterface
    {
        header('HTTP/1.1 200 OK');

        $uid = $_REQUEST['order_uid'];
        $res = '';
        $this->cartUtility->getCartByUid($uid);

        if ($_REQUEST['mc_currency'] == '') {
            $_REQUEST['mc_currency'] = strtoupper($this->cartUtility->cart->getCurrency()->getShort());
        }

        if ($_REQUEST['mc_currency'] == strtoupper(
            $this->cartUtility->cart->getCurrency()->getShort()
        ) && $_REQUEST['mc_gross'] == number_format($this->cartUtility->cart->getTotalWithPorto(), 2, '.', '')) {
            $_REQUEST['cmd'] = '_notify-validate';

            $paypalUrl = '';
            if ($this->settings['payPalSandbox']) {
                $paypalUrl = 'https://www.sandbox.paypal.com/cgi-bin/websc?';
            } else {
                $paypalUrl = 'https://www.paypal.com/cgi-bin/websc?';
            }

            $res = file_get_contents($paypalUrl . http_build_query($_REQUEST));

            if ($res == 'VERIFIED') {
                $this->cartUtility->setSubmitted(1);
                $this->cartUtility->update();
                $this->submitMailsByOrder();
            }

            //do nothing, faker
        }

        exit;
        return $this->htmlResponse();
    }

    public function payPalThanksAction(): ResponseInterface
    {
        if ($this->cartUtility->cart->getSubmitted() != 1) {//damit verifizierte zahlungen nicht Überschrieben werden
            $this->cartUtility->setSubmitted(6);
            //irgendwie durch, nur fehlt die verifizierung
            $this->cartUtility->update();
        }

        return $this->htmlResponse(LocalizationUtility::translate('order.thanks', 'igshop2') . '.');
    }

    public function loadSmallCartDataAction(): ResponseInterface
    {
        //echo $this->renderFluid('Order/Ajax/SmallFeCartProductsList.html', array('order' => $this->cartUtility->cart));
        //$this->recalcOrder();
        $this->view->assign('order', $this->cartUtility->cart);
        $this->view->assign('totalProdAmount', $this->cartUtility->cart->getTotalProductsAmount());

        /** Assign Settings->Abwärtskompatibilität **/
        $this->view->assign('cartPid', $this->settings['cartPid']);
        return $this->htmlResponse();
    }

    public function initializeSmallFeCartAction(): void
    {
        if ($this->settings['smallFeCart']['enable']) {
            $src = $this->jsRootPath . 'Order/igShop_smallFeCart.js';
            $this->includeJS($src);
        }
    }

    /**
     * Action get small FeCart
     */
    public function smallFeCartAction(?Order $order = null): ResponseInterface
    {
        $request = $this->request->getArguments();
        $currencyUid = (int)($request['currency'] ?? 0);
        if ($currencyUid > 0) {
            $this->currencyRepository->setSessionCurrency($currencyUid);
            $this->cartUtility->cart->setCurrency($this->currencyRepository->getCurrency());
        } else {
            $currencyUid = $this->currencyRepository->getCurrency()->getUid();
        }

        //$this->recalcOrder();
        $productCount = $this->cartUtility->cart->getTotalProductsAmount();

        $this->view->assign('shop', $this->shop);
        $this->view->assign('settings', $this->settings['smallFeCart']);
        $this->view->assign('cartPid', $this->settings['cartPid']);
        $this->view->assign('searchString', $_REQUEST['tx_igshop2_feshop']['searchString'] ?? '');
        $this->view->assign('currencyUid', $currencyUid);
        $this->view->assign('order', $this->cartUtility->cart);
        $this->view->assign('productCount', $productCount);
        $this->view->assign('currencies', $this->shop->getCurrencies());





        /* Puralpina Navigations Mist */
        $parentCategories = $this->categoryRepository->getParentCategories()->toArray();

        if (GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect('language', 'id') == 2) {
            $tmpCategories = $parentCategories;
            $parentCategories = [
                1 => '',
                2 => '',
                3 => '',
                4 => '',
            ];
            foreach ($tmpCategories as $singleCategory) {
                switch ($singleCategory->getName()) {
                    case 'Marmotte':
                        if ($this->productRepository->getProductByCategory(true, [$singleCategory]) > 0) {
                            $parentCategories[1] = $singleCategory;
                        } else {
                            unset($parentCategories[1]);
                        }

                        break;
                    case 'Artisanat':
                        if ($this->productRepository->getProductByCategory(true, [$singleCategory]) > 0) {
                            $parentCategories[2] = $singleCategory;
                        } else {
                            unset($parentCategories[2]);
                        }

                        break;
                    case 'Délectation':
                        if ($this->productRepository->getProductByCategory(true, [$singleCategory]) > 0) {
                            $parentCategories[3] = $singleCategory;
                        } else {
                            unset($parentCategories[3]);
                        }

                        break;
                    case 'Style':
                        if ($this->productRepository->getProductByCategory(true, [$singleCategory]) > 0) {
                            $parentCategories[4] = $singleCategory;
                        } else {
                            unset($parentCategories[4]);
                        }

                        break;
                    default:
                        $parentCategories[] = $singleCategory;
                        break;
                }
            }

        //print_r($parentCategories->toArray());
        } else {
            $tmpCategories = $parentCategories;
            $parentCategories = [
                1 => '',
                2 => '',
                3 => '',
                4 => '',
            ];
            foreach ($tmpCategories as $singleCategory) {
                switch ($singleCategory->getName()) {
                    case 'Murmeltiersalbe':
                        if ($this->productRepository->getProductByCategory(true, [$singleCategory]) > 0) {
                            $parentCategories[1] = $singleCategory;
                        } else {
                            unset($parentCategories[1]);
                        }

                        break;
                    case 'Handwerk':
                        if ($this->productRepository->getProductByCategory(true, [$singleCategory]) > 0) {
                            $parentCategories[2] = $singleCategory;
                        } else {
                            unset($parentCategories[2]);
                        }

                        break;
                    case 'Delikatessen':
                        if ($this->productRepository->getProductByCategory(true, [$singleCategory]) > 0) {
                            $parentCategories[3] = $singleCategory;
                        } else {
                            unset($parentCategories[3]);
                        }

                        break;
                    case 'Stil':
                        if ($this->productRepository->getProductByCategory(true, [$singleCategory]) > 0) {
                            $parentCategories[4] = $singleCategory;
                        } else {
                            unset($parentCategories[4]);
                        }

                        break;
                    default:
                        $parentCategories[] = $singleCategory;
                        break;
                }
            }
        }

        $this->view->assign('parentCategories', $parentCategories);
        /* Ende Puralpina Mist */
        return $this->htmlResponse();
    }

    public function getMailText(Order $order, bool $adminMail = false): string
    {
        $companyAddress = $this->settings['flexform']['customerMail']['address'];
        $prepaidData = $this->settings['flexform']['customerMail']['prepaidData'];

        if (strlen((string) $companyAddress) > 0) {
            $companyAddress = explode("\n", (string) $companyAddress);
        } else {
            $companyAddress = [];
        }

        if (strlen((string) $prepaidData) > 0) {
            $prepaidData = explode("\n", (string) $prepaidData);
        } else {
            $prepaidData = [];
        }

        // get BaseUrl and set slash at end if not set - important for images!
        $baseUrl = $GLOBALS['TSFE']->tmpl->setup['config.']['baseURL'] ?? '';
        if (!str_ends_with((string) $baseUrl, '/')) {
            $baseUrl .= '/';
        }

        $address = $order->getOrderinfo();
        if ($this->settings['countryAsUid']) {
            if ($address['country']) {
                $address['country'] = $this->countryRepository->findByUid($address['country']);
            }

            if ($address['calcAddress'] ?? false) {
                if ($address['calcAddress']['country'] ?? false) {
                    $address['calcAddress']['country'] = $this->countryRepository->findByUid(
                        $address['calcAddress']['country']
                    );
                }
            }
        }

        $params = [
            'shop' => $this->shop,
            'companyAddress' => $companyAddress,
            'prepaidData' => $prepaidData,
            'order' => $order,
            'currency' => $order->getCurrency(),
            'address' => $address,
            'logo' => $this->settings['flexform']['customerMail']['image'],
            'baseUrl' => $baseUrl,
            'contactLink' => $this->settings['flexform']['customerMail']['contactLink'],
            'isFirstOrder' => $this->settings['flexform']['address']['isFirstOrder'],
            'knowFromWhere' => $this->settings['flexform']['address']['knowFromWhere'],
            'mailInlineCSS' => $this->settings['mailInlineCSS'],
        ];
        // Debug Mail
        // Mail wird nicht versendet, sondern auf der Webseite ausgegeben
        if ($this->settings['debugMail']) {
            echo $this->renderFluid('Mail/Admin.html', $params);
            exit;
        }

        if ($adminMail) {
            return $this->renderFluid('Mail/Admin.html', $params);
        }

        return $this->renderFluid('Mail/Index.html', $params);
    }

    /**
     * Daten auch in Order speichern - Grund wohl zum Suchen? z.B. Backend?? [DA]
     **/
    public function saveAddressData(array $address): void
    {
        if ($this->settings['countryAsUid']) {
            if (isset($address['country']) && $address['country']) {
                if (!is_object($address['country'])) {
                    $country = $this->countryRepository->findByUid($address['country']);
                } else {
                    $country = $address['country'];
                }

                if (!empty($country)) {
                    $this->cartUtility->cart->setCountry($country);
                }
            }
        } else {
            $this->cartUtility->cart->setCountryText($address['country']);
        }

        if (isset($address['firstName']) && $address['firstName']) {
            $this->cartUtility->cart->setCustomername($address['firstName']);
        }

        if (isset($address['mail']) && $address['mail']) {
            $this->cartUtility->cart->setOrdermail($address['mail']);
        }

        if (isset($address['address']) && $address['address']) {
            $this->cartUtility->cart->setPlzort($address['address']);
        }

        if (is_array($address)) {
            $this->cartUtility->cart->saveAddress($address, $this->settings);
        }

        if (isset($address['payment']) && $address['payment']) {
            $paymentMethod = $this->paymentMethodRepository->findByUid($address['payment']);
            $this->cartUtility->cart->setPaymentMethod($paymentMethod);
        }

        if (isset($address['shippingService']) && $address['shippingService']) {
            $shippingService = $this->shippingServiceRepository->findByUid($address['shippingService']);
            $this->cartUtility->cart->setShippingService($shippingService);
        }

        if (isset($address['deliveryDate']) && is_array(
            $address['deliveryDate']
        ) && $address['deliveryDate']['date'] != '') {
            $deliveryDate = new DateTime($address['deliveryDate']['date']);
            $deliveryDate->setTime(12, 0, 0);
            $this->cartUtility->cart->setDeliveryDate($deliveryDate);
        } else {
            $this->cartUtility->cart->setDeliveryDate(null);
        }


        $this->cartUtility->cart->setIsMember($address['isMember'] ?? null);
        //$this->recalcOrder();
    }


    /**
     * Daten in Order speichern - Grund? warum nicht direkt mit object bei Form?[DA]

     **/
    public function saveSurvey(mixed $knowFromWhere): void
    {
        if (is_array($knowFromWhere) && $knowFromWhere !== []) {
            $uids = [];
            foreach ($knowFromWhere as $name => $e) {
                if ($name !== 'others') {
                    $uids[] = $e;
                }
            }

            $surveyObject = $this->surveyRepository->findWithUidsArray($uids);
            $this->cartUtility->cart->setSurvey($surveyObject);
        }

        $this->cartUtility->update();
    }

    public function getReviewAddressArray(array $address): array
    {
        $return = [];

        if (strlen((string) $address['company']) > 0) {
            $return['company'] = $address['company'];
        }

        $return['name'] = LocalizationUtility::translate(
            'order.salutation.' . $address['salutation'],
            'igshop2'
        ) . ' ' . $address['lastName'] . ' ' . $address['firstName'];
        $return['street'] = $address['address'];
        $return['city'] = $address['zip'] . ' ' . $address['city'];

        if ($this->settings['countryAsUid'] && is_object($address['country']) && strtoupper(
            (string) $address['country']->getShort()
        ) != 'CH') {
            $return['city'] .= ' ' . $address['country']->getName();
        }

        if (isset($address['phone']) && $address['phone']) {
            $return['phone'] = $address['phone'];
        }

        if (isset($address['mail']) && $address['mail']) {
            $return['mail'] = $address['mail'];
        }

        return $return;
    }

    protected function initializeAction(): void
    {
        if ($this->settings['shopUid']) {
            $this->shop = $this->shopRepository->findByUid($this->settings['shopUid']);
        }

        //$this->cartUtility->getCart();
        //}
        /*if ($this->settings['cartCSS']) {
          $this->response->addAdditionalHeaderData('<link rel="stylesheet" type="text/css" href="' . $this->settings['cartCSS'] . '" media="all" />');
          } else {
          //$this->response->addAdditionalHeaderData('<link rel="stylesheet" type="text/css" href="' . \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::siteRelPath($this->request->getControllerExtensionKey()) . 'Resources/Public/Css/Order/igShop_Orders.css" media="all" />');
          }*/

        if ($this->settings['shopJS']) {
            /*
            if (str_contains((string) $this->settings['shopJS'], 'EXT:igshop2/')) {
                $this->settings['shopJS'] = $this->settings['shopJS'];
            }
            */

            $this->jsRootPath = $this->settings['shopJS'];
            $this->jsLibsPath = $this->settings['shopJS'] . 'Lib/';
        } else {
            $this->jsRootPath = 'EXT:igshop2/Resources/Public/JavaScript/';
            $this->jsLibsPath = 'EXT:igshop2/Resources/Public/JavaScript/Lib/';
            //$this->jsRootPath = \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::siteRelPath($this->request->getControllerExtensionKey()) . 'Resources/Public/JavaScript/';
            //$this->jsLibsPath = \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::siteRelPath($this->request->getControllerExtensionKey()) . 'Resources/Public/JavaScript/Lib/';
        }

        $this->includeJS($this->jsLibsPath . 'placeholders/placeholders.js');

        if (!preg_match('/(?i)msie [7-8]/', (string) $_SERVER['HTTP_USER_AGENT'])) {
            $this->includeJS($this->jsLibsPath . 'perfect-scrollbar/perfect-scrollbar.jquery.min.js');
        }

        // Bestellungswaehrung mit Session abgleichen
        $request = $GLOBALS['TYPO3_REQUEST'];
        $frontendUser = $request->getAttribute('frontend.user');
        $this->cartUtility->cart->setCurrencyByUid($frontendUser->getKey('ses', 'selectedCurrency'));
    }

    private function getErrorFieldsFromAddress(array $address, string $requiredFields): array
    {
        $errorFields = [];

        $mandatoryFields = explode(',', $requiredFields);
        foreach ($mandatoryFields as $k => $v) {
            $str = trim($address[$v] ?? '');
            if (strlen($str) < 1) {
                $errorFields[$v] = $v;
            }

            if ($v == 'zip') {
                if ($str != intval($str) || (strlen($str) < 4 || strlen($str) > 7)) {
                    $errorFields[$v] = $v;
                }
            }

            if ($v == 'salutation') {
                if (intval($str) < 1) {
                    $errorFields[$v] = $v;
                }
            }
        }


        //mails
        if (in_array('mail', $mandatoryFields)) {
            $mandatoryMailFields = ['mail'];
            foreach ($mandatoryMailFields as $k => $v) {
                $str = trim((string) $address[$v]);
                if (!filter_var($str, FILTER_VALIDATE_EMAIL)) {
                    $errorFields[$v] = $v;
                }
            }
        } else {
            if (!empty($address['mail'])) {
                $str = trim((string) $address['mail']);
                if (!filter_var($str, FILTER_VALIDATE_EMAIL)) {
                    $errorFields['mail'] = 'mail';
                }
            }
        }

        return $errorFields;
    }

    private function generateConfirmation(): mixed
    {
        $parameters = [
            'order' => $this->cartUtility->cart,
            'shop' => $this->shop,
        ];
        $confirmationHtml = $this->renderFluid('Order/Confirmation.html', $parameters);

        $proc = proc_open(
            //'wkhtmltopdf -L 0 -R 0 -T 30 -B 20 --header-html ' . $tmpHeader . ' --footer-html ' . $tmpFooter . ' - -',
            "wkhtmltopdf --encoding 'utf-8' -L 20 -R 20 -T 15 -B 10 - -",
            [
                0 => ['pipe', 'r'],
                1 => ['pipe', 'w'],
            ],
            $pipes
        );

        fwrite($pipes[0], $confirmationHtml);
        fclose($pipes[0]);
        $pdf = stream_get_contents($pipes[1]);
        fclose($pipes[1]);
        proc_close($proc);

        return $pdf;
    }

    private function submitMail(mixed $from, mixed $to, string $subject, string $mailContentHtml): bool
    {
        $message = GeneralUtility::makeInstance(MailMessage::class);
        $message->setTo($to)
->setFrom($from);
        $css = '';
        if ($this->settings['mailCSS']) {
            $cssFile = GeneralUtility::getFileAbsFileName($this->settings['mailCSS']);
            $css = file_get_contents($cssFile);
            if ($css) {
                $css = '<style>' . $css . '</style>';
            }
        }

        $websiteTitle = $GLOBALS['TYPO3_REQUEST']->getAttribute('site')->getConfiguration()['websiteTitle'];
        if ($websiteTitle) {
            $websiteTitle .= ': ';
        }

        $message->subject($websiteTitle . $subject);
        $message->html(
            '<html><head><meta http-equiv="content-type" content="text/html; charset=UTF-8">' . $css . '</head><body>' . $mailContentHtml . '</body></html>'
        );

        if ($this->settings['orderConfirmationPdf']) {
            $filename = LocalizationUtility::translate(
                'order.confirmation.filename',
                'igshop2'
            ) . '_' . $this->cartUtility->order->getUid() . '.pdf';
            $tmpFilename = 'typo3temp/' . $filename;

            $fp = fopen($tmpFilename, 'w');
            fwrite($fp, (string) $this->generateConfirmation());
            fclose($fp);

            $message->attachFromPath($tmpFilename, $filename);

            $message->send();
            unlink($tmpFilename);
        } else {
            $message->send();
        }

        return $message->isSent();
    }

    private function submitMailsByOrder(): void
    {
        $submitted = $this->cartUtility->order->getSubmitted();
        $this->cartUtility->order->setSubmitted(false);
        $this->cartUtility->order->getTotal();
        $this->cartUtility->order->setSubmitted($submitted);

        $address = $this->cartUtility->order->getOrderinfo();

        $adminMailTo = $this->settings['flexform']['adminMail']['mail'];
        $adminMailFrom = $this->settings['flexform']['adminMail']['from']['email'];

        $fromMailCustomer = $this->settings['flexform']['customerMail'];
        $fromAddress = [];

        if ($fromMailCustomer['name'] && $fromMailCustomer['mail']) {
            $fromAddress = [
                $fromMailCustomer['mail'] => $fromMailCustomer['name'],
            ];
        } else {
            $fromAddress = [$adminMailTo];
        }

        // Customer Mail

        $customerMail = [
            $address['mail'] => $address['lastName'] . ' ' . $address['firstName'],
        ];

        $subject = $this->settings['flexform']['customerMail']['subject'];
        if (empty($subject)) {
            $subject = 'Ihre Bestellung';
        }

        $text = $this->getMailText($this->cartUtility->order);
        //echo($text);exit(0); // debug Mail
        if (is_array($customerMail) && GeneralUtility::validEmail(key($customerMail))) {
            $this->submitMail($fromAddress, $customerMail, $subject, $text);
        }

        // Admin Mail

        $adminSubject = $this->settings['flexform']['adminMail']['subject'];
        if (empty($adminSubject)) {
            $adminSubject = 'Neue Bestellung';
        }

        $adminText = $this->getMailText($this->cartUtility->order, true);

        //admin mail
        if ($adminMailTo) {
            $this->submitMail(
                $adminMailFrom ? [$adminMailFrom] : $fromAddress,
                [$adminMailTo],
                $adminSubject,
                $adminText
            );
        }

        // Save Order to File
        if ($this->settings['saveOrderToXmlEnable']) {
            $path = $this->settings['saveOrderToXmlPath'];
            //if($path[0]!='/') $path = realpath(PATH_site) .'/' .$path;
            //echo('mkdir:'. $path.'<br />');
            if (!is_dir($path)) {
                if (!mkdir($path)) {
                    $logger = GeneralUtility::makeInstance(
                        LogManager::class
                    )->getLogger(self::class);
                    $logger->log(
                        LogLevel::ERROR,
                        'Error: Create Folder ' . $path . '',
                        error_get_last()
                    );
                }
            }

            if (is_dir($path)) {
                $params = [
                    //'companyAddress' => $companyAddress,
                    //'prepaidData' => $prepaidData,
                    'order' => $this->cartUtility->order,
                    'currency' => $this->cartUtility->order->getCurrency(),
                    'address' => $this->cartUtility->order->getOrderinfo(),
                    //'baseUrl' => $baseUrl,
                    'hasPorto' => $this->cartUtility->order->hasPorto(),
                    'language' => $GLOBALS['TSFE']->config['config']['language'],
                ];

                $xmlContent = $this->renderFluid('Order/XmlExport.xml', $params);
                file_put_contents($path . '/order-' . $this->cartUtility->order->getUid() . '.xml', $xmlContent);
            }
        }

        //exit(0);
    }


    /**
     * renders fluid template
     * @param string $template path to fluid-html-template, form: ext/Resources/Private/Templates/*$template*
     * @param array $parameter key=>value pairs, where key is fluid placeholder {key} in the template
     * @return string rendered (html-format) template
     */
    private function renderFluid(string $template, array $parameter = []): string
    {
        $fluidView = GeneralUtility::makeInstance(StandaloneView::class);
        if (isset($GLOBALS['TYPO3_REQUEST'])) {
            $fluidView->setRequest($GLOBALS['TYPO3_REQUEST']);
        }

        //$fluidView->getRequest()->setControllerExtensionName('igshop2');
        $conf = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK
        );
        /*$templateRootPath = \TYPO3\CMS\Core\Utility\GeneralUtility::getFileAbsFileName($conf['view']['templateRootPaths'][0]);
          $templateFile = $templateRootPath.$template;
          $partialOrder = $extPath . 'Resources/Private/Partials/';
          $fluidView->setTemplatePathAndFilename($templateFile);*/
        $fluidView->setTemplate($template);
        $fluidView->setLayoutRootPaths($conf['view']['layoutRootPaths']);
        $fluidView->setTemplateRootPaths($conf['view']['templateRootPaths']);
        $fluidView->setPartialRootPaths($conf['view']['partialRootPaths']);
        if (!empty($parameter)) {
            $fluidView->assignMultiple($parameter);
        }

        return $fluidView->render();
    }



    private function setCurrency(array $currency): void
    {
        $currencyUid = $currency['uid'];

        // Erhaltene Waehrung setzen
        if ($currencyUid > 0) {
            $request = $GLOBALS['TYPO3_REQUEST'];
            $frontendUser = $request->getAttribute('frontend.user');
            $frontendUser->setKey('ses', 'selectedCurrency', $currencyUid);
            $frontendUser->storeSessionData();
            $this->cartUtility->cart->setCurrencyByUid($currencyUid);

            $this->currencyRepository->setSessionCurrency($currencyUid);
        // DA TODO
        //var_dump($this->currencyRepository->getCurrency());
        } else {
            // Keine Waehrung in session vorhanden
            if ($this->currencyRepository->getSessionCurrency() == false) {
                // Default Waehrung nach Land
                $currency = $this->cartUtility->getCountry()->getCurrency();
                $this->currencyRepository->setSessionCurrency($currency->getUid());
            }
        }

        $this->cartUtility->cart->setCurrency($this->currencyRepository->getCurrency());
    }

    // Extra Rechnungsadresse angewählt
    private function extraBillingAddress(array $address): bool
    {
        return $this->settings['differentAddresses']
        && (
            (isset($address['extraBillingAddress']) && $address['extraBillingAddress'])
            || ($address['isCalcAddress'] ?? false)
        ) || (isset($address['sameBillingAddress']) && !$address['sameBillingAddress']) && $address['payment'] != 'PayPal';
    }

    // Rechnungsadresse auf eigener Seite
    private function extraBillingAddressPage(): int
    {
        return $this->settings['extraBillingAddressPage'] && $this->settings['differentAddresses'];
    }

    // Extra Rechnungsadresse angewählt
    private function extraDeliveryAddress(array $address): bool
    {
        return $this->settings['differentAddresses'] && (isset($address['extraDeliveryAddress']) && $address['extraDeliveryAddress']) || (isset($address['sameDeliveryAddress']) && !$address['sameDeliveryAddress']) && $address['payment'] != 'PayPal';
    }

    // Rechnungsadresse auf eigener Seite
    private function extraDeliveryAddressPage(): int
    {
        return $this->settings['extraDeliveryAddressPage'] && $this->settings['differentAddresses'];
    }

    // sind alle zwingenden Felder ausgefüllt
    private function checkMandatory(string $currentAction, ?array $address = null): bool|ResponseInterface
    {
        // check show
        if ($currentAction == 'show') {
            return true;
        }

        // check editAddress
        if ($this->cartUtility->cart->getTotalProductsCount() == 0) {
            return $this->redirect('show', null, null, null, $this->settings['cartPid']);
        }

        if ($currentAction == 'editAddress') {
            return true;
        } // evtl. nur falls Anzahl Produkte >0

        // check saveAddress/editCalcAddress

        if ($address == null) { // waere immer gespeicher -> parameter bei Funktion nicht noetig
            $address = $this->cartUtility->cart->getOrderinfo();
        }


        if (!$this->settings['billingAddressIsMain']) {
            $errorFieldsAddress = $this->getErrorFieldsFromAddress($address, $this->settings['requiredAddressFields']);
            $errorAddress = count($errorFieldsAddress);

            if ($this->extraBillingAddress($address)) {
                $errorFieldsBillingAddress = $this->getErrorFieldsFromAddress(
                    $address['calcAddress'],
                    $this->settings['requiredCalcAddressFields']
                );
                $errorBillingAddress = count($errorFieldsBillingAddress);
            } else {
                $errorFieldsBillingAddress = [];
                $errorBillingAddress = false;
            }

            /*
              var_dump($errorFieldsAddress);
              var_dump($errorFieldsBillingAddress);
              echo('test='.$this->extraBillingAddressPage());
              echo('address='. $errorAddress  .', billing='. $errorBillingAddress);
            */


            // Rechnungsadresse auf eigener Seite
            if ($this->extraBillingAddressPage()) {
                if ($errorAddress) {
                    return (new ForwardResponse('editAddress'))
                            ->withArguments([
                                'errorFields' => $errorFieldsAddress,
                            ]);
                }
            } else {
                // Beides auf gleicher Seite
                if ($errorAddress || $errorBillingAddress) {
                    return (new ForwardResponse('editAddress'))
                        ->withArguments([
                            'errorFields' => $errorFieldsAddress,
                            'calcAddressErrorFields' => $errorFieldsBillingAddress,
                        ]);
                }
            }
        } else {
            $errorFieldsBillingAddress = $this->getErrorFieldsFromAddress(
                $address['calcAddress'],
                $this->settings['requiredCalcAddressFields']
            );
            $errorBillingAddress = count($errorFieldsBillingAddress);

            if ($this->extraDeliveryAddress($address)) {
                $errorFieldsAddress = $this->getErrorFieldsFromAddress(
                    $address,
                    $this->settings['requiredAddressFields']
                );
                $errorAddress = count($errorFieldsAddress);
            } else {
                $errorFieldsAddress = [];
                $errorAddress = false;
            }

            /*
              var_dump($errorFieldsAddress);
              var_dump($errorFieldsBillingAddress);
              echo('test='.$this->extraBillingAddressPage());
              echo('address='. $errorAddress  .', billing='. $errorBillingAddress);
            */


            // Rechnungsadresse auf eigener Seite
            if ($this->extraDeliveryAddressPage()) {
                if ($errorBillingAddress) {
                    return (new ForwardResponse('editAddress'))
                        ->withArguments([
                            'calcAddressErrorFields' => $errorFieldsBillingAddress,
                        ]);
                }
            } else {
                // Beides auf gleicher Seite
                if ($errorAddress || $errorBillingAddress) {
                    return (new ForwardResponse('editAddress'))
                        ->withArguments([
                            'errorFields' => $errorFieldsAddress,
                            'calcAddressErrorFields' => $errorFieldsBillingAddress,
                        ]);
                }
            }
        }

        if ($currentAction == 'saveAddress' || $currentAction == 'editCalcAddress') {
            return true;
        }

        // check saveCalcAddress
        if ($errorBillingAddress) {
            return (new ForwardResponse('editCalcAddress'))
                ->withArguments([
                    'errorFields' => $errorFieldsBillingAddress,
                ]);
        }

        if ($currentAction == 'saveCalcAddress') {
            return true;
        }

        // check review

        // check submitPayment

        return true;
    }


    private function finisherAddNewsletter(array $address): bool
    {
        if (!isset($address['newsletter']) || !$address['newsletter']) {
            return false;
        }

        $email = $address['mail'];

        // benoetigt min. tt_address 3.0.0
        $addressRepository = GeneralUtility::makeInstance(AddressRepository::class);

        $ttAdressPid = $this->settings['addressPid'];
        if ($ttAdressPid > 0) {
            $querySettings = $addressRepository->createQuery()
->getQuerySettings();
            $querySettings->setStoragePageIds([$ttAdressPid]);
            $addressRepository->setDefaultQuerySettings($querySettings);
        }

        $ttAddress = $addressRepository->findByEmail($email);

        // E-Mail schon vorhanden?
        if (count($ttAddress) > 0) {
            return false;
        }

        $ttAddress = GeneralUtility::makeInstance(Address::class);
        $ttAddress->setEmail($email);
        $ttAddress->setFirstName($address['firstName']);
        $ttAddress->setLastName($address['lastName']);
        $ttAddress->setAddress($address['address']);
        $ttAddress->setCity($address['city']);
        $ttAddress->setZip($address['zip']);
        if ($address['salutation'] == 1) {
            $gender = 'm';
        } elseif ($address['salutation'] == 2) {
            $gender = 'f';
        } else {
            $gender = $address['salutation'];
        }

        $ttAddress->setGender($gender);
        $ttAddress->setModuleSysDmailHtml(1);
        if ($ttAdressPid > 0) {
            $ttAddress->setPid($ttAdressPid);
        }

        $addressRepository->add($ttAddress);


        return true;
    }
}
