<?php

namespace InternetGalerie\Igshop2\Controller;

use InternetGalerie\Igshop2\Database\Query\ProductQueryBuilder;
use InternetGalerie\Igshop2\Utility\AjaxUtility;
use InternetGalerie\Igshop2\Domain\Model\Product;
use GeorgRinger\NumberedPagination\NumberedPagination;
use ID\IndexedSearchAutocomplete\Service\SearchService;
use InternetGalerie\Igshop2\Domain\Model\Shop;
use InternetGalerie\Igshop2\Domain\Repository\CategoryRepository;
use InternetGalerie\Igshop2\Domain\Repository\CurrencyRepository;
use InternetGalerie\Igshop2\Domain\Repository\OptionColorRepository;
use InternetGalerie\Igshop2\Domain\Repository\OptionSizeRepository;
use InternetGalerie\Igshop2\Domain\Repository\OptionWithPriceRepository;
use InternetGalerie\Igshop2\Domain\Repository\ProductClassRepository;
use InternetGalerie\Igshop2\Domain\Repository\ProductRepository;
use InternetGalerie\Igshop2\Domain\Repository\ShopRepository;
use InternetGalerie\Igshop2\Utility\CartUtility;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Http\HtmlResponse;
use TYPO3\CMS\Core\Http\PropagateResponseException;
use TYPO3\CMS\Core\MetaTag\MetaTagManagerRegistry;
use TYPO3\CMS\Core\Page\AssetCollector;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Pagination\ArrayPaginator;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\PathUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Http\ForwardResponse;
use TYPO3\CMS\Extbase\Pagination\QueryResultPaginator;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;

/**
 * ProductController
 */
class ProductController extends ActionController
{
    protected Shop $shop;

    protected $defaultElementsInRow = 25;

    protected $defaultProductsPerPage = 96;

    private $jsRootPath = 'EXT:igshop2/Resources/Public/JavaScript/';

    public function __construct(
        protected CartUtility $cartUtility,
        protected CurrencyRepository $currencyRepository,
        protected CategoryRepository $categoryRepository,
        protected ProductClassRepository $productClassRepository,
        protected ProductRepository $productRepository,
        protected OptionColorRepository $optionColorRepository,
        protected OptionSizeRepository $optionSizeRepository,
        protected OptionWithPriceRepository $optionWithPriceRepository,
        protected ShopRepository $shopRepository,
        protected AssetCollector $assetCollector,
        protected AjaxUtility $ajaxUtility,
    ) {
    }

    /*
      protected function initializeAction() {
      //$this->productRepository->setSettings($this->settings);
      //add css for jquery ui

      // add js for images

      //$this->jsRootPath = \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::siteRelPath($this->request->getControllerExtensionKey()) . 'Resources/Public/JavaScript/';

      if($this->settings['shopJS']){
      if(strpos($this->settings['shopJS'], 'EXT:igshop2/') !== false) {
      $this->settings['shopJS'] = str_replace('EXT:igshop2/', \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::siteRelPath('igshop2'), $this->settings['shopJS']);
      }

      $this->jsRootPath = $this->settings['shopJS'];
      }

      if($this->settings['compMode']){
      $this->includeJS($this->jsRootPath.'Products/igShop_Products_AjaxCart.js');
      $this->includeJS($this->jsRootPath.'Products/igShop_Products_PriceCalc.js');
      }

      // add js for amount input
      // add color animation for responsive buying of a product
      $this->includeJS($this->jsRootPath.'Lib/jquery-color/color.js');
      // Add jquery ui for money filter
      $this->includeJS($this->jsRootPath.'Lib/jquery-ui/jquery-ui.min.js');
      //Add Script from perfect Scrollbar - ohne IE8 Support
      $this->includeJS($this->jsRootPath.'Lib/perfect-scrollbar/perfect-scrollbar.jquery.min.js');
      }
    */
    public function includeJS($filename): void
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile($filename);
    }

    protected function getSearch(): array
    {
        $request = $this->request->getArguments();
        if (isset($request['categories']) && is_array($request['categories'])) {
            $categories = $request['categories'];
        } else {
            $categories = GeneralUtility::intExplode(',', $request['categories'] ?? '', true);
        }

        $search = (isset($request['search']) && is_array($request['search'])) ? $request['search'] : [];
        $search = [
            'color' => $request['color'] ?? null,
            'size' => $request['size'] ?? null,
            'keyword' => $request['searchString'] ?? '',
            'category' => $request['category'] ?? null,
            'categories' => $categories,
            'productClass' => $request['productClass'] ?? null,
            'minPrice' => $request['minPrice'] ?? null,
            'maxPrice' => $request['maxPrice'] ?? null,
            'properties' => $request['properties'] ?? [],
            'priceRange' => $request['priceRange'] ?? [],
            ...$search,
        ];

        /*
        $searchString = $request['searchString'] ?? '';
        if ($searchString) {
            $search['keyword'] = $searchString;
        }
        */
        /*if (!isset($search['sorting']) && $sorting) {
            $search['sorting'] = $sorting .'  '. $sortWay;
        }
        if (!isset($search['state']) && $statusses) {
            $search['state'] = $statusses;
        }*/

        /*
        if (!isset($search['category']) || $search['category'] == null) {
            if ($catNavUids) {
                $search['category'] = $catNavUids;
            } elseif ($flexUids) {
                $search['category'] = GeneralUtility::intExplode(',', $flexUids);
            }
        }
        */

        $sortSettings = $this->getSettingsSorting();
        [$sorting, $sortWay] = explode('.', $sortSettings);
        //$request['sorting'] = 'weight';
        if (isset($request['sorting']) && $request['sorting']) {
            $sorting = $request['sorting'] ?? '';

            if (str_contains((string) $sorting, '.')) {
                [$sorting, $sortWay] = explode('.', (string) $sorting);
            }

            if (is_array($sorting)) {
                $sorting = implode(',', $sorting);
            }
        }

        //$request['sortWay'] = 'desc';
        if (isset($request['sortWay']) && $request['sortWay']) {
            $sortWay = $request['sortWay'] ?? null;
        }

        return $search;
    }
    protected function getCurrency()
    {
        return $this->cartUtility->cart->getCurrency();
    }

    // New json ajax
    public function searchAjaxAction(): ResponseInterface
    {
        $search = $this->getSearch();
        $currency = $this->getCurrency();
        $maxResults = (int)($search['maxResults'] ?? 0);
        if ($maxResults < 1 || $maxResults > 50) {
            $maxResults = 5;
        }

        $imageMaxWidth = 100;
        $imageMaxHeight = 100;
        $queryBuilder = $this->productRepository->queryBuilderBySearchAjax($search, $currency);

        // clone and count the results
        $countQb = clone $queryBuilder;
        $count = $countQb
            ->count(ProductQueryBuilder::$tablename . '.uid')
            ->executeQuery()
            ->fetchOne();

        $queryBuilder->setMaxResults($maxResults);
        $products = $queryBuilder->executeQuery()->fetchAllAssociative();

        $pageUid = (int)$this->settings['flexform']['singlePage'];
        $uriBuilder = $this->uriBuilder
                    ->reset();
        //->setRequest($this->request);

        foreach ($products as &$product) {
            $imageIds = $this->ajaxUtility->getImageIds($product['uid'], 'image', ProductQueryBuilder::$tablename);
            $imagePaths = $this->ajaxUtility->getImagePaths($imageIds, $imageMaxWidth, $imageMaxHeight);
            $product['image'] = $imagePaths;
            $detailPageUid = $this->ajaxUtility->getDetailPageUid($product['uid'], (int)$product['site_id'], $pageUid ? : $GLOBALS['TSFE']->id);
            $uriBuilder->setTargetPageUid($detailPageUid);
            $controllerArgs = ['product' => $product['uid']];
            $prod = $this->productRepository->findByUid($product['uid']);

            $price = $product['price'];
            $finalPrice = $prod->getFinalPrice($currency, null, 0, true);
            $product['finalPrice'] =  $finalPrice;
            $hasPromoPrice = $finalPrice != $price;
            $product['hasPromoPrice'] = $hasPromoPrice;
            $product['badge'] = [];
            if ($product['product_of_month']) {
                $product['badge']['img'] =  PathUtility::getPublicResourceWebPath('EXT:igshop2/Resources/Public/Images/Products/productOfMonth.svg');
                $product['badge']['alt'] = LocalizationUtility::translate('productOfMonth', 'IgShop');
            } elseif ($hasPromoPrice) {
                $product['badge']['img'] =  PathUtility::getPublicResourceWebPath('EXT:igshop2/Resources/Public/Images/Products/specialOffer.svg');
                $product['badge']['alt'] = LocalizationUtility::translate('specialOffer', 'Igshop2');
            }
            if ($hasPromoPrice) {
                $product['origPrice'] = $price;
                $product['price'] = $finalPrice['price'];
            }
            $uri = $uriBuilder->uriFor(
                'show',
                $controllerArgs,
                null,
                null,
                'FeshopShow',
            );
            $product['showUrl'] = $uri;
            unset($product['site_id']);
            /*
            $imageIds = $this->ajaxUtility->getImageIds($product['uid'], 'image_thumb', ProductQueryBuilder::$tablename);
            $imagePaths = $this->ajaxUtility->getImagePaths($imageIds);
            $product['image_thumb'] = $imagePaths;
            */
        }
        
        $json = json_encode([
            'status' => [
                'error' => false,
            ],
            'count' => $count,
            'products' => $products,
        ]);
        $response = $this->responseFactory->createResponse()
                                          ->withHeader('Content-Type', 'application/json; charset=utf-8')
                                          ->withHeader('Expires', '0')
                                          ->withHeader('Cache-Control', 'private');
        $response->getBody()->write($json);
        throw new PropagateResponseException($response, 200);
    }
    public function listAction(): ResponseInterface
    {
        
        $search = $this->getSearch();

        $this->view->assign('search', $search);
        // Set sorting (userSorting or productSorting)
        $sortSettings = $this->getSettingsSorting();
        [$sorting, $sortWay] = explode('.', $sortSettings);
        //$request['sorting'] = 'weight';
        if (isset($request['sorting']) && $request['sorting']) {
            $sorting = $request['sorting'] ?? '';

            if (str_contains((string) $sorting, '.')) {
                [$sorting, $sortWay] = explode('.', (string) $sorting);
            }

            if (is_array($sorting)) {
                $sorting = implode(',', $sorting);
            }
        }

        //$request['sortWay'] = 'desc';
        if (isset($request['sortWay']) && $request['sortWay']) {
            $sortWay = $request['sortWay'] ?? null;
        }

        $this->view->assign('sorting', $sorting);
        $this->view->assign('sortWay', $sortWay);

        // Get and Set Currency
        $currency = $this->getCurrency();
        if ($this->currencyRepository->getSessionCurrency() == false) {
            if (is_object($currency)) {
                $this->currencyRepository->setSessionCurrency($currency->getUid());
            }
        }

        $this->assignFilter($search, $currency);

        $properties = [];
        if (isset($request['properties']) && !empty($request['properties'])) {
            foreach ($request['properties'] as $property) {
                $properties[$property['fieldName']] = $property['value'];
            }

            $this->view->assign('properties', $properties);
        }


        // Get Products - filtered by settings
        $products = null;
        if ($this->settings['flexform']['showOnlyActionPrices'] ?? false) {
            $products = $this->productRepository->getProductsWithActionPrice($sorting, $sortWay);
        } else {
            $flexGroups = $this->settings['flexform']['group'];
            $catNavUids = $request['category'] ?? '';
            $this->view->assign('category', $catNavUids);

            $statusses = array_filter(GeneralUtility::trimExplode(',', $this->settings['flexform']['status'] ?? ''));
            $disableCatSort = (bool)$this->settings['disableCatSort'];

            if ($catNavUids) {
                $this->view->assign('categoryObj', $this->categoryRepository->findByUid($catNavUids));
            } elseif ($flexGroups) {
                $this->view->assign('categoryObj', $this->categoryRepository->findByUid($flexGroups));
            }

            // new or old search
            if (false) {
                if (!isset($search['sorting']) && $sorting) {
                    $search['sorting'] = $sorting .'  '. $sortWay;
                }
                if (!isset($search['state']) && $statusses) {
                    $search['state'] = $statusses;
                }

                if (!isset($search['category']) || $search['category'] == null) {
                    if ($catNavUids) {
                        $search['category'] = $catNavUids;
                    }
                }
                $products = $this->productRepository->findBySearchExecute($search, $currency);
            } else {
                // old search
                //echo('Products new='. count($products));
                $products = $this->productRepository->findAll(
                    $flexGroups,
                    null,//$catNavUids, // DA macht wohl keinen sinn wird überschrieben
                    $sorting,
                    $sortWay,
                    $search,
                    $currency,
                    $search['keyword'] ?? '',
                    0,
                    $statusses,
                    $disableCatSort,
                    $properties
                );
                //die('. Old='.count($products));
            }

        }

        $productsPerPage = (int) ($this->settings['flexform']['productsPerPage'] ?? $this->defaultProductsPerPage);
        if ($productsPerPage > 0) {
            $currentPage = $this->request->hasArgument('currentPage') ? (int)$this->request->getArgument(
                'currentPage'
            ) : 1;

            $paginator = null;

            if (is_array($products)) {
                $paginator = new ArrayPaginator($products, $currentPage, $productsPerPage);
            } else {
                $paginator = new QueryResultPaginator($products, $currentPage, $productsPerPage);
            }

            $pagination = new NumberedPagination($paginator, 10); // zweiter Argument: maximal Anzahl Links

            $this->view->assign('pagination', [
                'paginator' => $paginator,
                'pagination' => $pagination,
            ]);

            $this->view->assign('request', $this->request);
        }

        $this->view->assign('products', $products);

        // do we need this? or should we move it up or do we habe pages with productsPerPage=0 to show all products on one page (DA: 2024-04-11)
        if ($productsPerPage < 1) {
            $productsPerPage = $this->defaultProductsPerPage;
        }

        // Set the Currency
        $this->view->assign('currencies', $this->shop->getCurrenciesAssociative());
        $this->view->assign('currency', $this->currencyRepository->getCurrency());

        // Assign Settings - abwärtskompatibilität

        $this->view->assign('productsInRows', $this->getSettingsElementsInRow());

        $this->view->assign('productsPerPage', $productsPerPage);
        $this->view->assign('singlePage', $this->settings['flexform']['singlePage']);

        // Andere Page ID fuer Details
        $detailPageId = $this->settings['flexform']['detailPage'] ?? 0;
        if ($detailPageId > 0) {
            $this->view->assign('detailPage', $detailPageId);
        }

        $this->view->assign('detailPage', 2122);

        $this->view->assign('productCount', count($products));
        $this->view->assign('cartPageId', $this->settings['cartPid']);
        $this->view->assign('request', $this->request);

        if((int)$this->settings['smallShop']) {
            $this->includeJS($this->jsRootPath . 'Products/igShop_Products.js');
        }

        return $this->htmlResponse();
    }

    public function showTopProductAction(): ResponseInterface
    {
        $topProduct = null;
        if (isset($this->settings['flexform']['group']) && $this->settings['flexform']['group']) {
            $cateoryUids = GeneralUtility::trimExplode(',', $this->settings['flexform']['group']);
            $topProduct = $this->productRepository->findByCategories($cateoryUids);
        } else {
            $topProduct = $this->productRepository->findByUids($this->settings['flexform']['single']);
        }


        $this->view->assign('currencies', $this->shop->getCurrenciesAssociative());
        $this->view->assign('currency', $this->currencyRepository->getCurrency());

        $this->view->assign('products', $topProduct);

        /** View Assign Settings - abwärtskompatibilität **/

        if ($this->settings['flexform']['singlePage'] > 0) {
            $this->view->assign('singlePage', $this->settings['flexform']['singlePage']);
        }

        if ($this->settings['flexform']['cropDescription'] > 0) {
            $this->view->assign('cropDescription', $this->settings['flexform']['cropDescription']);
        }

        $this->view->assign('productsInRows', $this->getSettingsElementsInRow());
        $this->view->assign('productsPerPage', count($topProduct->toArray()));

        return $this->htmlResponse();
    }

    public function initializeShowAction(): void
    {
    }

    /**
     * show product detail page
     * allow access without product, for old inactive products, will be redirected to listPage
     */
    public function showAction(
        Product $product = null,
        bool $topProduct = false
    ): ResponseInterface {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $args = $this->request->getArguments();
        if (isset($this->settings['flexform']['single']) && $this->settings['flexform']['single'] > 0) {
            $productUid = intval($this->settings['flexform']['single']);
            $this->request->setArgument('product', $productUid);
        } else {
            $productUid = (int) ($args['product'] ?? 0);
        }

        $product = $this->productRepository->findByUid($productUid);
        $productNotAllowedOnPage = false;
        $flexGroups = $this->settings['flexform']['group'];
        if ($flexGroups && $product) {
            $categoryUids = GeneralUtility::intExplode(',', $flexGroups);

            if (!$product->hasCategoryIn($categoryUids)) {
                // Product is not allows according the groups/category settings
                $productNotAllowedOnPage = true;
            }
        }

        if ($productNotAllowedOnPage) {
            if ($categoryFirst = $product->getCategoryFirst()) {
                if ($detailPageUid = $categoryFirst->getDetailPageUid()) {
                    //var_dump($product->getCategoryFirst());die('detailPageUid='.  $detailPageUid .'(list='.$categoryFirst->getListPageUid().')');
                    //$this->request->setPluginName('FeshopShow');
                    return $this->redirect('show', 'Product', null, [
                        'product' => $product,
                    ], $detailPageUid, 0, 301); //301=Permanent Redirect
                }

                if ($listPageUid = $categoryFirst->getListPageUid()) {
                    //$this->request->setPluginName('Feshop');
                    return $this->redirect(
                        'show',
                        'Product',
                        null,
                        null,
                        $listPageUid,
                        0,
                        301
                    ); //301=Permanent Redirect
                }
            }

            $product = null;
        }

        if (!$product) {
            if ($this->settings['flexform']['listPage'] > 0) {
                //$this->request->setPluginName('Feshop');
                return $this->redirect('list', 'Product', null, null, intval($this->settings['flexform']['listPage']));
            }

            return new ForwardResponse('list');
        }

        //$product = $this->productRepository->findByUid($product->get_localizedUid());
        // Aktuelle Waehrung klaeren
        $defaultCountry = $this->shop->getDefaultCountry();
        $currencyDefault = $this->currencyRepository->findOneByUid($defaultCountry->getCurrency());
        if (!$currencyDefault) {
            return 'No default currency set';
        }

        $currencyId = null;
        if (isset($_GET['currency'])) {
            //$_SESSION['currency'] = $_GET['currency'];
            $cr = $this->currencyRepository->findByShort($_GET['currency']);
            $c = $cr->getFirst();
            if ($c) {
                $currencyId = $c->getUid();
            } else {
                $currencyId = $currencyDefault->getUid();
            }
        } else {
            $currencyId = isset($_REQUEST['tx_igshop2_feshop']) ? $_REQUEST['tx_igshop2_feshop']['currency']['uid'] : 0;
        }

        if ($currencyId > 0) {
            $this->currencyRepository->setSessionCurrency($currencyId);
        }

        $imageUrl = '';
        $metaTagManager = GeneralUtility::makeInstance(MetaTagManagerRegistry::class)->getManagerForProperty(
            'og:title'
        ); //OpenGraphMetaTagManager
        if (count($product->getImage()->toArray()) > 0) {
            $imageUrl = 'http://' . $_SERVER['SERVER_NAME'] . '/' . $product->getImage()->toArray()[0]->getOriginalResource()->getPublicUrl();
            $metaTagManager->addProperty('og:image', $imageUrl);
        }

        $metaTagManager->addProperty('og:url', $this->uriBuilder->getRequest()->getUri());
        $metaTagManager->addProperty('og:title', $product->getName());
        $metaTagManager->addProperty(
            'og:description',
            $this->truncate(strip_tags((string) $product->getDescription()), 250, '...')
        );

        // Nicht Hauptwährung, canonical Tag auf Default Produktseite
        if (($currencyId !== null && $currencyId != $currencyDefault->getUid()) || isset($_GET['currency'])) {
            $requestUri_exploded = explode('?', $this->uriBuilder->getRequest()->getUri());
            $pageRenderer->addHeaderData('<link ' .
                                         GeneralUtility::implodeAttributes([
                                             'rel' => 'canonical',
                                             'href' => $requestUri_exploded[0],
                                         ]) . ' />' . LF);
        }

        $GLOBALS['TSFE']->page['title'] = $product->getName();
        // set pagetitle for indexed search to news title
        $GLOBALS['TSFE']->indexedDocTitle = $product->getName();

        // Set Javascript for Show View
        $this->includeJS($this->jsRootPath . 'Products/igShop_Products.js');
        if ($this->settings['elevateZoom']) {
            $src = $this->jsRootPath . 'Lib/Elevatezoom/jquery.elevateZoom.min.js';
            $this->includeJS($src);
            $this->includeJS($this->jsRootPath . 'Products/products-elevateZoom.js');
        }

        if ($this->settings['reminderList']['enable']) {
            $this->includeJS('EXT:igshop2/Resources/Public/JavaScript/ReminderList/reminderList.js');
        }


        // check if thumbs should be set
        $thumbs = 0;
        // check if separatet thumbs are set correctly (same amount)
        $separateThumbs = 0;

        if (count($product->getImage()) > 1 || ($product->getVideos()->count() >= 1 && $product->getImage() >= 1)) {
            $thumbs = 1;
            if (count($product->getImage()) == count($product->getImageThumb())) {
                $separateThumbs = 1;
            }
        }

        $shareButtons = false;
        if (is_array($this->settings['flexform']['socialMedia'])) {
            $shareButtons = true;
        }

        // Build the link to share
        $socialMediaLink = $this->uriBuilder
                         ->reset()
                         ->setTargetPageUid($GLOBALS['TSFE']->id)
                         ->setCreateAbsoluteUri(true)
                         ->setArguments([
                             'tx_igshop2_feshop' => [
                                 'product' => $product->getUid(),
                             ],
                         ])
                         ->build();

        $this->view->assign('imageUrl', $imageUrl);
        $this->view->assign('socialMediaLink', urlencode($socialMediaLink));
        $this->view->assign('shareButtons', $shareButtons);

        $hasRelatedCategoryProducts = false;
        if ($this->settings['flexform']['relatedProducts'] && $this->settings['flexform']['relatedProducts'] != 'onlyProdRelations' && count(
            $product->getCategory()
        ) > 0) {
            // Get related products by category
            $relatedProducts = $this->productRepository->getByCategoryExcludeProduct($product);
            $this->view->assign('relatedProducts', $relatedProducts);
            if (count($relatedProducts) > 0) {
                $hasRelatedCategoryProducts = true;
            }
        }

        if ($hasRelatedCategoryProducts || count($product->getProducts()) > 0) {
            $this->view->assign('hasRelatedProducts', 1);
        }

        $this->view->assign('product', $product);

        $this->view->assign('thumbs', $thumbs);
        $this->view->assign('separateThumbs', $separateThumbs);



        $this->view->assign('shop', $this->shop);
        $this->view->assign('currency', $this->currencyRepository->getCurrency());
        $this->view->assign('currencies', $this->shop->getCurrenciesAssociative());


        /** Assign settings - abwärtskompatibilität **/

        if ($this->settings['flexform']['listPage'] > 0) {
            $this->view->assign('listPage', $this->settings['flexform']['listPage']);
        }

        $this->view->assign('thumbs', $thumbs);
        $this->view->assign('separateThumbs', $separateThumbs);
        $this->view->assign('ajaxProduct', $this->settings['ajaxProduct'] ?? 0);
        $this->view->assign('elevateZoom', $this->settings['elevateZoom'] ?? 0);
        $this->view->assign('cartPageId', $this->settings['cartPid'] ?? 0);
        $this->view->assign('prodLimit', $this->settings['prodLimit'] ?? 0);

        $returnUrl = $this->uriBuilder->getRequest()
                                      ->getRequestTarget();
        $this->view->assign('returnUrl', $returnUrl);

        if ($this->request->hasArgument('category')) {
            $categoryObj = $this->categoryRepository->findByUid($this->request->getArgument('category'));
            $this->view->assign('category', $this->request->getArgument('category'));
            $this->view->assign('categoryObj', $categoryObj);
        }

        if (isset($this->settings['productComparison']['enable']) && $this->settings['productComparison']['enable']) {
            $pageRenderer->addCssFile('EXT:igshop2/Resources/Public/Css/Products/igShop_ProductComparison.scss');
            $pageRenderer->addJsFooterFile(
                'EXT:igshop2/Resources/Public/JavaScript/ProductComparison/productComparison.js'
            );
        }

        return $this->htmlResponse();
    }

    public function exportAction(?string $currency = null): ResponseInterface
    { // () {
        //$excludeCategory = $this->categoryRepository->findByUid(11);
        //$products = $this->productRepository->findAllExceptCategory($excludeCategory);
        $products = $this->productRepository->findAllForExport();
        if ($currency === null) {
            $currency = isset($_GET['currency']) && $_GET['currency'] ? $_GET['currency'] : 'CHF';
        }

        $exportProducts = [];
        $countTotal = 0;
        $productsMissing = [];
        foreach ($products as $p) {
            $hasValidOption = false;
            if ($p->getOptionsWithPrice() && count($p->getOptionsWithPrice()) > 0) {
                //echo('OPTION: ' . $p->getName() .'('.$p->getGtin().','.$p->getMpn().')<br />');
                foreach ($p->getOptionsWithPrice() as $op) {
                    if ($op->getGtin() || $op->getMpn()) {
                        $hasValidOption = true;
                        $tp = clone $p;
                        $tp->setPrice($op->getPrice());
                        $tp->setPriceEuro($op->getPriceEuro());
                        if ($op->getGtin()) {
                            $tp->setGtin($op->getGtin());
                        }

                        if ($op->getMpn()) {
                            $tp->setMpn($op->getMpn());
                        }

                        if ($op->getName()) {
                            if (stristr((string) $op->getName(), (string) $tp->getName())) {
                                $tp->setName($op->getName());
                            } else {
                                $tp->setName($tp->getName() . ' - ' . $op->getName());
                            }
                        }

                        if (count($op->getImage())) {
                            $tp->setImage($op->getImage());
                        }

                        ++$countTotal;
                        if (($tp->getGtin() || $tp->getMpn()) && ($currency == 'CHF' || $tp->getPriceEuro())) {
                            $exportProducts[] = [
                                'product' => $tp,
                                'option' => [
                                    'isOption' => true,
                                    'addId' => $op->getUid(),
                                ],
                            ];
                        } else {
                            $productsMissing[] = $tp->getName() . '(' . $op->getUid() . ')';
                        }
                    }
                }
            }

            if (!$p->getOptionsWithPrice() || !$hasValidOption) {
                ++$countTotal;
                if (($p->getGtin() || $p->getMpn()) && ($currency == 'CHF' || $p->getPriceEuro())) {
                    //echo('PROD: ' . $p->getName() .'('.$p->getGtin().','.$p->getMpn().')<br />');
                    $exportProducts[] = [
                        'product' => $p,
                        'option' => [
                            'isOption' => false,
                            //							 'addId' => null
                        ],
                    ];
                } else {
                    $productsMissing[] = $p->getName() . '(' . $p->getUid() . ')';
                }
            }
        }

        if (isset($_GET['debug'])) {
            echo 'Total Produkte und Optionen: ' . $countTotal . "<br />\n";
            echo 'Exportierte Produkte und Optionen: ' . count($exportProducts) . "<br />\n";
            echo "<br /><b>Fehlende Produkte:</b><br />\n";
            echo implode("<br />\n", $productsMissing);
            exit(0);
        }

        $this->view->assign('shop', $this->shop);
        $this->view->assign('products', $exportProducts);
        $this->view->assign('currency', $currency);

        // wird wohl nicht mehr verwendet
        $site = $GLOBALS['TYPO3_REQUEST']->getAttribute('site');
        $base = $site->getAttribute('base');
        //$this->view->assign('baseUrl', 'http://' . $_SERVER['HTTP_HOST']);
        $this->view->assign('baseUrl', $base);

        $now = gmdate('D, d M Y H:i:s');
        $xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" . trim($this->view->render());
        $response = $this->responseFactory
                  ->createResponse()
                  ->withHeader('Content-Type', 'text/xml')
                  ->withHeader('Expires', $now . ' GMT')
                  ->withHeader('Cache-Control', 'max-age=0, no-cache, must-revalidate, proxy-revalidate')
                  ->withHeader('Last-Modified', $now . ' GMT')
                  ->withBody($this->streamFactory->createStream($xml));

        throw new PropagateResponseException($response, 200);
        /*
          $this->xml_send_headers();
          echo($xml);
          exit(0);

          return $this->htmlResponse();
        */
        return $this->htmlResponse();
    }

    /*
      private function xml_send_headers(): void
      {
      // disable caching
      $now = gmdate('D, d M Y H:i:s');
      header('Expires: '.$now.' GMT');
      header('Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate');
      header('Last-Modified: '.$now.' GMT');

      // force download
      header('Content-Type: text/xml');
      }
    */
    public function searchResultsAction(): ResponseInterface
    {
        $arguments = $this->request->getArguments();

        $products = $this->productRepository->findProducts($arguments['searchString']);
        $this->view->assign('products', $products);

        $this->view->assign('currencies', $this->shop->getCurrenciesAssociative());
        $this->view->assign('currency', $this->currencyRepository->getCurrency());

        return $this->htmlResponse();
    }

    public function searchBoxAction(string $name = ''): ResponseInterface
    {
        $search = $this->getSearch();
        $this->view->assign('search', $search);

        $this->view->assign('searchString', $search['keyword']);

        return $this->htmlResponse();
    }

    public function ajaxGetProductPriceAction(): ResponseInterface
    {
        $arguments = $this->request->getArguments();

        $product = $this->productRepository->findbyUid($arguments['productid']);
        $price = $product->getFinalPrice($this->cartUtility->cart->getCurrency());
        echo $this->renderFluid('Currency/PriceController.html', [
            'price' => $price * $arguments['amount'],
            'currency' => $this->currencyRepository->getCurrency(),
        ]);
        exit;

        return $this->htmlResponse();
    }

    /**
     * older ajax - with html result, including indexed_search (10 results), categories (4), products (4)
     */
    public function ajaxSearchAction(string $searchword): ResponseInterface
    {
        $currency = $this->cartUtility->cart->getCurrency();
        $products = $this->productRepository->findAll(null, null, 'sorting', 'asc', [], null, $searchword, 4);

        $categories = $this->categoryRepository->findBySearch($searchword, 4);

        if (ExtensionManagementUtility::isLoaded('indexed_search_autocomplete')) {
            $searchService = GeneralUtility::makeInstance(SearchService::class);
            $result = $searchService->searchAWord($searchword, 10);
            $this->view->assign('autocompleteResults', $result['autocompleteResults']);
        }

        $this->view->assign('products', $products);
        $this->view->assign('categories', $categories);
        $this->view->assign('searchword', $searchword);

        $response = new HtmlResponse($this->view->render());
        throw new PropagateResponseException($response, 200);
    }

    public function htmlTitleAction(): ResponseInterface
    {
        $feShopGet = GeneralUtility::_GP('tx_igshop2_feshop');

        if (is_array($feShopGet) && isset($feShopGet['product'])) {
            $productUid = $feShopGet['product'];
        }

        if ($productUid) {
            $product = $this->productRepository->findByUid($productUid);
            $title = $product->getName();

            if ($product->getCategoryTopLevel()) {
                $title .= ' - ' . $product->getCategoryTopLevel()->getName();
            }

            if ($this->settings['titleSuffix']) {
                $title .= ' - ' . $this->settings['titleSuffix'];
            }

            return $this->htmlResponse('<title>' . $title . '</title>');
        }

        return $this->htmlResponse('');
    }

    public function sliderAction(): ResponseInterface
    {
        // Set sorting (userSorting or productSorting)
        $sortSettings = $this->getSettingsSorting();

        [$sorting, $sortWay] = explode('.', $sortSettings);

        $this->view->assign('sorting', $sorting);
        $this->view->assign('sortWay', $sortWay);

        // Get and Set Currency
        $currency = $this->cartUtility->cart->getCurrency();

        if ($this->currencyRepository->getSessionCurrency() == false) {
            if (is_object($currency)) {
                $this->currencyRepository->setSessionCurrency($currency->getUid());
            }
        }

        $limit = intval($this->settings['flexform']['maxProducts']);
        if ($limit < 0) {
            $limit = 12;
        }

        // Get Products - filtered by settings
        $products = null;
        $flexGroups = null;
        if ($this->settings['flexform']['showOnlyActionPrices']) {
            $products = $this->productRepository->getProductsWithActionPrice($sorting, $sortWay);
        } else {
            $flexGroups = $this->settings['flexform']['group'];
            $statusses = array_filter(GeneralUtility::trimExplode(',', $this->settings['flexform']['status']));

            $this->view->assign('categoryObj', $this->categoryRepository->findByUid($flexGroups));
            // limit = 0, wegen page browser
            $products = $this->productRepository->findAll(
                $flexGroups,
                null,
                $sorting,
                $sortWay,
                [],
                $currency,
                null,
                0,
                $statusses
            );
        }

        $this->view->assign('products', $products);

        // Assign Settings - abwärtskompatibilität

        $this->view->assign('slider', [
            'slidesToShow' => $this->settings['flexform']['slidesToShow'] ?: 4,
            'speed' => $this->settings['flexform']['speed'] ?: 1000,
            'autoplaySpeed' => $this->settings['flexform']['autoplaySpeed'] ?: 1000,
            'settingsName' => $this->settings['flexform']['settingsName'] ?: 'homeSlider',
            'class' => $this->settings['flexform']['sliderClass'],
            'classname' => $this->settings['flexform']['sliderClassname'] ?: 'top-seller-product-slider',
        ]);


        // Andere Page ID fuer Details
        $detailPageId = $this->settings['flexform']['detailPage'];
        $this->view->assign('singlePage', $this->settings['flexform']['detailPage']);
        if ($detailPageId > 0) {
            $this->view->assign('detailPage', $detailPageId);
        }

        //$this->view->assign('detailPage',2122);

        $this->view->assign('productCount', count($products));

        //$this->includeJS($this->jsRootPath.'Products/igShop_Products.js');
        return $this->htmlResponse();
    }

    protected function initializeAction(): void
    {
        if ($this->settings['shopUid']) {
            $this->shop = $this->shopRepository->findByUid($this->settings['shopUid']);
        }
    }

    protected function getSettingsElementsInRow(): int
    {
        $productsInRows = (int) ($this->settings['flexform']['elementsInRow'] ?? $this->defaultElementsInRow);
        return $productsInRows < 1 ? $this->defaultElementsInRow : $productsInRows;
    }

    protected function getSettingsSorting(): string
    {
        if (isset($this->settings['flexform']['userSorting']) && strlen(
            (string) $this->settings['flexform']['userSorting']
        ) > 0) {
            return $this->settings['flexform']['userSorting'];
        }

        return $this->settings['productSorting'];
    }

    protected function assignFilter($search, $currency)
    {
        $possibleOptions = [
            'colors' => [],
            'sizes' => [],
            'minPrice' => null,
            'maxPrice' => null,
        ];

        if (isset($search['keyword']) && $search['keyword']) {
            $possibleProducts = $this->productRepository->findProducts($search['keyword']);
            foreach ($possibleProducts as $product) {
                foreach ($product->getOptionsColor() as $color) {
                    if (!in_array($color, $possibleOptions['colors'])) {
                        $possibleOptions['colors'][] = $color;
                    }
                }

                foreach ($product->getOptionsSize() as $size) {
                    if (!in_array($size, $possibleOptions['sizes'])) {
                        $possibleOptions['sizes'][] = $size;
                    }
                }

                if ($this->cartUtility->cart->getCurrency()->getShort() == 'EUR') {
                    if ($product->getEuroPrice() < $possibleOptions['minPrice'] || $possibleOptions['minPrice'] === null) {
                        $possibleOptions['minPrice'] = $product->getPriceEuro();
                    }

                    if ($product->getEuroPrice() > $possibleOptions['maxPrice'] || $possibleOptions['maxPrice'] === null) {
                        $possibleOptions['maxPrice'] = $product->getPriceEuro();
                    }
                } else {
                    if ($product->getPrice() < $possibleOptions['minPrice'] || $possibleOptions['minPrice'] === null) {
                        $possibleOptions['minPrice'] = $product->getPrice();
                    }

                    if ($product->getPrice() > $possibleOptions['maxPrice'] || $possibleOptions['maxPrice'] === null) {
                        $possibleOptions['maxPrice'] = $product->getPrice();
                    }
                }
            }

            // @todo remove
            $this->view->assign('searchString', $search['keyword']);
        }




        // Filter Settings
        $filterEnable = ($this->settings['flexform']['filterColor'] ?? false) || ($this->settings['flexform']['filterSize'] ?? false) || ($this->settings['flexform']['filterPrice'] ?? false) || ($this->settings['flexform']['filterProductClass'] ?? false);
        $this->view->assign('filterMode', $filterEnable);
        if ($filterEnable) {
            // Settings / Search for Color
            if ($this->settings['flexform']['filterColor'] ?? false) {
                $this->view->assign('colors', [
                    'all' => ((isset($search['keyword']) && $search['keyword']) ? $possibleOptions['color'] : $this->optionColorRepository->findAll()),
                    'selected' => $search['color'] ?? null,
                ]);
            }

            // Settings / Search for Size
            if ($this->settings['flexform']['filterSize'] ?? false) {
                $this->view->assign('sizes', [
                    'all' => ((isset($search['keyword']) && $search['keyword']) ? $possibleOptions['size'] : $this->optionSizeRepository->findAll()),
                    'selected' => $search['size'] ?? null,
                ]);
            }

            // Settings / Search for Price
            if ($this->settings['flexform']['filterPrice'] ?? false) {
                $flexGroups = $this->settings['flexform']['group'];
                $catNavUids = $search['category'] ?? '';
                $minPrice = (isset($search['keyword']) && $search['keyword']) ? $possibleOptions['minPrice'] : $this->productRepository->getMinPrice(
                    $flexGroups,
                    $catNavUids,
                    $currency
                );
                $maxPrice = (isset($search['keyword']) && $search['keyword']) ? $possibleOptions['maxPrice'] : $this->productRepository->getMaxPrice(
                    $this->cartUtility->cart->getCurrency()
                );
                $prices = [
                    'all' => [
                        'minPrice' => floor($minPrice),
                        'maxPrice' => ceil($maxPrice),
                    ],
                    'selected' => [
                        'minPrice' => floor(
                            (isset($search['minPrice']) && $search['minPrice']) ? $search['minPrice'] : $minPrice
                        ),
                        'maxPrice' => ceil(
                            (isset($search['maxPrice']) && $search['maxPrice']) ? $search['maxPrice'] : $maxPrice
                        ),
                    ],
                ];
                $this->view->assign('prices', $prices);
            }

            if ($this->settings['flexform']['filterCategory'] ?? false) {
                $all = $this->categoryRepository->findAllWithProducts($search['mandant'] ?? null);
                $tree = $this->categoryRepository->buildTreeAddParents($all->toArray());
                $this->view->assign('categories', [
                    'all' => $all,
                    'main' => $tree,
                    'selected' => $search['category'] ?? $search['categories'] ?? null,
                ]);
            }

            if ($this->settings['flexform']['filterProductClass'] ?? false) {
                $this->view->assign('productClasses', [
                    'all' => $this->productClassRepository->findAll(),
                    'selected' => $search['productClass'],
                ]);
            }

            $this->includeJS($this->jsRootPath . 'Products/igShop_Products_filterForm.js');
            //$this->addJavaScriptFilter($prices,$currency);
            $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
            $pageRenderer->addCssFile('EXT:igshop2/Resources/Public/Css/Products/igShop_ProductFilter.scss');
        } elseif (($this->settings['flexform']['filterCategory'] ?? false) && !$this->settings['flexform']['categoryFilterMainCategories']) {
            $all = $this->categoryRepository->findAllWithProducts($search['mandant'] ?? null);
            $tree = $this->categoryRepository->buildTreeAddParents($all->toArray());
            $this->view->assign('categories', [
                'all' => $all,
                'main' => $tree,
                'selected' => $search['category'] ?? null,
            ]);
            $this->view->assign('filterMode', true);
        } elseif (($this->settings['flexform']['filterCategory'] ?? false) && $this->settings['flexform']['categoryFilterMainCategories'] ?? false) {
            $mainCategoryUids = GeneralUtility::trimExplode(
                ',',
                $this->settings['flexform']['categoryFilterMainCategories']
            );
            $categories = [];

            foreach ($mainCategoryUids as $mainCategoryUid) {
                $mainCategory = $this->categoryRepository->findByUid($mainCategoryUid);
                $subcategories = $this->categoryRepository->findByParent($mainCategory);
                $categories[$mainCategoryUid] = [
                    'main' => $mainCategory,
                    'all' => $subcategories,
                    'selected' => $search['categories'][$mainCategoryUid] ?? null,
                ];
            }

            $this->view->assign('filterMode', true);
            $this->view->assign('categories', $categories);
        }
    }


    private function truncate(string $string, int $length = 100, string $append = '&hellip;'): string
    {
        $string = trim($string);

        if (strlen($string) > $length) {
            $string = wordwrap($string, $length);
            $string = explode("\n", $string, 2);
            $string = $string[0] . $append;
        }

        return $string;
    }

    private function renderFluid(string $template, array $parameter = []): string
    {
        $fluidView = GeneralUtility::makeInstance(StandaloneView::class);
        $fluidView->getRequest()
                  ->setControllerExtensionName('igshop2');
        $conf = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK
        );
        $templateRootPath = GeneralUtility::getFileAbsFileName(
            $conf['view']['templateRootPath']
        );
        $templateFile = $templateRootPath . $template;
        $fluidView->setTemplatePathAndFilename($templateFile);
        $fluidView->setPartialRootPath($conf['view']['partialRootPath']);
        if (!empty($parameter)) {
            $fluidView->assignMultiple($parameter);
        }

        return $fluidView->render();
    }

    /*
    // user for jQuery ui-Slice
    protected function addJavaScriptFilter($prices, $currency)
    {

    // Boolean if symbol is befor or after price
    $js = 'var afterPrice = ' . ($currency->getAfterPrice() ? 'true' : 'false') . ';';
    // Selected Prices
    if (!empty($prices)) {
    $allMinPrice = (int)$prices['all']['minPrice'];
    $allMaxPrice = (int)$prices['all']['maxPrice'];
    $selectedMinPrice = (int)$prices['selected']['minPrice'];
    $selectedMaxPrice = (int)$prices['selected']['maxPrice'];
    $js .= 'var selectedMinPrice = ' . ($selectedMinPrice > 0 ?$selectedMinPrice : $allMinPrice) .';';
    $js .= 'var selectedMaxPrice = ' . ($selectedMaxPrice > 0 ?$selectedMaxPrice : $allMaxPrice) .';';
    // Price Range
    $js .= 'var minPrice = ' . $allMinPrice . ';';
    $js .= 'var maxPrice = ' . $allMaxPrice . ';';
    }
    $js .= 'var currencySymbol = "' . $currency->getSymbol() .'";';

    $this->assetCollector->addInlineJavaScript('ig-shop-product-filter', $js);
    }
    */
}
