<?php
namespace InternetGalerie\Igshop2\Database\Query;

use InternetGalerie\Igshop2\Domain\Model\Currency;
use InternetGalerie\Igshop2\Utility\RankingUtility;
use PDO;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\Query\QueryBuilder;
use TYPO3\CMS\Core\Database\Query\Expression\CompositeExpression;
use TYPO3\CMS\Core\Utility\GeneralUtility;

use TYPO3\CMS\Core\Resource\FileReference;
use TYPO3\CMS\Core\Resource\ResourceFactory;


class ProductQueryBuilder extends QueryBuilder
{
    public static $tablename = 'tx_igshop2_domain_model_product';
    public static $categoryTablename = 'tx_igshop2_domain_model_category';
    protected $sqlSelect = '*';
    protected $categoryJoined = false;


    public static function create()
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(static::$tablename);
        return GeneralUtility::makeInstance(ProductQueryBuilder::class, $conn);
    }
    
    public function addUserRestriction()
    {
        $constraints = [];
    }

        public function resetSelect()
    {
        $this->sqlSelect = '*';
        return $this;
    }
    public function joinCategory()
    {
        if (!$this->categoryJoined) {
            $this->leftJoin(
                static::$tablename,
                'tx_igshop2_product_category_mm',
                'product_category_mm',
                $this->expr()->and(
                    $this->expr()->eq('uid_foreign', $this->createNamedParameter($category[0], PDO::PARAM_INT)),
                    $this->expr()->or(
                        $this->expr()->and(
                            $this->expr()->eq('product_category_mm.uid_local', $this->quoteIdentifier(static::$tablename . '.uid')),
                            $this->expr()->eq(static::$tablename . '.l10n_parent', $this->createNamedParameter(0, PDO::PARAM_INT))
                        ),
                        $this->expr()->and(
                            $this->expr()->eq('product_category_mm.uid_local', $this->quoteIdentifier(static::$tablename . '.l10n_parent')),
                            $this->expr()->gt(static::$tablename . '.l10n_parent', $this->createNamedParameter(0, PDO::PARAM_INT))
                        )
                    ),
                    $this->expr()->in(
                        static::$tablename . '.sys_language_uid',
                        [
                            $this->createNamedParameter(-1, PDO::PARAM_INT),
                            $this->createNamedParameter(
                                GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect('language', 'id'),
                                PDO::PARAM_INT
                            ),
                        ]
                    )
                )
            );
            $this->leftJoin(
                'product_category_mm',
                static::$categoryTablename,
                static::$categoryTablename,
                $this->expr()->and(
                    $this->expr()->eq('uid_local', static::$categoryTablename . '.uid'),
                    $this->expr()->in(
                        static::$tablename . '.sys_language_uid',
                        [
                            $this->createNamedParameter(-1, PDO::PARAM_INT),
                            $this->createNamedParameter(
                                GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect('language', 'id'),
                                PDO::PARAM_INT
                            ),
                        ]
                    )
                )
            );
                
            $this->categoryJoined = true;
        }
    }

    public function addSearch(array $search, Currency $currency)
    {
        $constraints = [];
        if (isset($search['uid']) && $search['uid'] !== '') {
            $constraints[] = $this->expr()->eq(static::$tablename . '.uid', (int)$search['uid']);
        }

        // Search for Colors
        if (key_exists('colors', $search) && is_array($search['colors'])) {
            $colorConstraint = [];
            foreach ($search['colors'] as $color) {
                $colorConstraint[] = $this->expr()->in('options_color', $color);//@todo
            }

            $constraints[] = $this->expr()->orX(...$colorConstraint);
        }

        // Search for Sizes
        if (key_exists('sizes', $search) && is_array($search['sizes'])) {
            $sizeConstraint = [];
            foreach ($search['sizes'] as $size) {
                $sizeConstraint[] = $this->expr()->in('optionsSize', $size); //@todo
            }
            $constraints[] = $this->expr()->orX(...$sizeConstraint);
        }


        // Search for Product Classes
        if (key_exists('productClasses', $search) && is_array($search['productClasses'])) {
            $constraints[] = $this->expr()->in('productClass', $search['productClasses']); //@todo
        }

        // Select only Products where Price is not null
        $constraints[] = $this->expr()->isNotNull('price');


        $minPrice = null;
        $maxPrice = null;
        if (key_exists('priceRange', $search)) {
            $minPrice = isset($search['priceRange']['from']) ? (float) $search['priceRange']['from'] : null;
            $maxPrice = isset($search['priceRange']['to']) ? (float) $search['priceRange']['to'] : null;
        } else {
            if (key_exists('minPrice', $search) && $search['minPrice'] > 0) {
                $minPrice = (float)$search['minPrice'];
            }

            if (key_exists('maxPrice', $search) && $search['minPrice'] < $search['maxPrice']) {
                $maxPrice = (float)$search['maxPrice'];
            }
        }


        $priceAttribute = is_object($currency) && $currency->getShort() == 'EUR' ? 'price_euro' : 'price';
        
        // Search for Prices - minPrice
        if ($minPrice !== null && $minPrice > 0) {
            $constraints[] = $this->expr()->gte($priceAttribute, $minPrice);
        }

        // Search for Prices - maxPrice
        if ($maxPrice !== null && $minPrice < $maxPrice) {
            $constraints[] = $this->expr()->lte($priceAttribute, $maxPrice);
        }

        if (isset($search['mandant']) && $search['mandant'] > 0) {
            $constraints[] = $this->expr()->eq('mandantUid', (int) $search['mandant']);
        }

        $categoryUids = [];
        if (isset($search['categories'])) {
            if (is_array($search['categories'])) {
                $search['categories'] =  array_map('intval', array_filter($search['categories']));
            } else {
                $search['categories'] = GeneralUtility::intExplode(',', (string)$search['categories'], true);
            }
            $categoryUids = $search['categories'];
        } 

        if (isset($search['category']) && $search['category'] > 0) {
            $categoryUids[] = (int)$search['category'];
        }

        
        //@todo do we need this -> add $flexUids as parameter
        /*
        if ($flexUids) {
            $flexformCategoryUids = GeneralUtility::intExplode(',', $flexUids, true); 
            if (empty( $categoryUids)) {
                $categoryUids = $flexformCategoryUids;
            } else {
                $categoryUids = array_values(array_intersect($categoryUids, $flexformCategoryUids));
                if (empty($categoryUids)) {
                    $categoryUids = $flexformCategoryUids;
                }
            }
        }
        */
        if (!empty($categoryUids)) {
            $categoryConstraints = [];
            foreach ($categoryUids as $$categoryUid) {
                $categoryConstraints[] = $this->expr()->eq('category', $categoryUid);
            }
            $this->joinCategory();
            $constraints[] = $this->expr()->andX(...$categoryConstraints);
        }



        $rankingCase = '';
        if ($search['keyword'] ?? $search['searchString'] ?? false) {
            $keywordWords = GeneralUtility::trimExplode(' ', $search['keyword'] ?? $search['searchString'], true);
            foreach ($keywordWords as $keyword) {
                $constraints[] = $this->expr()->orX(
                    $this->expr()->like(static::$tablename . '.name', $this->createNamedParameter('%' . $keyword . '%')),
                    $this->expr()->like('productid', $this->createNamedParameter('%' . $keyword . '%')),
                    $this->expr()->like('pharmacode', $this->createNamedParameter('%' . $keyword . '%')),
                    $this->expr()->like(static::$tablename . '.description', $this->createNamedParameter('%' . $keyword . '%')),
                    $this->expr()->like('search_string', $this->createNamedParameter('%' . $keyword . '%'))
                );
                if (strlen($keyword) >= 3) {
                    $rankingCase .= ($rankingCase ? ' + ' : '') . RankingUtility::getRankingCase(
                        'tx_igshop2_domain_model_product',
                        'name',
                        $keyword
                    );
                }
                
            }
        }
        if (1) {//count($categoryUids) == 1 && $sorting == 'sorting' && !$disableCatSort) {
            $this->joinCategory();
            if ($rankingCase) {
                $this->add('orderBy', $rankingCase . ' DESC, '. static::$tablename . '.sorting ASC');
            } else {
                $sortWay ='asc';
                //$this->orderBy('product_category_mm.sorting', ($sortWay == 'asc' ? 'ASC' : 'DESC'));
                $this->orderBy('product_category_mm.sorting_foreign', ($sortWay == 'asc' ? 'ASC' : 'DESC'));
                $this->addOrderBy(
                    static::$tablename . '.sorting',
                    ($sortWay == 'asc' ? 'ASC' : 'DESC')
                );
            }
        }



        if ($search['state'] ?? false) {
            $constraints[] = $this->expr()->in('state', $state);
        }


        //$this->addSearchOrderBy($search);

        if (!empty($constraints)) {
            $this->andWhere(...$constraints);
        }
        return $this;
    }
   public function addArrayOrderBy(array $orderBys)
   {
       foreach ($orderBys as $attribute => $order) {
               $this->addOrderBy($attribute, $order);
       }
       return $this;
   }
    
    
}


