<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Cart extends AbstractOrder
{
    protected string $productClass= CartProduct::class;

    /**
     * products
     *
     * @var ObjectStorage<CartProduct>
     * @Cascade
     */
    protected $products = null;

    /**
     * Returns the products
     *
     * @return ObjectStorage<CartProduct> $products
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * Adds a OrderProduct
     * 
     * @param CartProduct $product
     */
    public function addProduct($product): void
    {
        $this->products->attach($product);
        $this->mustCalculateTotal = true;
    }

    /**
     * Removes a CartProduct
     *
     * @param CartProduct $productToRemove The CartProduct to be removed
     */
    public function removeProduct($productToRemove): void
    {
        $this->products->detach($productToRemove);
        $this->mustCalculateTotal = true;
    }

    //public function calcTotalWithPorto(){
    public function calculateTotalWithPorto(): void
    {
        $shipping = $this->getShippingCosts();
        if($shipping && $shipping->getPrice() > 0) {
            $this->totalWithPorto = $this->getTotal() + $shipping->getPrice();
        } elseif ($this->getPorto() != null && !$this->hasProductWithoutPorto()) {
            $this->totalWithPorto = $this->getTotal() + $this->getPorto()
            ->getCurrentPrice($this->getTotalProductsPrice(), $this->getTotalProductsCount());
        } else {
            $this->totalWithPorto = $this->getTotal();
        }
    }
}