<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
/**
 * The repository for Countries
 */
class CountryRepository extends Repository
{
    /*protected $defaultOrderings = array(
        'sorting' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING
    );*/

    public function initializeObject(): void
    {
        $querySettings = $this->createQuery()
->getQuerySettings();
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * @param string $defaultCountry - ISO Country Code 2 stellig - falls Land nicht gefunden wird
     */
    public function getCountryFromRemoteAddr($remote_addr, $defaultCountry = 'CH')
    {
        $short = 'de';//geoip_country_code_by_name($_SERVER['REMOTE_ADDR']);

        // false macht Probleme
        if ($short === false || $short == null) {
            $short = $defaultCountry;
        }

        $query = $this->createQuery();
        if ($this->countByShort($short)) {
            $query->matching($query->logicalAnd($query->equals('short', $short, false)));
        } elseif ($this->countByShort($defaultCountry)) {
            $query->matching($query->logicalAnd($query->equals('short', $defaultCountry, false)));
        }

        return $query->execute()
->getFirst();
    }
}
