<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use InternetGalerie\Igshop2\Domain\Model\Country;
use InternetGalerie\Igshop2\Domain\Model\Porto;
/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2014
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * The repository for Portos
 */
class PortoRepository extends Repository
{
    protected $defaultOrderings = [
        'price' => QueryInterface::ORDER_ASCENDING,
    ];

    /**
     * Return Alle Portos fuer dieses Land - oder null
     * @param Country $country
     * @return Porto
     **/
    public function getAllForCountry($country)
    {
        if (!is_object($country)) {
            return null;
        }

        $query = $this->createQuery();
        //	    echo('='.$country->get_languageUid().'=='.$country->get_localizedUid().'<br />');
        // @TODO something is completely broken DA [multilanguage sites]
        $query->getQuerySettings()
->setRespectSysLanguage(false);
        //$query->getQuerySettings()->setSysLanguageUid(2);
        $query->matching(
            $query->logicalOr($query->contains('country', $country), $query->equals('countryAll', true))
        );
        //,                $query->equals("sys_language_uid",$country->get_languageUid())

        return $query->execute();
    }

    /**
     * Return the default (billigste) Porto fuer Land
     * @param Country $country
     * @return Porto
     **/
    public function getDefaultPortoForCountry($country)
    {
        $portoRes = $this->getAllForCountry($country);
        if (count($portoRes) >= 1) {
            return $portoRes->getFirst();
        }

        return null;
    }
}
