<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Ajax;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\ExtbaseRequestParameters;
use TYPO3\CMS\Extbase\Mvc\Request;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;
use TYPO3\CMS\Fluid\Core\Rendering\RenderingContext;

/*
                      <shop:link.smallCart>Warenkorb</shop:link.smallCart>
                      <shop:ajax.div action="cart">
                        <shop:ajax.field name="cart" class="dropdown_content header_popup_products" />
                      </shop:ajax.div>
                      <div class="shop_header">
                        <shop:link.cart><img src="/fileadmin/layout/images_layout/bag.svg" width="20" /></shop:link.cart> (<shop:ajax.field name="count">0</shop:ajax.field>
                      </div>
<shop:ajax.field name="totalCurrency">CHF 0</shop:ajax.field><shop:ajax.field name="currency" /><shop:ajax.field name="total" />
<shop:ajax.field name="productsCount" />
*/

class DivViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * @var ConfigurationManagerInterface
     */
    protected $configurationManager;

    /**
     * @var UriBuilder
     */
    protected $uriBuilder;

    protected $settings = null;


    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager): void
    {
        $this->configurationManager = $configurationManager;
    }



    public function injectUriBuilder(UriBuilder $uriBuilder): void
    {
        $this->uriBuilder = $uriBuilder;
    }


    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('action', 'string', 'Ajax Action', true);
        $this->registerArgument('breakpoint', 'int', 'breakpoint for mobile version (direct cart link)', false, 650);
        //$this->registerArgument('cartPageUid' 'int', 'Page Uid of Cart', true); // muss dies in Settings
        // $this->registerArgument('smallCartPageUid' 'int', 'Page Uid of Small Cart Ajax Page', true); // muss dies in Settings
    }

    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render(): string
    {
        $this->settings = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            'Igshop2',
            ''
        );

        /** @var RenderingContext $renderingContext */
        $renderingContext = $this->renderingContext;

        $request = $renderingContext->getRequest();
        $extbaseRequest = new Request($request->withAttribute('extbase', new ExtbaseRequestParameters()));
        $cartPid = intval($this->settings['cartPid'] ?? 0);
        $cartUriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        $cartUriBuilder
            ->reset()
            ->setRequest($extbaseRequest)
            ->setTargetPageUid($cartPid)
            ->setNoCache(1)
            ->setTargetPageType(2000);
        $cartUrl = $cartUriBuilder->build();//uriFor($action, '' );

        $smallCartPid = intval($this->settings['smallCartPid'] ?? 0);
        $smallCartUriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        $smallCartUriBuilder
            ->reset()
            ->setRequest($extbaseRequest)
            ->setTargetPageUid($smallCartPid)
            ->setNoCache(1)
            ->setTargetPageType(1000);
        $smallCartUrl = $smallCartUriBuilder->build();

        $output = $this->renderChildren();
        return '<div class="igshop-container tx-igshop2-smallFeCart igshop-ajax-action-' . $this->arguments['action'] . '" data-cart-url="' . htmlspecialchars(
            $cartUrl
        ) . '" data-small-cart-url="' . htmlspecialchars(
            $smallCartUrl
        ) . '" data-breakpoint="' . $this->arguments['breakpoint'] . '">' . $output . '</div>';
    }
}
