<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Form;

use TYPO3\CMS\Fluid\ViewHelpers\Form\AbstractFormFieldViewHelper;
class QuantityInputViewHelper extends AbstractFormFieldViewHelper
{
    /**
     * @var string
     */
    protected $tagName = 'input';

    /**
     * Initialize the arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('min', 'integer', 'Minimum amount', false, 1);
        $this->registerArgument('max', 'integer', 'Maximum amount', false, 9999999999999);
        $this->overrideArgument('name', 'string', 'Name of input tag', false, 'options[amount]');

        $this->registerUniversalTagAttributes();
    }

    /**
     * Renders the textfield.
     *
     * @return string
     */
    public function render()
    {
        $class = 'amountInput';
        if ($this->tag->hasAttribute('class')) {
            $this->tag->addAttribute('class', $class . ' ' . $this->tag->getAttribute('class'));
            $this->arguments['class'] = $class . ' ' . $this->tag->getAttribute('class');
        } else {
            $this->tag->addAttribute('class', $class);
            $this->arguments['class'] = $class;
        }

        $name = $this->getName();
        $this->registerFieldNameForFormTokenGeneration($name);
        $this->setRespectSubmittedDataValue(true);

        $this->tag->addAttribute('type', 'text');
        $this->tag->addAttribute('name', $name);

        $value = $this->getValueAttribute();

        if ($this->arguments['min']) {
            $this->tag->addAttribute('data-min-amount', $this->arguments['min']);
        }

        if ($this->arguments['max']) {
            $this->tag->addAttribute('data-max-amount', $this->arguments['max']);
        }

        if ($value !== null) {
            $this->tag->addAttribute('value', $value);
        } else {
            $this->tag->addAttribute('value', 1);
        }

        $this->addAdditionalIdentityPropertiesIfNeeded();
        $this->setErrorClassAttribute();

        return '<div class="amountInputWrap"><div class="amountInputMinus"></div>' . parent::render() . '<div class="amountInputPlus"></div></div>';
    }
}
