<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;
/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class IfProductIsAvailableViewHelper extends AbstractConditionViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this -> registerArgument('currency', 'object', 'Currency', true);
        $this -> registerArgument('product', 'mixed', 'Product', false);
        $this -> registerArgument('productOption', 'mixed', 'Product Option', false);
    }
    
    /**
       is product available in this currency
       TODO veralgemeinern
     */
    public function render(): string
    {
        $currency = $this->arguments['currency'];
        $product = $this->arguments['product'];
        $optionWithPrice = $this->arguments['productOption'];


        if (is_object($optionWithPrice)) {
            $p = $optionWithPrice;
        } else {
            $p = $product;
        }
        
        if ($currency->getShort() == 'EUR' && $p->getPriceEuro() !== null && $p->getPriceEuro() <= 0) {
            return $this->renderElseChild();
        }
        
        return $this->renderThenChild();
    }
}
