<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use InternetGalerie\Igshop2\Domain\Model\OrderProduct;
use InternetGalerie\Igshop2\Domain\Model\Currency;
/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class IsOnlySwissViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        
        $this->registerArgument(
            'orderProduct',
            OrderProduct::class,
            'Order product',
            true
        );
        $this->registerArgument('currency', Currency::class, 'Currency', true);
    }

    /**
     * Rounds the price to CHF norm
     *
     * @return boolean
     */
    public function render(): string
    {
        $orderProduct = $this->arguments['orderProduct'];
        $currency = $this->arguments['currency'];

        if ($currency->getShort() != 'EUR') {
            return false;
        }

        if ($orderProduct->getProduct()->isOnlySwiss()) {
            return true;
        }

        $prodOptions = unserialize($orderProduct->getProdOptions());
        $option = $prodOptions['optionWithPrice'];
        foreach ($orderProduct->getProduct()->getOptionsWithPrice() as $size) {
            if ($size->getUid() == $option) {
                if ($size->isOnlySwiss()) {
                    return true;
                }
            }
        }

        return false;
    }
}
