<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Link;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use InternetGalerie\Igshop2\Domain\Model\Product;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\ExtbaseRequestParameters;
use TYPO3\CMS\Extbase\Mvc\Request;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;
use TYPO3\CMS\Fluid\Core\Rendering\RenderingContext;

/*
                      <shop:link.smallCart>Warenkorb</shop:link.smallCart>
                      <shop:ajax.div action="cart">
                        <shop:ajax.field name="cart" class="dropdown_content header_popup_products" />
                      </shop:ajax.div>
                      <div class="shop_header">
                        <shop:link.cart><img src="/fileadmin/layout/images_layout/bag.svg" width="20" /></shop:link.cart> (<shop:ajax.field name="count">0</shop:ajax.field>
                      </div>
<shop:ajax.field name="totalCurrency">CHF 0</shop:ajax.field><shop:ajax.field name="currency" /><shop:ajax.field name="total" />
<shop:ajax.field name="productsCount" />
*/

class CompareDeleteViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * @var ConfigurationManagerInterface
     */
    protected $configurationManager;

    /**
     * @var UriBuilder
     */
    protected $uriBuilder;

    protected $settings = null;


    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager): void
    {
        $this->configurationManager = $configurationManager;
    }



    public function injectUriBuilder(UriBuilder $uriBuilder): void
    {
        $this->uriBuilder = $uriBuilder;
    }


    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('compare', 'string', 'Vergleich', false);
        $this->registerArgument('product', Product::class, 'Produkt', false);
        // $this->registerArgument('smallCartPageUid' 'int', 'Page Uid of Small Cart Ajax Page', true); // muss dies in Settings
    }

    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render(): string
    {
        $compare = $this->arguments['compare'];
        $product = $this->arguments['product'];
        $productUids = array_filter(GeneralUtility::trimExplode(',', $compare));
        $newCompare = '';

        foreach ($productUids as $productUid) {
            if ($productUid != $product->getUid()) {
                if ($newCompare != '') {
                    $newCompare .= ',';
                }

                $newCompare .= $productUid;
            }
        }

        $compare = $newCompare;

        $this->settings = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            'Igshop2',
            ''
        );

        /** @var RenderingContext $renderingContext */
        $renderingContext = $this->renderingContext;

        $request = $renderingContext->getRequest();
        $extbaseRequest = new Request($request->withAttribute('extbase', new ExtbaseRequestParameters()));
        $productComparisonPid = intval($this->settings['productComparison']['pageUid'] ?? 0);

        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);

        $productComparisonUrl = $uriBuilder
            ->reset()
            ->setRequest($extbaseRequest)
            ->setTargetPageUid($productComparisonPid)
            ->build();

        $returnUrl = $uriBuilder->getRequest()
->getRequestTarget();
        $productComparisonUrl .= '?tx_igshop2_productcomparison[returnUrl]=' . $returnUrl;

        $output = $this->renderChildren();
        return '<a class="product-delete-link" href="' . $productComparisonUrl . '&tx_igshop2_productcomparison[compare]=' . $compare . '">' . $output . '</a>';
    }
}
