<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Link;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
class SmallCartViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;


    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('class', 'string', 'Extra Klassen', false, '');
        //$this->registerArgument('container', 'string', 'container selector', false, '.igshop-container');
        //$this->registerArgument('cartPageUid' 'int', 'Page Uid of Cart', true); // muss dies in Settings
        // $this->registerArgument('smallCartPageUid' 'int', 'Page Uid of Small Cart Ajax Page', true); // muss dies in Settings
    }

    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render(): string
    {
        $output = $this->renderChildren();
        $class = $this->arguments['class'];
        return '<div class="igshop-link-small-cart' . ($class ? ' ' . $class : ' dropdown_header') . '">' . $output . '</div>';
        //  data-container="' . $this->arguments['container'] . '"
    }
}
