<?php

namespace InternetGalerie\igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use InternetGalerie\Igshop2\Domain\Model\Order;
use InternetGalerie\Igshop2\Domain\Repository\PortoRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class PortoViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        
        $this->registerArgument('order', Order::class, 'Order', true);
    }

    /**
     * Rounds the price to CHF norm
     */
    public function render(): string
    {
        $order = $this->arguments['order'];
        $amount = 0;
        
        foreach ($order->getProducts() as $product) {
            $amount += $product->getAmount();
        }
        
        $orderInfo = unserialize($order->getOrderInfo());
        $country = $orderInfo['country'];
        
        $serviceObject = GeneralUtility::makeInstance(PortoRepository::class);
        return $serviceObject->getPorto($country, $order->getCurrency(), $amount, 'a');
    }
}
