<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use Closure;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class RelatedProductsViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    protected $escapeChildren = false;

    public function initializeArguments(): void
    {
        parent::initializeArguments();

        $this->registerArgument('product', 'mixed', 'Product', true);
        $this->registerArgument('category', 'mixed', 'Related Category', false);
        $this->registerArgument('as', 'string', 'Name of product variable', true);
    }


    public static function renderStatic(
        array $arguments,
        Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): string {
        $templateVariableContainer = $renderingContext->getVariableProvider();

        $product = $arguments['product'];
        $category = $arguments['category'];

        $productUids = [];

        $output = '';

        if ($product->getCategoryFirst()) {
            foreach ($product->getCategoryFirst()->getProducts() as $p) {
                if ($p->getUid() != $product->getUid() && !in_array($p->getUid(), $productUids)) {
                    $templateVariableContainer->add($arguments['as'], $p);
                    $output .= $renderChildrenClosure();
                    $productUids[] = $p->getUid();
                    $templateVariableContainer->remove($arguments['as']);
                }
            }
        }

        if ($product->getRelatedCategory()->count() > 0) {
            foreach ($product->getRelatedCategory() as $relatedCategory) {
                foreach ($relatedCategory->getProducts() as $p) {
                    if ($p->getUid() != $product->getUid() && !in_array($p->getUid(), $productUids)) {
                        $templateVariableContainer->add($arguments['as'], $p);
                        $output .= $renderChildrenClosure();
                        $productUids[] = $p->getUid();
                        $templateVariableContainer->remove($arguments['as']);
                    }
                }
            }
        } elseif ($category && $product->getCategoryFirst() && $category->getUid() != $product->getCategoryFirst()->getUid() && $category->getProducts()->count() > 1) {
            foreach ($category->getProducts() as $p) {
                if ($p->getUid() != $product->getUid() && !in_array($p->getUid(), $productUids)) {
                    $templateVariableContainer->add($arguments['as'], $p);
                    $output .= $renderChildrenClosure();
                    $productUids[] = $p->getUid();
                    $templateVariableContainer->remove($arguments['as']);
                }
            }
        }

        return $output;
    }
}
