<?php
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
$tmpColumns = [
    'last_used_address' => [
        'exclude' => 1,
        'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:fe_users.last_used_address',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'foreign_table' => 'tt_address',
            'foreign_table_where' => 'AND fe_user = ###THIS_UID###',
            'items' => [
                ['label' => '', 'value' => 0],
            ],
            'minitems' => 0,
            'maxitems' => 1,
        ],
    ],
    'last_used_billing_address' => [
        'exclude' => 1,
        'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:fe_users.last_used_billing_address',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'foreign_table' => 'tt_address',
            'foreign_table_where' => 'AND fe_user = ###THIS_UID###',
            'items' => [
                ['label' => '', 'value' => 0],
            ],
            'minitems' => 0,
            'maxitems' => 1,
        ],
    ],
    'addresses' => [
        'exclude' => 1,
        'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:fe_users.addresses',
        'config' => [
            'type' => 'inline',
            'foreign_table' => 'tt_address',
            'foreign_field' => 'fe_user',
            'minitems' => 0,
            'maxitems' => 9999,
        ],
    ],
    'current_order' => [
        'exclude' => 1,
        'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:fe_users.current_order',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'foreign_table' => 'tx_igshop2_domain_model_cart',
            'foreign_table_where' => 'AND userid = ###THIS_UID###',
            'items' => [
                ['label' => '', 'value' => 0],
            ],
            'minitems' => 0,
            'maxitems' => 1,
        ],
    ],
    'orders' => [
        'exclude' => 1,
        'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:fe_users.orders',
        'config' => [
            'type' => 'inline',
            'foreign_table' => 'tx_igshop2_domain_model_order',
            'foreign_field' => 'userid',
            'minitems' => 0,
            'maxitems' => 9999,
        ],
    ],

];

// Add new fields to pages:
ExtensionManagementUtility::addTCAcolumns('fe_users', $tmpColumns);

ExtensionManagementUtility::addToAllTCAtypes(
  'fe_users', // Table name
  'last_used_address,last_used_billing_address,addresses,current_order,', // Field list to add
  '', // List of specific types to add the field list to. (If empty, all type entries are affected)
  'after:www' // Insert fields before (default) or after one, or replace a field
);
