<?php
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
defined('TYPO3') or die();

(static function () {
    $tmpColumns = [
        'fe_user' => [ // TODO: Relation to fe_user
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tt_address.fe_user',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'fe_users',
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'is_billing_address' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tt_address.is_billing_address',
            'config' => [
                'type' => 'check',
            ],
        ],
        'is_private_person' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tt_address.is_private_person',
            'config' => [
                'type' => 'check',
            ],
        ],
    ];
    // Add new fields to pages:
    ExtensionManagementUtility::addTCAcolumns('tt_address', $tmpColumns);
    ExtensionManagementUtility::addToAllTCAtypes(
      'tt_address', // Table name
      'fe_user,is_billing_address', // Field list to add
      '', // List of specific types to add the field list to. (If empty, all type entries are affected)
      'before:name' // Insert fields before (default) or after one, or replace a field
    );
})();
