<?php
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
if (!defined ('TYPO3')) {
	die ('Access denied.');
}

$versionInformation = GeneralUtility::makeInstance(Typo3Version::class);
if ($versionInformation->getMajorVersion() > 11) {
	$filesConfig = [
		'type' => 'file',
		'foreign_match_fields' => [
			'tablenames' => 'tx_igshop2_domain_model_order',
		],
		'maxitems' => 9999,
		'allowed' => 'pdf',
	];
} else {
	$filesConfig = ExtensionManagementUtility::getFileFieldTCAConfig(
		'confirmation',
		[
			'appearance' => [
				'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
			],
			'foreign_match_fields' => [
				'tablenames' => 'tx_igshop2_domain_model_order',
			],
			// Alle Zeilen von V11 (foreign_types...)
			'maxitems' => 9999,
		],
		'pdf'
	);
}

$GLOBALS['TCA']['tx_igshop2_domain_model_order'] = [
    'ctrl' => [
        'title' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order',
        'label' => 'uid',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        //'hideTable' => 'true',
        'cruser_id' => 'cruser_id',

        'versioningWS' => 2,
        'versioning_followPages' => TRUE,

        //'languageField' => 'sys_language_uid',
        //'transOrigPointerField' => 'l10n_parent',
        //'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'userid,orderdate,total,customername,ordermail,orderinfo,paymentmode,payment_method,submitted,done,shipping_type,shipping_status,is_member,grant_total,plzort,strasse,paid,is_order,has_calc_address,products,porto,country,currency,delivery_period,survey,confirmation',
        //'dynamicConfigFile' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath($_EXTKEY) . 'Configuration/TCA/Order.php',
        'iconfile' => ExtensionManagementUtility::extPath('igshop2') . 'Resources/Public/Icons/tx_igshop2_domain_model_order.gif'
    ],
	'types' => [
		'1' => ['showitem' => 'hidden,--palette--;;1,userid,orderdate,total,is_member,customername,ordermail,orderinfo,paymentmode,payment_method,checkout_reference,checkout_id,cart,submitted,done,shipping_type,shipping_status,shipping_service,shipping,shipping_amount,is_member,total_with_porto,plzort,strasse,paid,is_order,has_billing_address,products,porto,country,country_text,currency,delivery_period,survey,confirmation,--div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access,starttime,endtime'],
	],
	'palettes' => [
		'1' => ['showitem' => ''],
	],
	'columns' => [

		/*'sys_language_uid' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'foreign_table' => 'sys_language',
				'foreign_table_where' => 'ORDER BY sys_language.title',
				'items' => [
					['LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.allLanguages', -1],
					['LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.default_value', 0]
				],
			],
		],
		'l10n_parent' => [
			'displayCond' => 'FIELD:sys_language_uid:>:0',
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'items' => [
					['', 0],
				],
				'foreign_table' => 'tx_igshop2_domain_model_order',
				'foreign_table_where' => 'AND tx_igshop2_domain_model_order.pid=###CURRENT_PID### AND tx_igshop2_domain_model_order.sys_language_uid IN (-1,0)',
			],
		],
		'l10n_diffsource' => [
			'config' => [
				'type' => 'passthrough',
			],
		],*/

		't3ver_label' => [
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'max' => 255,
			]
		],

		'hidden' => [
			'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
			],
		],
        'starttime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],

		'userid' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.userid',
			'config' => [
				'type' => 'number',
				'size' => 4
			]
		],
		'orderdate' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.orderdate',
			'config' => [
				'type' => 'datetime',
				'size' => 7,
				'checkbox' => 1,
				'dbType' => 'datetime'
			],
		],
		'total' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.total',
			'config' => [
				'type' => 'number',
				'size' => 30,
				'format' => 'decimal'
			]
		],
		'customername' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.customername',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'ordermail' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.ordermail',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'orderinfo' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.orderinfo',
			'config' => [
				'type' => 'text',
				'cols' => 40,
				'rows' => 15,
				'eval' => 'trim'
			]
		],
		'paymentmode' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.paymentmode',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'payment_method' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.payment_method',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'foreign_table' => 'tx_igshop2_domain_model_paymentmethod',
				'minitems' => 0,
				'maxitems' => 1,
			],
		],
		'submitted' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.submitted',
			'config' => [
				'type' => 'number',
				'size' => 4
			]
		],
		'done' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.done',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'shipping_type' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.shipping_type',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'shipping_status' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.shipping_status',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'is_member' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.is_member',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'total_with_porto' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.total_with_porto',
			'config' => [
				'type' => 'number',
				'size' => 30,
				'format' => 'decimal'
			]
		],
		'plzort' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.plzort',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'strasse' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.strasse',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'paid' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.paid',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'is_order' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.is_order',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'has_billing_address' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.has_billing_address',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'products' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.products',
			'config' => [
				'type' => 'inline',
				'foreign_table' => 'tx_igshop2_domain_model_orderproduct',
				'foreign_field' => 'tx_order',
				'maxitems'      => 9999,
				'appearance' => [
					'collapseAll' => 0,
					'levelLinksPosition' => 'top',
					'showSynchronizationLink' => 1,
					'showPossibleLocalizationRecords' => 1,
					'showAllLocalizationLink' => 1
				],
			],

		],
		'porto' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.porto',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'foreign_table' => 'tx_igshop2_domain_model_porto',
				'minitems' => 0,
				'maxitems' => 1,
			],
		],
		'country' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.country',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'foreign_table' => 'tx_igshop2_domain_model_country',
				'minitems' => 0,
				'maxitems' => 1,
			],
		],
		'country_text' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.country',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'currency' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.currency',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'foreign_table' => 'tx_igshop2_domain_model_currency',
				'minitems' => 0,
				'maxitems' => 1,
			],
		],
        'delivery_period' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.delivery_period',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igshop2_domain_model_deliveryperiod',
                /*'items' => array(
                    array('LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_state.for_sale', 0),
                ),*/
            ],
        ],
		'survey' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.survey',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectMultipleSideBySide',
				'foreign_table' => 'tx_igshop2_domain_model_survey',
				'MM' => 'tx_igshop2_order_survey_mm',
				'size' => 10,
				'autoSizeMax' => 30,
				'maxitems' => 9999,
				'multiple' => 0,
				'fieldControl' => [
					'editPopup' => [
						'disabled' => false,
						'options' => [
							'title' => 'Umfrage bearbeiten',
						],
					],
					'addRecord' => [
						'disabled' => false,
						'options' => [
							'title' => 'Umfrage hinzufügen',
							'setValue' => 'prepend',
						],
					],
					'listModule' => [
						'disabled' => false,
						'options' => [
							'title' => 'vorhandene Umfragen',
						],
					],
				],
			],
		],
        'confirmation' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.confirmation',
            'config' => $filesConfig,
        ],
		'delivery_date' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.delivery_date',
			'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
                'nullable' => true,
			],
		],
		'checkout_reference' => [
			'exclude' => 1,
			'label' => 'Checkout Referenz',
			'config' => [
				'type' => 'input',
				'size' => 255,
				'eval' => 'trim'
			],
		],
		'checkout_id' => [
			'exclude' => 1,
			'label' => 'Checkout ID',
			'config' => [
				'type' => 'input',
				'size' => 255,
				'eval' => 'trim'
			],
		],
		'shipping_service' => [
			'exclude' => 0,
			'label' => 'Shipping Service',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'items' => [
					['', 0],
				],
				'default' => 0,
				'foreign_table' => 'tx_igshop2_domain_model_shippingservice',
				'foreign_table_where' => 'AND tx_igshop2_domain_model_shippingservice.pid=###CURRENT_PID### AND tx_igshop2_domain_model_shippingservice.sys_language_uid IN (-1,0)',
			],
		],
		'shipping' => [
			'exclude' => 0,
			'label' => 'Shipping',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'items' => [
					['', 0],
				],
				'default' => 0,
				'foreign_table' => 'tx_igshop2_domain_model_shipping',
				'foreign_table_where' => 'AND tx_igshop2_domain_model_shipping.pid=###CURRENT_PID### AND tx_igshop2_domain_model_shipping.sys_language_uid IN (-1,0)',
			],
		],
		'shipping_amount' => [
			'exclude' => 0,
			'label' => 'Shipping Amount',
			'config' => [
				'type' => 'input',
				'size' => 10,
				'eval' => 'double2,null',
				'default' => null,
			],
		],
		'cart' => [
			'exclude' => 1,
			'label' => 'Cart',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'foreign_table' => 'tx_igshop2_domain_model_cart',
			],
		],

	],
];
