<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_paymentmethod',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'sortby' => 'sorting',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,controller,code,description,mailtext,no_porto',
        'iconfile' => 'EXT:igshop2/Resources/Public/Icons/tx_igshop2_domain_model_paymentmethod.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, name, controller, code, description, mailtext, no_porto, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => ['type' => 'language'],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igshop2_domain_model_paymentmethod',
                'foreign_table_where' => 'AND tx_igshop2_domain_model_paymentmethod.pid=###CURRENT_PID### AND tx_igshop2_domain_model_paymentmethod.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],

		'hidden' => [
			'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
			],
		],
        'starttime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'sorting' => [
            'exclude' => 1,
            'l10n_mode' => 'exclude',
            'config' => [
                'type' => 'passthrough'
            ]
        ],
        'name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_paymentmethod.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'controller' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_paymentmethod.controller',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'code' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_paymentmethod.code',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'description' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_paymentmethod.description',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ]
        ],
        'mailtext' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_paymentmethod.mailtext',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ]
        ],
        'no_porto' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_paymentmethod.no_porto',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
                'default' => 0,
            ]
        ],

    ],
];
