<?php
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
if (!defined ('TYPO3')) {
	die ('Access denied.');
}

$GLOBALS['TCA']['tx_igshop2_domain_model_productclass'] = [
	'ctrl' => [
        'title' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_productclass',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',

        'versioningWS' => 2,
        'versioning_followPages' => TRUE,

        'languageField' => 'sys_language_uid',
        'sortby' => 'sorting',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,external_id,category,active,parent,',
        //'dynamicConfigFile' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath($_EXTKEY) . 'Configuration/TCA/Category.php',
        'iconfile' => ExtensionManagementUtility::extPath('igshop2') . 'Resources/Public/Icons/tx_igshop2_domain_model_productclass.gif'
    ],
	'types' => [
		'1' => ['showitem' => 'sys_language_uid,--palette--,l10n_parent,l10n_diffsource,hidden,--palette--;;1,name,external_id,category,hide_in_navigation,hide_in_export,without_porto,parent,products,--div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access,starttime,endtime'],
	],
	'palettes' => [
		'1' => ['showitem' => ''],
	],
	'columns' => [

		'sys_language_uid' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
			'config' => ['type' => 'language'],
		],
		'l10n_parent' => [
			'displayCond' => 'FIELD:sys_language_uid:>:0',
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
			'config' => [
				'type' => 'select',
                'renderType' => 'selectSingle',
				'items' => [
					['label' => '', 'value' => 0],
				],
				'foreign_table' => 'tx_igshop2_domain_model_productclass',
				'foreign_table_where' => 'AND tx_igshop2_domain_model_productclass.pid=###CURRENT_PID### AND tx_igshop2_domain_model_productclass.sys_language_uid IN (-1,0)',
			],
		],
		'l10n_diffsource' => [
			'config' => [
				'type' => 'passthrough',
			],
		],

		't3ver_label' => [
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'max' => 255,
			]
		],
		'sorting' => [
			'exclude' => 1,
			'l10n_mode' => 'exclude',
			'config' => [
                               'type' => 'passthrough'
			]
		],

		'hidden' => [
			'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
			],
		],
        'starttime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],

		'name' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_productclass.name',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],

        'external_id' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_productclass.external_id',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'category' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_productclass',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
		'active' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_productclass.active',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'hide_in_navigation' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_productclass.hide_in_navigation',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'hide_in_export' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_productclass.hide_in_export',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'without_porto' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_productclass.without_porto',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'parent' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_productclass.parent',
			'config' => [
				'type' => 'select',
                'renderType' => 'selectSingle',
				'items' => [ ['label' => '']],
				'renderType' => 'selectSingle',
				'foreign_table' => 'tx_igshop2_domain_model_productclass',
				'minitems' => 0,
				'maxitems' => 1,
			],
		],

        'products' => [
            'exclude' => 1,
	        'l10n_mode' => '',
            'displayCond' => 'FIELD:sys_language_uid:<=:0',
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.products',
	        'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_igshop2_domain_model_product',
                //'foreign_table_where' => 'AND tx_igshop2_domain_model_product.pid=###CURRENT_PID### AND tx_igshop2_domain_model_product.sys_language_uid IN (-1,0)',
                //'foreign_field' => 'uid_foreign',
		        'foreign_sortby' => 'sorting_foreign',
		        /*'foreign_table_field' => 'tablenames',
		        'foreign_match_fields' => [
		            'fieldname' => 'category',
		        ],*/
		        /*'foreign_selector' => 'uid_local',
		        'foreign_label' => 'uid_local',*/
                'MM' => 'tx_igshop2_product_category_mm',
                'MM_opposite_field' => 'uid_foreign',
                'maxitems'      => 9999,
                'appearance' => [
                    'collapseAll' => 1,
                    'levelLinksPosition' => 'top',
                    'showPossibleLocalizationRecords' => 0,
                    'showSynchronizationLink' => 1,
                    'showAllLocalizationLink' => 1,
                    'useSortable' => 1
                ],
                'behaviour' => [
                    'localizationMode' => 'select',
                    'localizeChildrenAtParentLocalization' => true
                ]
            ],

        ],
	],
];
