<?php
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
if (!defined ('TYPO3')) {
	die ('Access denied.');
}

$GLOBALS['TCA']['tx_igshop2_domain_model_reminderlist'] = [
	'ctrl' => [
        'title' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_reminderlist',
        'label' => 'user',
		'label_alt' => 'products',
		'label_alt_force' => true,
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',

        'versioningWS' => 2,
        'versioning_followPages' => TRUE,

        'languageField' => 'sys_language_uid',
        'sortby' => 'sorting',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,external_id,category,active,parent,',
        //'dynamicConfigFile' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath($_EXTKEY) . 'Configuration/TCA/Category.php',
        'iconfile' => ExtensionManagementUtility::extPath('igshop2') . 'Resources/Public/Icons/tx_igshop2_domain_model_reminderlist.gif'
    ],
	'types' => [
		'1' => ['showitem' => 'sys_language_uid,--palette--,l10n_parent,l10n_diffsource,hidden,--palette--;;1,user,products,--div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access,starttime,endtime'],
	],
	'palettes' => [
		'1' => ['showitem' => ''],
	],
	'columns' => [

		'sys_language_uid' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
			'config' => ['type' => 'language'],
		],
		'l10n_parent' => [
			'displayCond' => 'FIELD:sys_language_uid:>:0',
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
			'config' => [
				'type' => 'select',
                'renderType' => 'selectSingle',
				'items' => [
					['label' => '', 'value' => 0],
				],
				'foreign_table' => 'tx_igshop2_domain_model_reminderlist',
				'foreign_table_where' => 'AND tx_igshop2_domain_model_reminderlist.pid=###CURRENT_PID### AND tx_igshop2_domain_model_reminderlist.sys_language_uid IN (-1,0)',
			],
		],
		'l10n_diffsource' => [
			'config' => [
				'type' => 'passthrough',
			],
		],

		't3ver_label' => [
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'max' => 255,
			]
		],
		'sorting' => [
			'exclude' => 1,
			'l10n_mode' => 'exclude',
			'config' => [
                               'type' => 'passthrough'
			]
		],

		'hidden' => [
			'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
			],
		],
        'starttime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],

        'user' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_reminderlist.user',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'fe_users',
                'default' => 0,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'minitems' => 0,
                'maxitems' => 1,
            ],

        ],
		'products' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_reminderlist.products',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectMultipleSideBySide',
				'foreign_table' => 'tx_igshop2_domain_model_product',
				'MM' => 'tx_igshop2_reminderlist_product_mm',
				'size' => 10,
				'autoSizeMax' => 30,
				'maxitems' => 9999,
				'multiple' => 0,
				'fieldControl' => [
					'editPopup' => [
						'disabled' => false,
						'options' => [
							'title' => 'Produkt bearbeiten',
						],
					],
					'addRecord' => [
						'disabled' => false,
						'options' => [
							'title' => 'Produkt hinzufügen',
							'setValue' => 'prepend',
						],
					],
					'listModule' => [
						'disabled' => false,
						'options' => [
							'title' => 'vorhandene Produkte',
						],
					],
				],
			],
		],
	],
];
