<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'sortby' => 'sorting',
        /*'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',*/
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
        ],
        'searchFields' => 'name,shipping_labels',
        'iconfile' => 'EXT:igshop2/Resources/Public/Icons/tx_igshop2_domain_model_shipping.gif',
    ],
    'types' => [
        '1' => ['showitem' => 'name, service, price, currency, min_price, max_price, min_quantity, max_quantity, min_weight, max_weight, shipping_labels, min_length, max_length, min_width, max_width, min_height, max_height, country, cutoff_time, min_handling_time, max_handling_time, min_transit_time, max_transit_time'],
    ],
    'columns' => [
        /*'sys_language_uid' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'language',
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l10n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_igshop2_domain_model_shipping',
                'foreign_table_where' => 'AND tx_igshop2_domain_model_shipping.pid=###CURRENT_PID### AND tx_igshop2_domain_model_shipping.sys_language_uid IN (-1,0)',
                'default' => 0,
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],*/
        'hidden' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        '0' => 'LLL:EXT:core/Resources/Private/Language/locallang_core.xlf:labels.enabled',
                    ],
                ],
            ],
        ],
        'name' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'required' => true,
            ],
        ],
        'service' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.service',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                ],
                'default' => 0,
                'foreign_table' => 'tx_igshop2_domain_model_shippingservice',
                'foreign_table_where' => 'AND tx_igshop2_domain_model_shippingservice.pid=###CURRENT_PID### AND tx_igshop2_domain_model_shippingservice.sys_language_uid IN (-1,0)',
            ],
        ],
        'price' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.price',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2',
                'required' => true,
            ],
        ],
        'currency' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.currency',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                ],
                'default' => 0,
                'foreign_table' => 'tx_igshop2_domain_model_currency',
                'foreign_table_where' => 'AND tx_igshop2_domain_model_currency.pid=###CURRENT_PID### AND tx_igshop2_domain_model_currency.sys_language_uid IN (-1,0)',
            ],
        ],
        'min_price' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.min_price',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'max_price' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.max_price',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'min_quantity' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.min_quantity',
            'config' => [
                'type' => 'input',
                'size' => 5,
                'eval' => 'int,null',
                'default' => null,
            ],
        ],
        'max_quantity' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.max_quantity',
            'config' => [
                'type' => 'input',
                'size' => 5,
                'eval' => 'int,null',
                'default' => null,
            ],
        ],
        'min_weight' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.min_weight',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'max_weight' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.max_weight',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'shipping_labels' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.shipping_labels',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_shippinglabel',
                'MM' => 'tx_igshop2_shipping_shippinglabel_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Versandlabel bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Versandlabel hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Versandlabels',
                        ],
                    ],
                ],

            ],
        ],
        'min_length' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.min_length',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'max_length' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.max_length',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'min_width' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.min_width',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'max_width' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.max_width',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'min_height' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.min_height',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'max_height' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.max_height',
            'config' => [
                'type' => 'input',
                'size' => 10,
                'eval' => 'double2,null',
                'default' => null,
            ],
        ],
        'country' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.country',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                ],
                'default' => 0,
                'foreign_table' => 'tx_igshop2_domain_model_country',
                'foreign_table_where' => 'AND tx_igshop2_domain_model_country.pid=###CURRENT_PID### AND tx_igshop2_domain_model_country.sys_language_uid IN (-1,0)',
            ],
        ],
        'cutoff_time' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.cutoff_time',
            'config' => [
                'type' => 'input',
                'eval' => 'time,null',
                'default' => null,
            ],
        ],
        'min_handling_time' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.min_handling_time',
            'config' => [
                'type' => 'input',
                'size' => 5,
                'eval' => 'int,null',
                'default' => null,
            ],
        ],
        'max_handling_time' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.max_handling_time',
            'config' => [
                'type' => 'input',
                'size' => 5,
                'eval' => 'int,null',
                'default' => null,
            ],
        ],
        'min_transit_time' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.min_transit_time',
            'config' => [
                'type' => 'input',
                'size' => 5,
                'eval' => 'int,null',
                'default' => null,
            ],
        ],
        'max_transit_time' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_shipping.max_transit_time',
            'config' => [
                'type' => 'input',
                'size' => 5,
                'eval' => 'int,null',
                'default' => null,
            ],
        ],
    ],
];
