type ScrollContainer = Window | HTMLElement;
type ScrollContainerProps = {
    scrollTop: number;
    scrollHeight: number;
    clientHeight: number;
    scrollLeft: number;
    scrollWidth: number;
    clientWidth: number;
};
export type Options = {
    /** Adjust the scroll speed so that all elements reach the maximum scroll position at the same time */
    proportional: boolean;
    /** Mirror the vertical scroll position */
    vertical: boolean;
    /** Mirror the horizontal scroll position */
    horizontal: boolean;
};
/**
 * Mirrors the scroll position of multiple elements on a page
 */
export default class ScrollMirror {
    /** Mirror the scroll positions of these elements */
    readonly elements: ScrollContainer[];
    /** The default options */
    readonly defaults: Options;
    /** The parsed options */
    options: Options;
    /** Is mirroring paused? */
    paused: boolean;
    constructor(elements: NodeListOf<Element> | (HTMLElement | Window | null)[], options?: Partial<Options>);
    /** Pause mirroring */
    pause(): void;
    /** Resume mirroring */
    resume(): void;
    /** Destroy. Removes all event handlers */
    destroy(): void;
    /**
     * Get the scroll container, based on element provided:
     * - return the element if it's a child of <body>
     * - otherwise, return the window
     */
    getScrollContainer(el: unknown): ScrollContainer;
    /** Get required properties from either the window or an HTMLElement */
    getProps(element: ScrollContainer): ScrollContainerProps;
}
export {};
//# sourceMappingURL=index.d.ts.map