class IgShopSmallCart {
    constructor(smallCartElement) {
        this.smallCartElement = smallCartElement;
        this.productCountElement = smallCartElement.querySelector('.igshop-ajax-field-count');
        this.ajaxActionCartElement = smallCartElement.querySelector('.igshop-ajax-action-cart');
        this.igshopAjaxFieldCartElement = smallCartElement.querySelector('.igshop-ajax-field-cart');
        this.dropdownHeaderElement = smallCartElement.querySelector('.dropdown_header');
        this.dropdownContentElement = smallCartElement.querySelector('.dropdown_content');
        this.dropdownActionArrowElement = this.dropdownHeaderElement.querySelector('.dropdown_action_arrow');
    }
    init() {
        document.addEventListener('click', (e) => {
            if(!this.smallCartElement.contains(e.target)) {
                this.close();
            }
        });
        this.dropdownHeaderElement.addEventListener('click', this.dropdownHeaderClick.bind(this));
        this.update();
    }

    update(callback) {
        var url = this.ajaxActionCartElement.dataset.smallCartUrl;

        const requestData = new URLSearchParams({
    		'tx_igshop2_fecartsmall[action]':"loadSmallCartData",
    		'tx_igshop2_fecartsmall[controller]':"Order",
    		'type':"1000",
    		'noCache': 1
        });

        let promise = fetch(url, {method: 'POST', body: requestData});
        promise.then((response) => {
            return response.text();
        })
        .then((data) => {
            this.igshopAjaxFieldCartElement.innerHTML = data;

            this.updateCount();
            this.updateAjaxCount();
            
            if(typeof callback !== 'undefined') {
                callback();
            }
        });
    }

    dropdownHeaderClick(e) {
        this.toggle();
    }

    toggle() {
        this.smallCartElement.classList.toggle('open');
        if(this.smallCartElement.classList.contains('open')) {
            this.dropdownHeaderElement.classList.add('active');
            if(this.dropdownActionArrowElement) {
                this.dropdownActionArrowElement.classList.add('dropdown_action_close_arrow');
                this.dropdownActionArrowElement.classList.remove('dropdown_action_open_arrow');
            }
        } else {
            this.dropdownHeaderElement.classList.remove('active');
            if(this.dropdownActionArrowElement) {
                this.dropdownActionArrowElement.classList.add('dropdown_action_open_arrow');
                this.dropdownActionArrowElement.classList.remove('dropdown_action_close_arrow');
            }
        }
    }

    open() {
        if(!this.smallCartElement.classList.contains('open')) {
            this.toggle();
        }
    }

    close() {
        if(this.smallCartElement.classList.contains('open')) {
            this.toggle();
        }
    }

    updateCount() {
        let productListElement = this.smallCartElement.querySelector('.product_list');
        if(productListElement) {
            var count = productListElement.dataset.count;
            this.productCountElement.innerHTML = count;

            for(var propertyName in productListElement.dataset) {
                let propertyValue = productListElement.dataset[propertyName];
                let fieldElement = this.smallCartElement.querySelector('.igshop-ajax-field-' + propertyName);
                if(fieldElement && typeof propertyValue !== 'undefined') {
                    fieldElement.innerHTML = propertyValue;
                }
            }

            // TODO: Verschönern
            if(count > 0) {
                document.querySelector('.tx-igshop2-smallFeCart').classList.add('hasAmount');
            } else {
                document.querySelector('.tx-igshop2-smallFeCart').classList.remove('hasAmount');
            }
        }
    }

    updateAjaxCount() {
        if(typeof igShopAjaxCounts !== 'undefined') {
            igShopAjaxCounts.forEach(function(ajaxCount) {
                ajaxCount.update();
            });
        }
    }
}

var igShopSmallCarts = [];
[...document.querySelectorAll('div.smallCart')].map(function(smallCartElement) {
    let igShopSmallCart = new IgShopSmallCart(smallCartElement);
    igShopSmallCart.init();
    igShopSmallCarts.push(igShopSmallCart);
});

// TODO: Currency change (seit puralpina nicht mehr in Verwendung, habe nirgends zum Testen, von Daher, Sinnhaftigkeit?)