<?php

namespace InternetGalerie\Igshop2\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use InternetGalerie\Igshop2\Domain\Repository\CategoryRepository;
use InternetGalerie\Igshop2\Domain\Repository\ProductRepository;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Backend\Configuration\BackendUserConfiguration;
use TYPO3\CMS\Backend\Template\ModuleTemplateFactory;
use TYPO3\CMS\Backend\Utility\BackendUtility;
use TYPO3\CMS\Core\FormProtection\FormProtectionFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;

//use TYPO3\CMS\Backend\Form\Container\InlineControlContainer;
/**
 * BackendProductController
 */
class BackendProductController extends ActionController
{
    protected ?int $id = 0;

    protected ?int $categoryUid = 0;

    protected string $tableName = 'tx_igshop2_domain_model_product';

    public function __construct(
        protected ModuleTemplateFactory $moduleTemplateFactory,
        protected ProductRepository $productRepository,
        protected CategoryRepository $categoryRepository
    ) {
    }

    /**
     * Action index
     */
    public function indexAction(): ResponseInterface
    {
        $moduleTemplate = $this->moduleTemplateFactory->create($this->request);
        if (!is_null($this->id)) {
            $this->categoryRepository->setDefaultOrderings([
                'name' => QueryInterface::ORDER_ASCENDING,
            ]);

            $searchCategories = $this->categoryRepository->findByPidAndSearchRaw($this->id, null);
            if ($this->request->hasArgument('search')) {
                $search = $this->request->getArgument('search');
            } else {
                $search = [];
            }

            if ($this->categoryUid && !isset($search['category'])) {
                $search['category'] = $this->categoryUid;
            }

            // keep search keywords when we are comming from edit form
            if ($_GET['searchTerm'] ?? false && !isset($search['keywords'])) {
                $search['keywords'] = $_GET['searchTerm'];
            }

            $searchParams = [
                'tx_igshop2_web_igshop2backendproduct' => [
                    'search' => $search,
                ],
            ];

            $selectedCategory = null;
            if (isset($search['category']) && $search['category'] != '') {
                $selectedCategory = $this->categoryRepository->findByUidBackend($search['category']);
            }

            $keywords = null;
            if (isset($search['keywords']) && $search['keywords'] != '') {
                $keywords = $search['keywords'];
            }

            $products = $this->productRepository->findBySearchAndCategoryDoctrine(
                $keywords,
                $selectedCategory,
                $this->id
            );

            $tableRows = [];
            $productCount = count($products);

            for ($i = 0;$i < $productCount;++$i) {
                $product = $products[$i];
                $next = ($i + 1 < $productCount) ? $i + 1 : 0;
                $prev = $i - 2;

                $tableRow = [
                    'product' => $product,
                ];
                $tableRow['uid'] = $product['uid'];
                if (isset($search['category']) && $search['category'] > 0) {
                    $nameObjectFtId = 'data-' . $this->settings['storagePid'] . '-tx_igshop2_domain_model_category-' . intval(
                        $search['category']
                    ) . '-products-tx_igshop2_domain_model_product-' . $product['uid'];
                    $tableRow['data']['sortingIdentifier'] = htmlspecialchars($nameObjectFtId);
                } else {
                    // Move up link: If it should move to the top of the list, page uid is used, else the negative uid of the penultimate entry
                    $tableRow['moveUp'] = $prev < 0 ? $this->id : -$products[$prev]['uid']; // bei $i==0 Wert 0?
                    // Move down link: Negative uid of the next entry
                    $tableRow['moveDown'] = $next ? -$products[$next]['uid'] : 0; // oder $products[$i]['uid']
                }

                $tableRows[] = $tableRow;
            }

            if (isset($search['category']) && $search['category'] > 0) {
                //defVals[tx_igshop2_domain_model_product][productid]=NEWPRODID
                // TCAdefaults.tx_igshop2_domain_model_product.category=2
                $defVals = [
                    $this->tableName => [
                        'category' => $search['category'],
                    ],
                ];
                $tableListWhere = [
                    'category' => $search['category'],
                ];
            } else {
                $defVals = [];
                $tableListWhere = [];
            }


            $moduleTemplate->assignMultiple([
                'tableName' => $this->tableName,
                'pageUid' => $this->id,
                'defVals' => $defVals,
                'search' => $search,
                'searchParams' => $searchParams,
                'tableListWhere' => $tableListWhere,
                'selectedCategory' => $selectedCategory,
                'entryId' => $selectedCategory ? $selectedCategory->getUid() : 0,
                'searchCategories' => $searchCategories,
                'tableRows' => $tableRows,
            ]);
        } else {
            $moduleTemplate->assign('noPidSelected', true);
        }

        return $moduleTemplate->renderResponse('BackendProduct/Index');
    }

    /**
     * Action sortProductsInCategory
     */
    public function sortProductsInCategoryAction(): ResponseInterface
    {
        $search = $this->request->hasArgument('search') ? $this->request->getArgument('search') : [];
        if (!$this->request->hasArgument('direction') || !$this->request->hasArgument(
            'product'
        ) || !isset($search['category'])) {
            die('missing arguments, needs: direction, product, selectedCategory');
        }

        $direction = $this->request->getArgument('direction');
        $productUid = $this->request->getArgument('product');
        $categoryUid = $search['category'];


        $i = 1;
        $products = $this->productRepository->findCategoryRelationDoctrine($categoryUid);
        foreach ($products as $product) {
            if ($product['uid_local'] == $productUid) {
                $product['sorting_foreign'] = $i + ($direction == 'down' ? 3 : -3);
            } else {
                $product['sorting_foreign'] = $i;
            }

            $i += 2;
            $this->productRepository->updateProductCategorySortingDoctrine($product);
        }

        return $this->redirect('index', null, null, [
            'search' => $search,
        ]);
    }

    /**
     * edit category action
     */
    /*
    public function editCategoryAction($category) {
        $this->redirectToEditAction(
            'tx_igshop2_domain_model_category',
            'edit',
            $category->getUid(),
            ['columnsOnly' => 'products'],
            [ 'tx_igshop2_web_igshop2backendproduct[category]' => $category->getUid()]
        );
    }
    */
    /**
     * AJAX call to sort products in a category
     *
     * @return ResponseInterface
     */
    public function ajaxSortProductsInCategory(ServerRequestInterface $request): void
    {
        $data = $request->getParsedBody();
        $identifierArray = explode('-', (string) $data['identifier']);

        $sortList = explode(',', (string) $data['sortList']);
        $categoryUid = $identifierArray[3];

        $i = 1;
        foreach ($sortList as $productUid) {
            $product = $this->productRepository->findProductCategoryRelationDoctrine($productUid, $categoryUid);
            $product['sorting_foreign'] = $i++;
            $this->productRepository->updateProductCategorySortingDoctrine($product);
        }

        die();
    }

    /**
     * Initialize action stores the id
     */
    protected function initializeAction(): void
    {
        /** @var BackendUserConfiguration $backendUserConfiguration */
        $backendUserConfiguration = GeneralUtility::makeInstance(BackendUserConfiguration::class);
        $this->id = $this->request->hasArgument('id') ? (int)$this->request->getArgument('id') : null;
        $this->categoryUid = $this->request->hasArgument('entryId') ? (int)$this->request->getArgument('entryId') : null;

        if ($this->categoryUid === null || $this->id === null) {
            $this->id = (int)$backendUserConfiguration->get('BackendComponents.States.Shop.pageUid');
            $this->categoryUid = (int)$backendUserConfiguration->get('BackendComponents.States.Shop.entryId');
        }

        $backendUserConfiguration->set('BackendComponents.States.Shop.pageUid', $this->id);
        $backendUserConfiguration->set('BackendComponents.States.Shop.entryId', $this->categoryUid);
    }

    /**
     * Get a CSRF token
     *
     * @param bool $tokenOnly Set it to TRUE to get only the token, otherwise including the &moduleToken= as prefix
     */
    protected function getToken($tokenOnly = false): string
    {
        $token = FormProtectionFactory::get()->generateToken('route', 'web_igshop2backendproduct');
        if ($tokenOnly) {
            return $token;
        }

        return '&token=' . $token;
    }

    /**
     * Redirect to tceform creating a new record
     *
     * @param string $table table name
     * @param string $action
     * @param int $uid
     * @param string $additionalParams
     */
    private function redirectToEditAction(
        $table,
        $action,
        $uid,
        $additionalParams = [],
        $additionalParamsReturnUrl = []
    ): ResponseInterface {
        $params = [
            'edit[' . $table . '][' . $uid . ']' => $action,
            'returnUrl' => $this->getReturnUrl($additionalParamsReturnUrl),
        ];
        foreach ($additionalParams as $key => $value) {
            $params[$key] = $value;
        }

        $url = BackendUtility::getModuleUrl('record_edit', $params);
        return $this->redirectToUri($url);
    }

    /**
     * Returns the return url
     *
     * @param array $additionalParams
     */
    private function getReturnUrl($additionalParams = []): string
    {
        return BackendUtility::getModuleUrl(
            'web_Igshop2Backendproduct',
            ([
                'tx_igshop2_web_igshop2backendproduct' => [
                    'search' => $additionalParams,
                ],
                'id' => $this->id,
            ])
        );
    }
}
