<?php

namespace InternetGalerie\Igshop2\Controller;

use Internetgalerie\IgBackendHelpers\Controller\AbstractBackendTableListController;
use InternetGalerie\Igshop2\Domain\Repository\PropertycategoryRepository;
use InternetGalerie\Igshop2\Domain\Repository\PropertyRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Backend\Configuration\BackendUserConfiguration;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class BackendPropertyController extends AbstractBackendTableListController
{
    protected string $tableName = 'tx_igshop2_domain_model_property';
    protected string $indexTemplate = 'Index';
    protected string $entryIdSearchAttribute = 'category';
    // default is 'parent'
    protected PropertyRepository $propertyRepository;

    protected PropertycategoryRepository $propertycategoryRepository;

    public function injectPropertyRepository(PropertyRepository $propertyRepository): void
    {
        $this->propertyRepository = $propertyRepository;
    }

    public function injectPropertycategoryRepositoryRepository(
        PropertycategoryRepository $propertycategoryRepository
    ): void {
        $this->propertycategoryRepository = $propertycategoryRepository;
    }

    public function indexAction(): ResponseInterface
    {
        $moduleTemplate = $this->moduleTemplateFactory->create($this->request);
        $selectedCategory = null;
        if ($this->entryId > 0) {
            //die('S='. $search['entryId']);
            $selectedCategory = $this->propertycategoryRepository->findByUidBackend($this->entryId);
        }

        $backendUserConfiguration = GeneralUtility::makeInstance(BackendUserConfiguration::class);
        if ($this->entryId === null || $this->pageUid === null) {
            $this->pageUid = (int)$backendUserConfiguration->get('BackendComponents.States.Shop.pageUid');
            $this->entryId = (int)$backendUserConfiguration->get('BackendComponents.States.Shop.entryId');
            $selectedCategory = $this->propertycategoryRepository->findByUidBackend($this->entryId);
        }

        $backendUserConfiguration->set('BackendComponents.States.Shop.pageUid', $this->pageUid);
        $backendUserConfiguration->set('BackendComponents.States.Shop.entryId', $this->entryId);
        $defVals = [];
        $where = [];
        if ($selectedCategory) {
            $defVals = [
                $this->tableName => [
                    'category' => $selectedCategory->getUid(),
                ],
            ];
            $where = ['category' => (int)$selectedCategory->getUid()];
        }

        $moduleTemplate->assignMultiple([
            //'defVals' => $defVals,
            'where' => $where,
            'selectedCategory' => $selectedCategory,
            'tableName' => $this->tableName,
        ]);

        //var_dump($defVals, $this->entryId);exit(0);
        //var_dump($defVals, $this->search);
        return $moduleTemplate->renderResponse('BackendProperty/Index');
    }
}
