<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Cart extends AbstractOrder
{
    protected string $productClass= CartProduct::class;

    /**
     * products
     *
     * @var ObjectStorage<CartProduct>
     * @Cascade
     */
    protected $products = null;

    /**
     * Returns the products
     *
     * @return ObjectStorage<CartProduct> $products
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * Adds a OrderProduct
     * 
     * @param CartProduct $product
     */
    public function addProduct($product): void
    {
        $this->products->attach($product);
        $this->mustCalculateTotal = true;
    }

    /**
     * Removes a CartProduct
     *
     * @param CartProduct $productToRemove The CartProduct to be removed
     */
    public function removeProduct($productToRemove): void
    {
        $this->products->detach($productToRemove);
        $this->mustCalculateTotal = true;
    }

    //public function calcTotalWithPorto(){
    public function calculateTotalWithPorto(): void
    {
        $shipping = $this->getShippingCosts();
        if($shipping && $shipping->getPrice() > 0) {
            $this->totalWithPorto = $this->getTotal() + $shipping->getPrice();
        } elseif ($this->getPorto() != null && !$this->hasProductWithoutPorto()) {
            $this->totalWithPorto = $this->getTotal() + $this->getPorto()
            ->getCurrentPrice($this->getTotalProductsPrice(), $this->getTotalProductsCount());
        } else {
            $this->totalWithPorto = $this->getTotal();
        }
    }
    /**
     * Function getSimilarproduct
     *
     * Searches a product who has the same UID and the same options as the given Orderproduct
     * @return mixed Product or false
     */
    public function getSimiliarProduct(AbstractOrderProduct $product)
    {
        foreach ($this->getProducts() as $orderProduct) {
            if ($orderProduct->getProduct() && $product->getProduct() && $orderProduct->getProduct()->getUid() == $product->getProduct()->getUid() && $orderProduct->getProdOptions() == $product->getProdOptions()) {
                return $orderProduct;
            }
        }

        return false;
    }

    /**
     * Adds a Product (entweder neues orderproduct oder falls schon bestehend Anzahl dazu addieren)
     */
    public function addNewProduct(Product $product, $prodLimit, $options = []): void
    {
        $stock = $product->getAvailableStock($this->getUid(), $this->getUserid());
        $newProduct = $this->getProductPosition($product, $prodLimit, $options);
        $similiarProduct = $this->getSimiliarProduct($newProduct);
        $canBeOrdered = true;
        if (isset($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']) && is_array(
            $GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks']
        )) {
            foreach ($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['igshop2_hooks']['hooks'] as $classRef) {
                $hookObj = GeneralUtility::makeInstance($classRef);
                if (method_exists($hookObj, 'checkProductState')) {
                    $canBeOrdered = !$hookObj->checkProductState($product);
                }
            }
        }

        // @todo: Notify user if product is out of stock or other reason, replace all return with error message
        if (!$canBeOrdered) {
            return;
        }
        // Produkt ist neu
        if ($similiarProduct === false) {
            if(!$product->hasStock() || $product->allowsBackorder() || $newProduct->getAmount() <= $stock) {
                $this->addProduct($newProduct);
            } else {
                return; // quantity not allowd
            }
        } else {
            // Produkt schon in Bestellung vorhanden
            // dynamisches limit, gegeben durch input form
            $simAmount = $similiarProduct->getAmount();
            $newProdAmount = $newProduct->getAmount();
            if ($prodLimit) {
                $newAmount = min($prodLimit, $simAmount + $newProdAmount);
            } else {
                $newAmount = $simAmount + $newProdAmount;
            }
            if ($product->getMaxAmount() > 0) {
                $newAmount = min($product->getMaxAmount(), $newAmount);
            }
            if (!$product->hasStock() || $product->allowsBackorder() || ($newAmount <= $stock)) {
                $similiarProduct->setAmount($newAmount);
                $similiarProduct->calcPrice($this->currency, $this->isMember);
            } else {
                return; // quantity not allowd
            }
        }

        $this->setDeliveryPeriod($this->getMaxDeliveryPeriod());
    }

    /**
     * change a Product
     *
     * @return boolean product was deleted
     */
    public function changeProductQuantity(
        $orderProduct,
        $newQuantity
    ) {
        $deleteProduct = false;
        if ($newQuantity <= 0) {
            $deleteProduct = true;
            $this->removeProduct($orderProduct);
        } else {
            //$this->context = GeneralUtility::makeInstance(Context::class);
            //$frontendUserId = $this->context->getPropertyFromAspect('frontend.user', 'id');
            $product = $orderProduct->getProduct();
            if ($product->hasStock()) {
                if (!$product->allowsBackorder()) {
                    $availableStock = $product->getAvailableStock($this->getUid(), $this->getUserid());
                    if ($newQuantity > $availableStock) {
                        $newQuantity = max(0,$availableStock);
                    }
                }
            }
            $orderProduct->setAmount($newQuantity);
            $orderProduct->calcPrice($this->currency, $this->isMember);
            $this->mustCalculateTotal = true;
        }

        return $deleteProduct;
    }
}