<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2015
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * Country
 */
class Country extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * short
     *
     * @var string
     */
    protected $short = '';

    /**
     * currency
     *
     * @var Currency
     */
    protected $currency = null;

    /**
     * dataTrigger
     *
     * @var string
     */
    protected $dataTrigger = '';

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the short
     *
     * @return string
     */
    public function getShort()
    {
        return $this->short;
    }

    /**
     * Sets the short
     *
     * @param string $short
     */
    public function setShort($short): void
    {
        $this->short = $short;
    }

    /**
     * Returns the currency
     *
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * Sets the currency
     */
    public function setCurrency(Currency $currency): void
    {
        $this->currency = $currency;
    }

    /**
     * Returns the dataTrigger
     *
     * @return string
     */
    public function getData()
    {
        return $this->dataTrigger ? [
            'trigger' => $this->dataTrigger,
        ] : [];
    }

    /**
     * Returns the dataTrigger
     *
     * @return string
     */
    public function getDataTrigger()
    {
        return $this->dataTrigger;
    }

    /**
     * Sets the dataTrigger
     *
     * @param string $dataTrigger
     */
    public function setDataTrigger($dataTrigger): void
    {
        $this->dataTrigger = $dataTrigger;
    }

    /**
     * @param int $_languageUid
     */
    public function set_languageUid($_languageUid): void
    {
        $this->_languageUid = $_languageUid;
    }

    /**
     * @return int
     */
    public function get_languageUid()
    {
        return $this->_languageUid;
    }

    /**
     * @param int $_localizedUid
     */
    public function set_localizedUid($_localizedUid): void
    {
        $this->_localizedUid = $_localizedUid;
    }

    /**
     * @return int
     */
    public function get_localizedUid()
    {
        return $this->_localizedUid;
    }
}
