<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2017 FS <fs@internetgalerie.ch>, Internetgalerie
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * FeUser
 */
class FeUser extends FrontendUser
{
    /**
     * @var string
     */
    protected $username = '';

    /**
     * @var string
     */
    protected $password = '';

    /**
     * @var Address
     */
    protected $lastUsedAddress = null;

    /**
     * @var Address
     */
    protected $lastUsedBillingAddress = null;

    /**
     * @var ObjectStorage<Address>
     * @Cascade
     * @Lazy
     */
    protected $addresses = null;

    /**
     * @var Cart
     */
    protected $currentOrder = null;

    /**
     * @var ObjectStorage<Order>
     * @Lazy
     */
    protected $orders = null;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->initStorageObjects();
    }

    /**
     * @return Address
     */
    public function getLastUsedAddress()
    {
        return $this->lastUsedAddress;
    }

    /**
     * @param Address $lastUsedAddress
     */
    public function setLastUsedAddress($lastUsedAddress): void
    {
        $this->lastUsedAddress = $lastUsedAddress;
    }

    /**
     * @return Address
     */
    public function getLastUsedBillingAddress()
    {
        return $this->lastUsedBillingAddress;
    }

    /**
     * @param Address $lastUsedBillingAddress
     */
    public function setLastUsedBillingAddress($lastUsedBillingAddress): void
    {
        $this->lastUsedBillingAddress = $lastUsedBillingAddress;
    }

    /**
     * Returns the addresses
     *
     * @return ObjectStorage<Address> $addresses
     */
    public function getAddresses()
    {
        return $this->addresses;
    }

    /**
     * Sets the addresses
     *
     * @param ObjectStorage<Address> $addresses
     */
    public function setAddresses($addresses): void
    {
        $this->addresses = $addresses;
    }

    /**
     * Adds an address
     *
     * @param Address $address
     */
    public function addAddress($address): void
    {
        $this->addresses->attach($address);
    }

    /**
     * Removes an address
     *
     * @param Address $addressToRemove
     */
    public function removeAddress($addressToRemove): void
    {
        $this->addresses->detach($addressToRemove);
    }

    /**
     * @return Cart
     */
    public function getCurrentOrder()
    {
        return $this->currentOrder;
    }

    /**
     * @param Cart $currentOrder
     */
    public function setCurrentOrder($currentOrder): void
    {
        $this->currentOrder = $currentOrder;
    }

    /**
     * Returns the orders
     *
     * @return ObjectStorage<Order> $orders
     */
    public function getOrders()
    {
        return $this->orders;
    }

    /**
     * Sets the orders
     *
     * @param ObjectStorage<Order> $orders
     */
    public function setOrders($orders): void
    {
        $this->orders = $orders;
    }

    /**
     * Adds an order
     *
     * @param Order $order
     */
    public function addOrder($order): void
    {
        $this->orders->attach($order);
    }

    /**
     * Removes an order
     *
     * @param Order $orderToRemove
     */
    public function removeOrder($orderToRemove): void
    {
        $this->orders->detach($orderToRemove);
    }

    /**
     * Initialize ObjectStorages
     */
    protected function initStorageObjects()
    {
        $this->addresses = new ObjectStorage();
        $this->orders = new ObjectStorage();
    }
}
