<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use InternetGalerie\Igshop2\Domain\Repository\PortopriceRepository;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Porto
 */
class Porto extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * code
     *
     * @var string
     */
    protected $code = '';

    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * price
     *
     * @var float
     */
    protected $price = 0.0;

    /**
     * size
     *
     * @var integer
     */
    protected $size = 0;

    /**
     * shipType
     *
     * @var string
     */
    protected $shipType = '';

    /**
     * priceEuro
     *
     * @var string
     */
    protected $priceEuro = '';

    /**
     * countryAll
     *
     * @var bool
     */
    protected $countryAll = false;

    /**
     * country
     *
     * @var ObjectStorage<Country>
     * @Lazy
     */
    protected $country = null;

    /**
     * prices
     *
     * @var ObjectStorage<Portoprice>
     * @Cascade
     * @Lazy
     */
    protected $prices = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     */
    public function setDescription($description): void
    {
        $this->description = $description;
    }

    /**
     * Returns the price
     *
     * @param float $amount
     * @param integer $quantity
     * @return float
     */
    public function getCurrentDescription($amount, $quantity)
    {
        //echo($amount .','. $quantity);
        $uidLang = GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect(
            'language',
            'id'
        ) > 0 ? $this->_getProperty('_localizedUid') : $this->getUid();

        $portopriceRepository = GeneralUtility::makeInstance(PortopriceRepository::class);
        $price = $portopriceRepository->findCurrentPrice($uidLang, $amount, $quantity);
        //echo('<br />price='.$price .'('.($price ? 'j':'n').')');
        return $price ? $price->getDescription() : $this->getDescription();
    }

    /**
     * Returns the code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Sets the code
     *
     * @param string $code
     */
    public function setCode($code): void
    {
        $this->code = $code;
    }

    /**
     * Returns the price
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Returns the price
     *
     * @param float $amount
     * @param integer $quantity
     * @return float
     */
    public function getCurrentPrice($amount, $quantity)
    {
        $uidLang = GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect(
            'language',
            'id'
        ) > 0 ? $this->_getProperty('_localizedUid') : $this->getUid();
        $portopriceRepository = GeneralUtility::makeInstance(PortopriceRepository::class);
        $price = $portopriceRepository->findCurrentPrice($uidLang, $amount, $quantity);
        //echo('<br />price='.$price .'('.($price ? 'j':'n').')');
        return $price ? $price->getPrice() : $this->getPrice();
    }

    /**
     * Returns the price
     *
     * @param float $amount
     * @param integer $quantity
     * @return float
     */
    public function getCurrentPriceEuro($amount, $quantity)
    {
        $portopriceRepository = GeneralUtility::makeInstance(PortopriceRepository::class);
        $price = $portopriceRepository->findCurrentPrice($this->getUid(), $amount, $quantity);
        //echo('<br />price='.$price .'('.($price ? 'j':'n').')');
        return $price ? $price->getPriceEuro() : $this->getPriceEuro();
    }

    /**
     * Returns the price
     *
     * @param float $amount
     * @param integer $quantity
     * @return float
     */
    public function getNextPrice($amount, $quantity)
    {
        $uidLang = GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect(
            'language',
            'id'
        ) > 0 ? $this->_getProperty('_localizedUid') : $this->getUid();
        $portopriceRepository = GeneralUtility::makeInstance(PortopriceRepository::class);
        $price = $portopriceRepository->findNextPrice($uidLang, $amount, $quantity);
        //echo('<br />price='.$price .'('.($price ? 'j':'n').')=' . $price->getAmountMin());
        return $price ? $price->getAmountMin() : null;
    }

    /**
     * Returns the price
     *
     * @param float $amount
     * @param integer $quantity
     * @return float
     */
    public function getNextPriceEuro($amount, $quantity)
    {
        $portopriceRepository = GeneralUtility::makeInstance(PortopriceRepository::class);
        $price = $portopriceRepository->findNextPrice($this->getUid(), $amount, $quantity);
        //echo('<br />price='.$price .'('.($price ? 'j':'n').')=' . $price->getAmountMin());
        return $price ? $price->getAmountMin() : null;
    }

    /**
     * Sets the price
     *
     * @param float $price
     */
    public function setPrice($price): void
    {
        $this->price = $price;
    }

    /**
     * Returns the size
     *
     * @return integer
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * Sets the size
     *
     * @param integer $size
     */
    public function setSize($size): void
    {
        $this->size = $size;
    }

    /**
     * Returns the shipType
     *
     * @return string
     */
    public function getShipType()
    {
        return $this->shipType;
    }

    /**
     * Sets the shipType
     *
     * @param string $shipType
     */
    public function setShipType($shipType): void
    {
        $this->shipType = $shipType;
    }

    /**
     * Returns the priceEuro
     *
     * @return string
     */
    public function getPriceEuro()
    {
        return $this->priceEuro;
    }

    /**
     * Sets the priceEuro
     *
     * @param string $priceEuro
     */
    public function setPriceEuro($priceEuro): void
    {
        $this->priceEuro = $priceEuro;
    }

    /**
     * Returns the countryAll
     *
     * @return bool
     */
    public function getCountryAll()
    {
        return $this->countryAll;
    }

    /**
     * Sets the countryAll
     *
     * @param bool $countryAll
     */
    public function setCountryAll($countryAll): void
    {
        $this->countryAll = $countryAll;
    }

    /**
     * Returns the boolean state of countryAll
     *
     * @return bool
     */
    public function isCountryAll()
    {
        return $this->countryAll;
    }


    /**
     * Adds a Country
     */
    public function addCountry(Country $country): void
    {
        $this->country->attach($country);
    }

    /**
     * Removes a Country
     *
     * @param Country $countryToRemove The Country to be removed
     */
    public function removeCountry(Country $countryToRemove): void
    {
        $this->country->detach($countryToRemove);
    }

    /**
     * Returns the country
     *
     * @return ObjectStorage<Country> $country
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * Sets the country
     *
     * @param ObjectStorage<Country> $country
     */
    public function setCountry(ObjectStorage $country): void
    {
        $this->country = $country;
    }


    /**
     * test if porto is for given country
     *
     * @param Country $country is Porto valid for given country
     */
    public function hasCountry(Country $country)
    {
        if ($this->countryAll) {
            return true;
        }

        foreach ($this->country as $c) {
            if ($c->getUid() == $country->getUid()) {
                return true;
            }
        }

        return false;
    }

    /**
     * Adds a Portoprice
     */
    public function addPrice(Portoprice $price): void
    {
        $this->prices->attach($price);
    }

    /**
     * Removes a Portoprice
     *
     * @param Portoprice $priceToRemove The Portoprice to be removed
     */
    public function removePrice(Portoprice $priceToRemove): void
    {
        $this->prices->detach($priceToRemove);
    }

    /**
     * Returns the prices
     *
     * @return ObjectStorage<Portoprice> $prices
     */
    public function getPrices()
    {
        return $this->prices;
    }

    /**
     * Sets the prices
     *
     * @param ObjectStorage<Portoprice> $prices
     */
    public function setPrices(ObjectStorage $prices): void
    {
        $this->prices = $prices;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->country = new ObjectStorage();
        $this->prices = new ObjectStorage();
    }
}
