<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2017
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * Portoprice
 */
class Portoprice extends AbstractEntity
{
    /**
     * price
     *
     * @var float
     */
    protected $price = 0.0;

    /**
     * price Euro
     *
     * @var float
     */
    protected $priceEuro = 0.0;

    /**
     * amountMin
     *
     * @var float
     */
    protected $amountMin = 0.0;

    /**
     * amountMax
     *
     * @var float
     */
    protected $amountMax = 0.0;

    /**
     * quantityMin
     *
     * @var integer
     */
    protected $quantityMin = 0;

    /**
     * quantityMax
     *
     * @var integer
     */
    protected $quantityMax = 0;

    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * Returns the price
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Sets the price
     *
     * @param float $price
     */
    public function setPrice($price): void
    {
        $this->price = $price;
    }

    /**
     * Returns the price
     *
     * @return float
     */
    public function getPriceEuro()
    {
        return $this->price;
    }

    /**
     * Sets the priceEuro
     *
     * @param float $price
     */
    public function setPriceEuro($price): void
    {
        $this->price = $price;
    }

    /**
     * Returns the amountMin
     *
     * @return float
     */
    public function getAmountMin()
    {
        return $this->amountMin;
    }

    /**
     * Sets the amountMin
     *
     * @param float $amountMin
     */
    public function setAmountMin($amountMin): void
    {
        $this->amountMin = $amountMin;
    }

    /**
     * Returns the amountMax
     *
     * @return float
     */
    public function getAmountMax()
    {
        return $this->amountMax;
    }

    /**
     * Sets the amountMax
     *
     * @param float $amountMax
     */
    public function setAmountMax($amountMax): void
    {
        $this->amountMax = $amountMax;
    }

    /**
     * Returns the quantityMin
     *
     * @return integer
     */
    public function getQuantityMin()
    {
        return $this->quantityMin;
    }

    /**
     * Sets the quantityMin
     *
     * @param integer $quantityMin
     */
    public function setQuantityMin($quantityMin): void
    {
        $this->quantityMin = $quantityMin;
    }

    /**
     * Returns the quantityMax
     *
     * @return integer
     */
    public function getQuantityMax()
    {
        return $this->quantityMax;
    }

    /**
     * Sets the quantityMax
     *
     * @param integer $quantityMax
     */
    public function setQuantityMax($quantityMax): void
    {
        $this->quantityMax = $quantityMax;
    }

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     */
    public function setDescription($description): void
    {
        $this->description = $description;
    }
}
