<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
/***
 *
 * This file is part of the "Ig Shop" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019
 *
 ***/
/**
 * Property
 */
class Property extends AbstractEntity
{
    protected string $name = '';

    protected string $fieldName = '';

    protected string $unit = '';

    protected string $partial = '';

    protected string $fieldType = '';

    protected string $dbType = '';

    protected ?Propertycategory $category = null;

    protected bool $showInDetailpage = true;

    protected bool $showInFilter = true;

    protected bool $useInComparison = true;

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getUnit(): string
    {
        return $this->unit;
    }

    public function setUnit(string $unit): void
    {
        $this->unit = $unit;
    }

    public function getPartial(): string
    {
        return $this->partial;
    }

    public function setPartial(string $partial): void
    {
        $this->partial = $partial;
    }

    public function getFieldType(): string
    {
        return $this->fieldType;
    }

    public function getDbType(): string
    {
        return $this->dbType;
    }

    public function getCategory(): ?Propertycategory
    {
        return $this->category;
    }

    public function setCategory(?Propertycategory $category): void
    {
        $this->category = $category;
    }

    public function getFieldName(): string
    {
        return $this->fieldName;
    }

    public function setFieldName(string $fieldName): void
    {
        $this->fieldName = $fieldName;
    }

    public function getUseInComparison(): bool
    {
        return $this->useInComparison;
    }

    public function setUseInComparison(bool $useInComparison): void
    {
        $this->useInComparison = $useInComparison;
    }

    public function getShowInDetailpage(): bool
    {
        return $this->showInDetailpage;
    }

    public function setShowInDetailpage(bool $showInDetailpage): void
    {
        $this->showInDetailpage = $showInDetailpage;
    }

    public function getShowInFilter(): bool
    {
        return $this->showInFilter;
    }

    public function setShowInFilter(bool $showInFilter): void
    {
        $this->showInFilter = $showInFilter;
    }

    public function getValueFieldName()
    {
        return match ($this->fieldType) {
            'Checkbox', 'Float' => 'propertyValueNumber',
            'Textarea', 'Rte' => 'propertyValueTextarea',
            default => 'propertyValue',
        };
    }

    protected function setFieldType(string $fieldType): void
    {
        $this->fieldType = $fieldType;
    }

    protected function setDbType(string $dbType): void
    {
        $this->dbType = $dbType;
    }
}
