<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use InternetGalerie\Igshop2\Domain\Model\Currency;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

/**
 * The repository for Currencies
 */
class CurrencyRepository extends Repository
{
    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * Gives the Currency set in constants
     * @return Currency
     */
    public function getDefaultCurrency()
    {
        $query = $this->createQuery();
        $query->matching($query->equals('isDefault', 1));
        return $query->execute()
->getFirst();
    }

    /**
     * Gets Currency which is saved in Session
     * @return Currency
     */
    public function getSessionCurrency()
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $request = $GLOBALS['TYPO3_REQUEST'];
        $frontendUser = $request->getAttribute('frontend.user');
        $selectedCurrency = intval($frontendUser->getKey('ses', 'selectedCurrency'));

        if ($selectedCurrency <= 0) {
            return false;
        }

        $query = $this->createQuery();
        $query->matching($query->equals('uid', $selectedCurrency));

        $queryResult = $query->execute();

        if ($queryResult->count() > 0) { //if order valid, eg after submit is session !=0 but active order not present.
            return $queryResult->getFirst();
        }

        return false;
    }

    public function findAllAssociative()
    {
        $currencies = $this->findAll();

        $ret = [];

        foreach ($currencies as $currency) {
            $ret[$currency->getShort()] = $currency;
        }

        return $ret;
    }

    public function findAllForPrices()
    {
        return $this->findAll();
    }

    /**
     * First, it searches for Session Currency. If this is empty, the function
     * searches for the defaultCurrency
     *
     * @return Currency
     */
    public function getCurrency()
    {
        // if a currency is already set, return it
        $sessionCurrency = $this->getSessionCurrency();
        if ($sessionCurrency) {
            return $sessionCurrency;
        }

        // else set default Currency (constants) to session and return this
        $defaultCurrency = $this->getDefaultCurrency();
        $this->setSessionCurrency($defaultCurrency->getUid());
        return $defaultCurrency;
    }

    /**
     * Saves the Currency in the session
     * @param int $currencyId
     */
    public function setSessionCurrency($currencyId): void
    {
        $request = $GLOBALS['TYPO3_REQUEST'];
        $frontendUser = $request->getAttribute('frontend.user');
        $frontendUser->setKey('ses', 'selectedCurrency', $currencyId);
        $frontendUser->storeSessionData();
    }
}
