<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use Doctrine\DBAL\ParameterType;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * The repository for Orders
 */
class OrderRepository extends AbstractOrderRepository
{
    protected string $sessionName = 'shopOrder';

    public function getTotalProductsAmount($orderUid): int
    {
        $total = 0;
        $qb = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igshop2_domain_model_orderproduct');
        $total = $qb->selectLiteral('CASE WHEN SUM(op.amount) > 0 THEN SUM(op.amount) ELSE 0 END AS sum_amount')
            ->from('tx_igshop2_domain_model_orderproduct', 'op')
            ->where(
                $qb->expr()->eq('tx_order', $qb->createNamedParameter($orderUid, ParameterType::INTEGER))
            )
            ->executeQuery()
            ->fetchAssociative();

        return $total['sum_amount'];
    }
}
