<?php

namespace InternetGalerie\Igshop2\PageTitle;

use TYPO3\CMS\Core\PageTitle\AbstractPageTitleProvider;
use InternetGalerie\Igshop2\Domain\Repository\CategoryRepository;
use InternetGalerie\Igshop2\Domain\Repository\ProductRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class PageTitleProvider extends AbstractPageTitleProvider
{
    public function __construct()
    {
        $get = $GLOBALS['TYPO3_REQUEST']->getQueryParams()['tx_igshop2_feshop'] ?? null;
        if (!$get) {
            $get = $GLOBALS['TYPO3_REQUEST']->getQueryParams()['tx_igshop2_feshopshow'] ?? null;
        }

        if (is_array($get)) {
            if (isset($get['category']) && $get['category'] > 0) {
                $categoryRepository = GeneralUtility::makeInstance(CategoryRepository::class);
                $category = $categoryRepository->findByUid($get['category']);
                $this->title = $category->getName();
            }

            if (isset($get['product']) && $get['product'] > 0) {
                $productRepository = GeneralUtility::makeInstance(ProductRepository::class);
                $product = $productRepository->findByUid($get['product']);
                $this->title = $product->getName();
            }
        }
    }
}
